<?php
namespace App\Repositories;

use stdClass;
use Exception;
use PDOException;

use Carbon\Carbon;

use App\Repositories\StatementInterface;

class Statement implements StatementInterface
{
	/**
	 * --------------------------------------------------
	 * @param $keys
	 * @param $orders
	 * @param $table
	 * --------------------------------------------------
	 */
	public function get($keys, $orders, $table)
	{
		try {

			$result = \DB::table($table);

			if($keys) {

				$result = $result->where($keys);
			}

			if($orders) {

				foreach($orders as $key => $value) {

					$result = $result->orderBy($key, $value);
				}
			}

			$result = $result->get();

			//echo '<pre>';print_r($result);die();
			return json_decode(json_encode($result), true);
		}
		catch(PDOException $e) {
			throw $e;
		}
	}

	/**
	 * --------------------------------------------------
	 * @param $keys
	 * @param $orders
	 * @param $table
	 * --------------------------------------------------
	 */
	public function dropdown($field, $keys, $orders , $table)
	{
		try {

			// get list
			$list = $this->get($keys, $orders, $table);

			$result = [];

			if($list) {

				foreach($list as $key => $value) {

					$i = current(array_slice((array) $value, 0, 1, true));

					if(empty($field)) {

						$k = current(array_slice((array) $value, 0, 1, true));
						$v = current(array_slice((array) $value, 1, 1, true));

						$result[$k] = $v;
					}

					else {

						$result[$i] = $value->$field;
					}
				}
			}

			//echo '<pre>';print_r($result);die();
			return json_decode(json_encode($result), true);
		}
		catch(PDOException $e) {
			throw $e;
		}
	}

	/**
	 * --------------------------------------------------
	 * @param $keys
	 * @param $table
	 * --------------------------------------------------
	 */
	public function first($keys, $table)
	{
		try {

			$result = \DB::table($table);

			if($keys) {

				$result = $result->where($keys);
			}

			$result = $result->first();

			//echo '<pre>';print_r($result);die();
			return json_decode(json_encode($result), true);
		}
		catch(PDOException $e) {
			throw $e;
		}
	}

	/**
	 * --------------------------------------------------
	 * @param $field
	 * @param $keys
	 * @param $table
	 * --------------------------------------------------
	 */
	public function field($field, $keys, $table)
	{
		try {

			$result = \DB::table($table);

			if($keys) {

				$result = $result->where($keys);
			}

			$result = $result->value($field);

			//echo '<pre>';print_r($result);die();
			return json_decode(json_encode($result), true);
		}
		catch(PDOException $e) {
			throw $e;
		}
	}

	/**
	 * --------------------------------------------------
	 * @param $field
	 * @param $keys
	 * @param $table
	 * --------------------------------------------------
	 */
	public function max($field, $keys, $table)
	{
		try {

			$result = \DB::table($table);

			if($keys) {

				$result = $result->where($keys);
			}

			$result = $result->max($field) + 1;

			//echo '<pre>';print_r($result);die();
			return json_decode(json_encode($result), true);
		}
		catch(PDOException $e) {
			throw $e;
		}
	}

	/**
	 * --------------------------------------------------
	 * @param $field
	 * @param $keys
	 * @param $table
	 * --------------------------------------------------
	 */
	public function min($field, $keys, $table)
	{
		try {

			$result = \DB::table($table);

			if($keys) {

				$result = $result->where($keys);
			}

			$result = $result->min($field);

			//echo '<pre>';print_r($result);die();
			return json_decode(json_encode($result), true);
		}
		catch(PDOException $e) {
			throw $e;
		}
	}

	/**
	 * --------------------------------------------------
	 * @param $keys
	 * @param $table
	 * --------------------------------------------------
	 */
	public function count($keys, $table)
	{
		try {

			$result = \DB::table($table);

			if($keys) {

				$result = $result->where($keys);
			}

			$result = $result->count();

			//echo '<pre>';print_r($result);die();
			return json_decode(json_encode($result), true);
		}
		catch(PDOException $e) {
			throw $e;
		}
	}

	/**
	 * --------------------------------------------------
	 * @param $values
	 * @param $table
	 * --------------------------------------------------
	 */
	public function insert($values, $table)
	{
		$return = \DB::table($table)
			->insertGetId($values);

		//echo '<pre>';print_r($return);die();
		return $return;
	}

	/**
	 * --------------------------------------------------
	 * @param $values
	 * @param $table
	 * --------------------------------------------------
	 */
	public function inserts($values, $table)
	{
		return \DB::table($table)
			->insert($values);
	}

	/**
	 * --------------------------------------------------
	 * @param $keys
	 * @param $values
	 * @param $table
	 * --------------------------------------------------
	 */
	public function update($keys, $values, $table)
	{
		//$values['date_updated'] = Carbon::now()->toDateTimeString();

		return \DB::table($table)
			->where($keys)
			->update($values);
	}

	/**
	 * --------------------------------------------------
	 * @param $keys
	 * @param $table
	 * --------------------------------------------------
	 */
	public function delete($keys, $table)
	{
		return \DB::table($table)
			->where($keys)
			->delete();
	}

	/**
	 * --------------------------------------------------
	 * @param $table
	 * --------------------------------------------------
	 */
	public function truncate($table)
	{
		return \DB::table($table)
			->truncate();
	}

	/**
	 * --------------------------------------------------
	 * @param $sql
	 * --------------------------------------------------
	 */
	public function excute($sql)
	{
		return \DB::statement($sql);
	}

	/**
	 * --------------------------------------------------
	 * @param $sql
	 * @param $params
	 * --------------------------------------------------
	 */
	public function select($sql, $params)
	{
		$result = \DB::select($sql, $params);

		return json_decode(json_encode($result), true);
	}

	/**
	 * --------------------------------------------------
	 * @param $sql
	 * @param $params
	 * --------------------------------------------------
	 */
	public function selectOne($sql, $params)
	{
		$result = \DB::selectOne($sql, $params);

		return json_decode(json_encode($result), true);
	}
}
