<?php

namespace App\Repositories;

interface StatementInterface
{
	/**
	 * --------------------------------------------------
	 * @param $keys
	 * @param $orders
	 * @param $table
	 * --------------------------------------------------
	 */
	public function get($keys, $orders, $table);

	/**
	 * --------------------------------------------------
	 * @param $keys
	 * @param $orders
	 * @param $table
	 * --------------------------------------------------
	 */
	public function dropdown($field, $keys, $orders, $table);

	/**
	 * --------------------------------------------------
	 * @param $keys
	 * @param $table
	 * --------------------------------------------------
	 */
	public function first($keys, $table);

	/**
	 * --------------------------------------------------
	 * @param $field
	 * @param $keys
	 * @param $table
	 * --------------------------------------------------
	 */
	public function field($field, $keys, $table);

	/**
	 * --------------------------------------------------
	 * @param $field
	 * @param $keys
	 * @param $table
	 * --------------------------------------------------
	 */
	public function max($field, $keys, $table);

	/**
	 * --------------------------------------------------
	 * @param $field
	 * @param $keys
	 * @param $table
	 * --------------------------------------------------
	 */
	public function min($field, $keys, $table);

	/**
	 * --------------------------------------------------
	 * @param $keys
	 * @param $table
	 * --------------------------------------------------
	 */
	public function count($keys, $table);

	/**
	 * --------------------------------------------------
     * @param $values
     * @param $table
     * --------------------------------------------------
     */
    public function insert($values, $table);

	/**
	 * --------------------------------------------------
     * @param $values
     * @param $table
     * --------------------------------------------------
     */
    public function inserts($values, $table);

    /**
     * --------------------------------------------------
     * @param $keys
     * @param $values
     * @param $table
     * --------------------------------------------------
     */
    public function update($keys, $values, $table);

    /**
     * --------------------------------------------------
     * @param $keys
     * @param $table
     * --------------------------------------------------
     */
    public function delete($keys, $table);

    /**
     * --------------------------------------------------
     * @param $table
     * --------------------------------------------------
     */
    public function truncate($table);

    /**
     * --------------------------------------------------
     * @param $sql
     * --------------------------------------------------
     */
    public function excute($sql);

    /**
     * --------------------------------------------------
     * @param $sql
     * @param $params
     * --------------------------------------------------
     */
    public function select($sql, $params);

    /**
     * --------------------------------------------------
     * @param $sql
     * @param $params
     * --------------------------------------------------
     */
    public function selectOne($sql, $params);
}
