<?php

namespace App\Repositories;

use stdCgetCourseListlass,
	Exception,
	PDOException,
	Carbon\Carbon;

// use interface
use App\Repositories\ViewInterface;

class View implements ViewInterface
{
	public function __construct()
	{
		//
	}


	/**
	 * ==================================================
	 * common
	 * ==================================================
	 */

	/**
	 * --------------------------------------------------
	 * @param unknown $key
	 * @param unknown $value
	 * @param unknown $table
	 * --------------------------------------------------
	 */
	public function getLabelList($key, $value, $table)
	{
		try {
			$result = \DB::table(\DB::raw("(SELECT * FROM $this->mtb_language WHERE is_disabled = 0) AS $this->mtb_language"))
				->select(
					"$table.*",
					"$this->mtb_language.mtb_language_id",
					"$this->mtb_language.language_code",
					"$this->mtb_language.language_label"
				)

				// left join to table
				->leftJoinSub((\DB::table($table)->where($key, $value)), $table, function($join) use ($table) {
					$join->on("$this->mtb_language.mtb_language_id", '=', "$table.mtb_language_id");
				})
				->get();

			// echo '<pre>';print_r($result);die();
			return $result;
		}
		catch(PDOException $e) {
			throw $e;
		}
	}


	/**
	 * ==================================================
	 * booking
	 * ==================================================
	 */

	/**
	 * --------------------------------------------------
	 * @param array $keys
	 * @param array $orders
	 * @param array $options
	 * --------------------------------------------------
	 */
	public function getBookingList($keys, $orders, $options)
	{
		try {
			$result = \DB::table('dtb_booking')
				->select(

					// dtb_booking
					'dtb_booking.*',

					// dtb_staff
					'dtb_staff.staff_sname',
					'dtb_staff.staff_gname',

					// mtb_vaccine
					'mtb_vaccine.vaccine_label',

					// mtb_municipality
					'mtb_municipality.ward_name',
				)

				// join to dtb_staff
				->leftJoin('dtb_staff', 'dtb_staff.dtb_staff_id', '=', 'dtb_booking.dtb_staff_id')

				// join to mtb_vaccine
				->leftJoin('mtb_vaccine', 'mtb_vaccine.mtb_vaccine_id', '=', 'dtb_booking.mtb_vaccine_id')

				// join to mtb_municipality
				->leftJoin('mtb_municipality', 'mtb_municipality.municipality_code', '=', 'dtb_booking.number3');

			// set keys
			if($keys) {
				$result = $result->where($keys);
			}

			// set orders
			if($orders) {
				foreach($orders as $key => $value) {
					$result = $result->orderBy($key, $value);
				}
			}

			// get result
			$result = $result->get();

			$result = json_decode(json_encode($result), true);

			//echo '<pre>';print_r($result);die();
			return $result;
		}
		catch(PDOException $e) {
			throw $e;
		}
	}

	/**
	 * --------------------------------------------------
	 * @param array $keys
	 * --------------------------------------------------
	 */
	public function getBooking($keys)
	{
		try {
			$result = \DB::table('dtb_booking')
				->select(

					// dtb_booking
					'dtb_booking.*',

					// dtb_staff
					'dtb_staff.staff_sname',
					'dtb_staff.staff_gname',

					// mtb_pref
					'mtb_pref.pref_label',

					// mtb_vaccine
					'mtb_vaccine.vaccine_label',

					// mtb_municipality
					'mtb_municipality.ward_name',
				)

				// join to dtb_staff
				->leftJoin('dtb_staff', 'dtb_booking.dtb_staff_id', '=', 'dtb_staff.dtb_staff_id')

				// join to mtb_pref
				->leftJoin('mtb_pref', 'dtb_booking.mtb_pref_id', '=', 'mtb_pref.mtb_pref_id')

				// join to mtb_vaccine
				->leftJoin('mtb_vaccine', 'dtb_booking.mtb_vaccine_id', '=', 'mtb_vaccine.mtb_vaccine_id')

				// join to mtb_municipality
				->leftJoin('mtb_municipality', 'dtb_booking.number3', '=', 'mtb_municipality.municipality_code');

			// set keys
			if($keys) {
				$result = $result->where($keys);
			}

			// get result
			$result = $result->first();

			$result = json_decode(json_encode($result), true);

			// dd($result);
			return $result;
		}
		catch(PDOException $e) {
			throw $e;
		}
	}

	/**
	 * --------------------------------------------------
	 * @param array $keys
	 * --------------------------------------------------
	 */
	public function getBookingCountList($keys)
	{
		//echo '<pre>';print_r($keys);die();

		try {

			// initialized
			$result = [];

			// set where
			$where = [
				'`is_booked` = 1',
				'`yy` = ?',
				'`mm` = ?',
			];

			// groupby
			$groupby = [
				'`yy`',
				'`mm`',
				'`dd`',
			];

			// params
			$params = [
				$keys['yy'],
				$keys['mm'],
			];

			if(isset($keys['mtb_vaccine_id'])) {

				$where = array_merge($where, [
					'`mtb_vaccine_id` = ?',
				]);

				$groupby = array_merge($groupby, [
					'`mtb_vaccine_id`',
				]);

				$params = array_merge($params, [
					$keys['mtb_vaccine_id'],
				]);
			}
			//echo '<pre>';print_r($where);die();
			//echo '<pre>';print_r($groupby);die();
			//echo '<pre>';print_r($params);die();

			$sql = "
				SELECT
					`yy`,
					`mm`,
					`dd`,
					COUNT(`dtb_booking_id`) AS `booking_numbers`,
					SUM(CASE WHEN `is_checkedin` = 1 THEN 1 ELSE 0 END) AS `checkedin_numbers`
				FROM
					`dtb_booking`
				WHERE
					" . implode(' AND ', $where) . "
				GROUP BY
					" . implode(', ', $groupby);
			//echo '<pre>';print_r($sql);die();

			$return = \DB::select(
				$sql,
				$params
			);

			$return = json_decode(json_encode($return), true);
			//echo '<pre>';print_r($return);die();

			if($return) {

				foreach($return as $key => $value) {

					$result[$value['dd']] = $value;
				}
			}

			//echo '<pre>';print_r($result);die();
			return $result;
		}
		catch(PDOException $e) {
			throw $e;
		}
	}

	/**
	 * --------------------------------------------------
	 * @param array $keys
	 * --------------------------------------------------
	 */
	public function getBookingCountListByDay($keys)
	{
		try {
			$result = [];

			$sql = "
				SELECT
					yy,
					mm,
					dd,
					hh,
					ii,
					COUNT(dtb_booking_id) AS cnt
				FROM
					dtb_booking
				WHERE
					yy = ? AND
					mm = ? AND
					dd = ? AND
					is_booked = ?
				GROUP BY
					yy,
					mm,
					dd,
					hh,
					ii
				ORDER BY
					yy ASC,
					mm ASC,
					dd ASC,
					hh ASC,
					ii ASC";

			$params = [
				$keys['yy'],
				$keys['mm'],
				$keys['dd'],
				$keys['is_booked'],
			];

			$result = \DB::select(
				$sql,
				$params
			);
			$result = json_decode(json_encode($result), true);

			//echo '<pre>';print_r($result);die();
			return $result;
		}
		catch(PDOException $e) {
			throw $e;
		}
	}

	/**
	 * --------------------------------------------------
	 * @param array $keys
	 * --------------------------------------------------
	 */
	public function getBookingStatusCountList($keys, $orders, $options)
	{
		//echo '<pre>';print_r($keys);die();

		try {
			$result = \DB::table('dtb_booking')
				->select(

					// dtb_booking
					'yy',
					'mm',
					'dd',
				)

				// as booking_numbers
				->selectRaw('COUNT(dtb_booking_id) as booking_numbers')

				// as checkedin_numbers
				->selectRaw('SUM(CASE WHEN `is_checkedin` = 1 THEN 1 ELSE 0 END) as checkedin_numbers');

			// set keys
			if($keys) {
				$result = $result->where($keys);
			}

			// set options
			if($options) {

				// groupBy
				if(isset($options['groupby'])) $result = $result->groupBy($options['groupby']);
			}

			// get result
			$result = $result->first();

			$result = json_decode(json_encode($result), true);

			//echo '<pre>';print_r($result);die();
			return $result;
		}
		catch(PDOException $e) {
			throw $e;
		}

		// $sql = "
		//     SELECT
		//         `yy`,
		//         `mm`,
		//         `dd`,
		//         COUNT(`dtb_booking_id`) AS `booking_numbers`,
		//         SUM(CASE WHEN `is_checkedin` = 1 THEN 1 ELSE 0 END) AS `checkedin_numbers`
		//     FROM
		//         `dtb_booking`
		//     WHERE
		//         `yy` = ? AND
		//         `mm` = ? AND
		//         `dd` = ? AND
		//     GROUP BY
		//         `yy`,
		//         `mm`,
		//         `dd`;";
	}


	/**
	 * ==================================================
	 * date
	 * ==================================================
	 */

	/**
	 * --------------------------------------------------
	 * @param array $keys
	 * @param array $orders
	 * @param array $options
	 * --------------------------------------------------
	 */
	public function getDateList($keys, $orders, $options)
	{
		try {
			$result = \DB::table('mtb_date')
				->select(

					// mtb_date
					'mtb_date.*',

					// mtb_vaccine
					'mtb_vaccine.vaccine_label',
				)

				// join to mtb_vaccine
				->leftJoin('mtb_vaccine', 'mtb_vaccine.mtb_vaccine_id', '=', 'mtb_date.mtb_vaccine_id');

			// set keys
			if($keys) {
				$result = $result->where($keys);
			}

			// set orders
			if($orders) {
				foreach($orders as $key => $value) {
					$result = $result->orderBy($key, $value);
				}
			}

			// get result
			$result = $result->get();

			$result = json_decode(json_encode($result), true);

			//echo '<pre>';print_r($result);die();
			return $result;
		}
		catch(PDOException $e) {
			throw $e;
		}
	}

	/**
	 * --------------------------------------------------
	 * @param array $keys
	 * --------------------------------------------------
	 */
	public function getDate($keys)
	{
		try {
			$result = \DB::table('mtb_date')
				->select(

					// mtb_date
					'mtb_date.*',

					// mtb_vaccine
					'mtb_vaccine.vaccine_label',
				)

				// join to mtb_vaccine
				->leftJoin('mtb_vaccine', 'mtb_vaccine.mtb_vaccine_id', '=', 'mtb_date.mtb_vaccine_id');

			// set keys
			if($keys) {
				$result = $result->where($keys);
			}

			// get result
			$result = $result->first();

			$result = json_decode(json_encode($result), true);

			//echo '<pre>';print_r($result);die();
			return $result;
		}
		catch(PDOException $e) {
			throw $e;
		}
	}

	/**
	 * --------------------------------------------------
	 * @param array $keys
	 * --------------------------------------------------
	 */
	public function getMinDate($keys)
	{
		try {

			// initialized
			$having = [];

			if(isset($keys['mtb_vaccine_id'])) {

				$having = array_merge($having, [
					'`mtb_date`.`mtb_vaccine_id` = ?',
				]);
			}

			$having = implode(' AND ', array_merge($having, [
				'`mtb_date`.`date` >= ?',
				'`accepted_numbers` > `booking_count`',
			]));
			//echo '<pre>';print_r($having);die();

			// initialized
			$params = [];

			if(isset($keys['mtb_vaccine_id'])) {

				$params = array_merge($params, [
					$keys['mtb_vaccine_id'],
				]);
			}

			$params = array_merge($params, [
				$keys['date']
			]);
			//echo '<pre>';print_r($params);die();

			$sql = "
				SELECT
					`mtb_date`.*,
					(SELECT COUNT(*) FROM `dtb_booking` AS `T1` WHERE `T1`.`yy` = `mtb_date`.`yy` AND `T1`.`mm` = `mtb_date`.`mm` AND `T1`.`dd` = `mtb_date`.`dd` AND `T1`.`is_booked` = 1) as `booking_count`
				FROM
					`mtb_date`
				HAVING ({$having})
				ORDER BY `date` ASC
			";
			//echo '<pre>';print_r($sql);die();

			$result = \DB::selectOne(
				$sql,
				$params
			);
			$result = json_decode(json_encode($result), true);

			//echo '<pre>';print_r($result);die();
			return $result;

			//$result = \DB::table('mtb_date')
			//    ->select(

			//		// mtb_date
			//		'mtb_date.*',

			//		// dtb_booking
			//		\DB::raw("(SELECT COUNT(*) FROM `dtb_booking` AS `T1` WHERE `T1`.`yy` = `mtb_date`.`yy` AND `T1`.`mm` = `mtb_date`.`mm` AND `T1`.`dd` = `mtb_date`.`dd` AND `T1`.`is_booked` = 1) as `booking_count`"),
			//	);

			//// set keys
			//if($keys) {
			//    $keys = array_merge($keys, [
			//        ['accepted_number', '>', 'booking_count'],
			//    ]);
			//    //echo '<pre>';print_r($keys);die();

			//	$result = $result->having($keys);
			//}

			//// get result
			//$result = $result->get();

			//$result = json_decode(json_encode($result), true);

			//echo '<pre>';print_r($result);die();
			//return $result;
		}
		catch(PDOException $e) {
			throw $e;
		}
	}


	/**
	 * ==================================================
	 * form
	 * ==================================================
	 */

	/**
	 * --------------------------------------------------
	 * @param array $keys
	 * @param array $orders
	 * @param array $options
	 * --------------------------------------------------
	 */
	public function getFormList($keys = [], $orders = [], $options = [])
	{
		try {
			$result = \DB::table('dtb_form')
				->select(

					// dtb_form
					'dtb_form.*',

					// mtb_form
					'mtb_form.form_label',
					'mtb_form.subform1_label',
					'mtb_form.subform2_label',
					'mtb_form.subform3_label',
					'mtb_form.is_subform1',
					'mtb_form.is_input_group1',
					'mtb_form.is_subform2',
					'mtb_form.is_input_group2',
					'mtb_form.is_subform3',
					'mtb_form.is_input_group3',
				)

				// join to mtb_form
				->leftJoin('mtb_form', 'dtb_form.mtb_form_id', '=', 'mtb_form.mtb_form_id');

			// set keys
			if($keys) {
				
				$result = $result->where($keys);
			}

			// set orders
			if($orders) {
				
				foreach($orders as $key => $value) {
					
					$result = $result->orderBy($key, $value);
				}
			}

			// get result
			$result = $result->get();

			$result = json_decode(json_encode($result), true);

			// dd($result);
			return $result;
		}
		catch(\PDOException $e) {
			throw $e;
		}
	}


	/**
	 * ==================================================
	 * time
	 * ==================================================
	 */

	/**
	 * --------------------------------------------------
	 * @param array $keys
	 * @param array $orders
	 * @param array $options
	 * --------------------------------------------------
	 */
	public function getTimeList($keys, $orders, $options)
	{
		try {
			$result = \DB::table('mtb_time')
				// mtb_time
				->select(

					// mtb_time
					'mtb_time.*',

					// mtb_date
					'mtb_date.yy',
					'mtb_date.mm',
					'mtb_date.dd',
					'mtb_date.accepted_numbers',
				)

				// join to mtb_date
				->leftJoin('mtb_date', 'mtb_date.mtb_date_id', '=', 'mtb_time.mtb_date_id');

			// set keys
			if($keys) {
				$result = $result->where($keys);
			}

			// set orders
			if($orders) {
				foreach($orders as $key => $value) {
					$result = $result->orderBy($key, $value);
				}
			}

			// get result
			$result = $result->get();

			$result = json_decode(json_encode($result), true);

			//echo '<pre>';print_r($result);die();
			return $result;
		}
		catch(PDOException $e) {
			throw $e;
		}
	}


	/**
	 * ==================================================
	 * staff
	 * ==================================================
	 */

	/**
	 * --------------------------------------------------
	 * @param array $keys
	 * @param array $orders
	 * @param array $options
	 * --------------------------------------------------
	 */
	public function getStaffList($keys, $orders, $options)
	{
		try {
			$result = \DB::table('dtb_staff')
				->select(

					// dtb_staff
					'dtb_staff.*',

					// mtb_division
					'mtb_division.division_label',
				)

				// join to mtb_division
				->leftJoin('mtb_division', 'dtb_staff.mtb_division_id', '=', 'mtb_division.mtb_division_id');

			// set keys
			if($keys) {
				$result = $result->where($keys);
			}

			// set orders
			if($orders) {
				foreach($orders as $key => $value) {
					$result = $result->orderBy($key, $value);
				}
			}

			// get result
			$result = $result->get();

			$result = json_decode(json_encode($result), true);

			//echo '<pre>';print_r($result);die();
			return $result;
		}
		catch(PDOException $e) {
			throw $e;
		}
	}

	/**
	 * --------------------------------------------------
	 * @param array $keys
	 * --------------------------------------------------
	 */
	public function getStaff($keys)
	{
		try {
			$result = \DB::table('dtb_staff')
				->select(

					// dtb_staff
					'dtb_staff.*',

					// mtb_division
					'mtb_division.division_label',
				)

				// join to mtb_division
				->leftJoin('mtb_division', 'dtb_staff.mtb_division_id', '=', 'mtb_division.mtb_division_id');

			// set keys
			if($keys) {
				$result = $result->where($keys);
			}

			// get result
			$result = $result->first();

			$result = json_decode(json_encode($result), true);

			//echo '<pre>';print_r($result);die();
			return $result;
		}
		catch(PDOException $e) {
			throw $e;
		}
	}
}
