<?php

namespace App\Repositories;

interface ViewInterface
{
	/**
	 * ==================================================
	 * common
	 * ==================================================
	 */

	/**
	 * --------------------------------------------------
	 * @param unknown $key
	 * @param unknown $value
	 * @param unknown $table
	 * --------------------------------------------------
	 */
	public function getLabelList($key, $value, $table);


	/**
	 * ==================================================
	 * booking
	 * ==================================================
	 */

	/**
	 * --------------------------------------------------
	 * @param array $keys
	 * @param array $orders
	 * @param array $options
	 * --------------------------------------------------
	 */
	public function getBookingList($keys, $orders, $options);

	/**
	 * --------------------------------------------------
	 * @param array $keys
	 * --------------------------------------------------
	 */
	public function getBooking($keys);

	/**
	 * --------------------------------------------------
	 * @param array $keys
	 * --------------------------------------------------
	 */
	public function getBookingCountList($keys);

	/**
	 * --------------------------------------------------
	 * @param array $keys
	 * --------------------------------------------------
	 */
	public function getBookingCountListByDay($keys);

	/**
	 * --------------------------------------------------
	 * @param array $keys
	 * @param array $orders
	 * @param array $options
	 * --------------------------------------------------
	 */
	public function getBookingStatusCountList($keys, $orders, $options);


	/**
	 * ==================================================
	 * date
	 * ==================================================
	 */

	/**
	 * --------------------------------------------------
	 * @param array $keys
	 * @param array $orders
	 * @param array $options
	 * --------------------------------------------------
	 */
	public function getDateList($keys, $orders, $options);

	/**
	 * --------------------------------------------------
	 * @param array $keys
	 * --------------------------------------------------
	 */
	public function getDate($keys);

	/**
	 * --------------------------------------------------
	 * @param array $keys
	 * --------------------------------------------------
	 */
	public function getMinDate($keys);


	/**
	 * ==================================================
	 * form
	 * ==================================================
	 */

	/**
	 * --------------------------------------------------
	 * @param array $keys
	 * @param array $orders
	 * @param array $options
	 * --------------------------------------------------
	 */
	public function getFormList($keys = [], $orders = [], $options = []);


	/**
	 * ==================================================
	 * time
	 * ==================================================
	 */

	/**
	 * --------------------------------------------------
	 * @param array $keys
	 * @param array $orders
	 * @param array $options
	 * --------------------------------------------------
	 */
	public function getTimeList($keys, $orders, $options);


	/**
	 * ==================================================
	 * staff
	 * ==================================================
	 */

	/**
	 * --------------------------------------------------
	 * @param array $keys
	 * @param array $orders
	 * @param array $options
	 * --------------------------------------------------
	 */
	public function getStaffList($keys, $orders, $options);

	/**
	 * --------------------------------------------------
	 * @param array $keys
	 * --------------------------------------------------
	 */
	public function getStaff($keys);
}
