<?php

namespace App\Services;

use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Http;
use Exception;

// use components
use GuzzleHttp\Client,
	Carbon\Carbon,
	Config,
	Session,
	App\Helper;

// use repository interfaces
use App\Repositories\Statement,
	App\Repositories\View;

class Booking extends Service implements BookingInterface
{
	protected
		$statement,
		$view;

	/**
	 * --------------------------------------------------
	 * @param object $statement
	 * @param object $view
	 * --------------------------------------------------
	 */
	public function __construct(
		Statement $statement,
		View $view
	) {
		$this->statement = $statement;
		$this->view = $view;
	}

	/**
	 * ==================================================
	 * booking
	 * ==================================================
	 */

	/**
	 * --------------------------------------------------
	 * @param array $keys
	 * @param array $orders
	 * @param array $options
	 * --------------------------------------------------
	 */
	public function getBookingList($keys = [], $orders = [], $options = [])
	{
		$result = $this->view->getBookingList(
			$keys,
			$orders,
			$options
		);

		// $result = $this->statement->get(
		// 	$keys,
		// 	$orders,
		// 	$table = 'dtb_booking'
		// );

		//echo '<pre>';print_r($result);die();
		return $result;
	}

	/**
	 * --------------------------------------------------
	 * @param array $keys
	 * --------------------------------------------------
	 */
	public function getBooking($keys)
	{
		$result = $this->view->getBooking(
			$keys
		);

		// $result = $this->statement->first(
		// 	$keys,
		// 	$table = 'dtb_booking'
		// );

		//echo '<pre>';print_r($result);die();
		return $result;
	}

	/**
	 * --------------------------------------------------
	 * @param array $data
	 * --------------------------------------------------
	 */
	public function storeBooking($data)
	{
		//echo '<pre>';print_r($data);die();

		// initialized
		$values = [];

		// set column_list
		$column_list = [
			'qr_number',
			'voucher_number',
			'shots_number',
			'patient_skana',
			'patient_gkana',
			'tel',
			'mobile',
			'is_booked',
			'is_cancel',
			'is_checkedin',
			'is_pencil',
			'is_web',
			'is_walkin',
			'is_staff',
			'is_disease',
			'yy',
			'mm',
			'dd',
			'hh',
			'ii',
			'mtb_vaccine_id',
		];

		/**
		 * --------------------------------------------------
		 * from frontdesk
		 * --------------------------------------------------
		 */
		if($data['action'] == 'checkedin') {
			//die('checkedin');
			//echo '<pre>';print_r($data);die();

			// convert
			$data['booking']['qr_number'] = mb_convert_kana($data['booking']['qr_number'], 'n');
			//echo '<pre>';print_r($data);die();

			// get length
			$length = mb_strlen($data['booking']['qr_number']);
			//echo '<pre>';print_r($length);die();

			// set number_list
			if($length == 18) {

				$number_list = Helper::analyzeQrNumber(
					$data['booking']['qr_number']
				);
			}
			else {

				$number_list = [
					'qr_number' => "00000000{$data['booking']['qr_number']}",
					'voucher_number' => $data['booking']['qr_number'],
					'number1' => '0',
					'number2' => '0',
					'number3' => '000000',
				];
			}
			//echo '<pre>';print_r($number_list);die();

			$data['booking'] = $this->getBooking(
				$keys = [
					['dtb_booking.voucher_number', '=', $number_list['voucher_number']],
					['dtb_booking.yy', '=', $data['yy']],
					['dtb_booking.mm', '=', $data['mm']],
					['dtb_booking.dd', '=', $data['dd']],
				]
			);
			//echo '<pre>';print_r($data['booking']);die();

			if(is_null($data['booking'])) return null;

			$values['qr_number'] = $number_list['qr_number'];
			$values['voucher_number'] = $number_list['voucher_number'];
			$values['number1'] = $number_list['number1'];
			$values['number2'] = $number_list['number2'];
			$values['number3'] = $number_list['number3'];
			$values['timestamp_checkedin'] = Carbon::now()->toDateTimeString();
			$values['is_checkedin'] = 1;
			//echo '<pre>';print_r($values);die();
		}

		else {

			/**
			 * --------------------------------------------------
			 * from frontend
			 * --------------------------------------------------
			 */
			if($data['booking']['is_web']) {
				//die('frontend');

				// set session
				Session::put('booking.is_booked', $data['booking']['is_booked']);
				Session::put('booking.is_web', $data['booking']['is_web']);
				//echo '<pre>';print_r(Session::all());die();

				foreach ($column_list as $column) {

					if(Session::get("booking.{$column}") !== null) {

						$values[$column] = Session::get("booking.{$column}");
					}
				}
				//echo '<pre>';print_r($values);die();

				// set numbers
				if(isset($values['qr_number'])) {
					$values = array_merge($values, [
						'number1' => mb_substr($values['qr_number'], 0, 1),
						'number2' => mb_substr($values['qr_number'], 1, 2),
						'number3' => mb_substr($values['qr_number'], 2, 6),
					]);
				}
				//echo '<pre>';print_r($values);die();

				// set date_last
				$values['date_last'] = Carbon::create(
					Session::get('date_last.yy'),
					Session::get('date_last.mm'),
					Session::get('date_last.dd')
				)->ToDateString();
				//echo '<pre>';print_r($values);die();

				// set birthday
				$values['birthday'] = Carbon::create(
					Session::get('birthday.yy'),
					Session::get('birthday.mm'),
					Session::get('birthday.dd')
				)->ToDateString();
				//echo '<pre>';print_r($values);die();

				// set time with meridiem
				$values = array_merge($values, [
					'booking_code' => Session::get('booking.booking_code'),
					'timestamp' => Carbon::now()->toDateTimeString(),
					'is_pm' => Helper::getMeridiem(
						Session::get('booking.hh'),
						Session::get('booking.ii')
					),
				]);
				//echo '<pre>';print_r($values);die();
			}

			/**
			 * --------------------------------------------------
			 * from backend
			 * --------------------------------------------------
			 */
			else {
				//die('backend');
				//echo '<pre>';print_r($data);die();

				foreach ($column_list as $column) {

					if(isset($data['booking'][$column])) {

						$values[$column] = $data['booking'][$column];
					}
				}

				// convert to kana
				$values['patient_skana'] = Helper::convert2Kana($values['patient_skana']);
				$values['patient_gkana'] = Helper::convert2Kana($values['patient_gkana']);
				//echo '<pre>';print_r($values);die();

				// sanitize number
				if(isset($values['mobile'])) {

					$values['mobile'] = Helper::sanitizeNumber($values['mobile']);
					//echo '<pre>';print_r($values['mobile']);die();
				}

				// set date_last
				// $values['date_last'] = Carbon::create(
				// 	$data['date_last']['yy'],
				// 	$data['date_last']['mm'],
				// 	$data['date_last']['dd'],
				// )->ToDateString();
				// dd($values);

				// set birthday
				$values['birthday'] = Carbon::create(
					$data['birthday']['yy'],
					$data['birthday']['mm'],
					$data['birthday']['dd'],
				)->ToDateString();
				//echo '<pre>';print_r($values);die();

				// get time
				$time = $this->statement->first(
					$keys = [
						['mtb_time_id', '=', $data['booking']['mtb_time_id']],
					],
					$table = 'mtb_time'
				);
				//echo '<pre>';print_r($time);die();

				// marge values
				$values = array_merge($values, [
					'timestamp' => Carbon::now()->toDateTimeString(),
					'is_pm' => Helper::getMeridiem(
						$time['hh'],
						$time['ii'],
					),
					'is_booked' => 1,
					'hh' => $time['hh'],
					'ii' => $time['ii'],
					'dtb_staff_id' => Session::get('staff.dtb_staff_id'),
					'_token' => Session::get('_token'),
					'agent_device' => $data['agent']['agent_device'],
					'agent_platform' => $data['agent']['agent_platform'],
					'agent_platform_version' => $data['agent']['agent_platform_version'],
					'agent_browser' => $data['agent']['agent_browser'],
					'agent_browser_version' => $data['agent']['agent_browser_version'],
					'agent_ip' => $data['agent']['agent_ip'],
					'agent_host' => $data['agent']['agent_host'],
					'is_agent_mobile' => $data['agent']['is_agent_mobile'],
					'is_agent_tablet' => $data['agent']['is_agent_tablet'],
					'is_agent_desktop' => $data['agent']['is_agent_desktop'],
					'is_agent_robot' => $data['agent']['is_agent_robot'],
				]);
				//echo '<pre>';print_r($values);die();
			}
		}

		// checking values
		//echo '<pre>';print_r($values);die();

		/**
		 * --------------------------------------------------
		 * insert
		 * --------------------------------------------------
		 */
		if(is_null($data['booking']['booking_code'])) {
			//die('insert');
			//echo '<pre>';print_r($data['booking']);die();

			// set booking_code
			$data['booking']['booking_code'] = Helper::createRandomKey(128);
			$data['booking']['signin_code'] = Helper::createRandomKey(16);

			// marge values
			$values = array_merge($values, [
				'booking_code' => $data['booking']['booking_code'],
				'signin_code' => $data['booking']['signin_code'],
			]);
			//echo '<pre>';print_r($values);die();

			$data['booking']['dtb_booking_id'] = $this->statement->insert(
				$values,
				$table = 'dtb_booking'
			);
			//echo '<pre>';print_r($data['booking']);die();

			//echo '<pre>';print_r($data['booking']);die();
			return array_merge($data['booking'], [
				'hh' => $values['hh'],
				'ii' => $values['ii'],
			]);
		}

		/**
		 * --------------------------------------------------
		 * update
		 * --------------------------------------------------
		 */
		else {
			//die('update');
			//echo '<pre>';print_r($data);die();

			$return = $this->statement->update(
				$keys = [
					['booking_code', '=', $data['booking']['booking_code']],
				],
				$values,
				$table = 'dtb_booking'
			);
			//echo '<pre>';print_r($return);die();

			if($return) {

				// get booking
				$data['booking'] = $this->getBooking(
					$keys = [
						['booking_code', '=', $data['booking']['booking_code']],
					]
				);
				//echo '<pre>';print_r($data['booking']);die();

				return $data['booking'];
			}

			else {

				return $return;
			}
		}
	}

	/**
	 * --------------------------------------------------
	 * @param array $keys
	 * --------------------------------------------------
	 */
	public function getBookingCountList($keys)
	{
		//echo '<pre>';print_r($data);die();

		// initialized
		$result = [];

		// set date_list_keys
		$date_list_keys = [
			['yy', '=', $keys['yy']],
			['mm', '=', $keys['mm']],
		];

		// set dd
		if(isset($keys['dd'])) {

			$date_list_keys = array_merge($date_list_keys, [
				['dd', '>=', $keys['dd']],
			]);
		}
		//echo '<pre>';print_r($date_list_keys);die();

		// set mtb_vaccine_id
		if(isset($keys['mtb_vaccine_id'])) {

			$date_list_keys = array_merge($date_list_keys, [
				['mtb_vaccine_id', '=', $keys['mtb_vaccine_id']],
			]);
		}
		//echo '<pre>';print_r($date_list_keys);die();

		// get date_list
		$date_list = $this->statement->get(
			$date_list_keys,
			$orders = [
				'yy' => 'ASC',
				'mm' => 'ASC',
				'dd' => 'ASC'
			],
			$table = 'mtb_date'
		);
		//echo '<pre>';print_r($date_list);die();

		// get booking_list
		$booking_list = $this->view->getBookingCountList(
			$keys,
		);
		//echo '<pre>';print_r($booking_list);die();

		// processig data
		foreach($date_list as $date) {

			$result[$date['dd']]['accepted_numbers'] = $date['accepted_numbers'];
			$result[$date['dd']]['mtb_vaccine_id'] = $date['mtb_vaccine_id'];

			if(isset($booking_list[$date['dd']])) {

				$result[$date['dd']]['booking_numbers'] = $booking_list[$date['dd']]['booking_numbers'];
				$result[$date['dd']]['remain_numbers'] = $date['accepted_numbers'] - $booking_list[$date['dd']]['booking_numbers'];
				$result[$date['dd']]['checkedin_numbers'] = $booking_list[$date['dd']]['checkedin_numbers'];
				$result[$date['dd']]['uncheckedin_numbers'] = $result[$date['dd']]['booking_numbers'] - $result[$date['dd']]['checkedin_numbers'];
			}

			else {

				$result[$date['dd']]['booking_numbers'] = 0;
				$result[$date['dd']]['remain_numbers'] = $result[$date['dd']]['accepted_numbers'];
				$result[$date['dd']]['checkedin_numbers'] = 0;
				$result[$date['dd']]['uncheckedin_numbers'] = 0;
			}
		}

		//echo '<pre>';print_r($result);die();
		return $result;
	}

	/**
	 * --------------------------------------------------
	 * @param array $keys
	 * @param array $orders
	 * @param array $options
	 * --------------------------------------------------
	 */
	public function getBookingStatusCountList($keys, $orders, $options)
	{
		//echo '<pre>';print_r($keys);die();

		$result = $this->view->getBookingStatusCountList(
			$keys,
			$orders,
			$options
		);
		//echo '<pre>';print_r($result);die();

		if(is_null($result)) {

			$result = [
				'yy' => $keys[0][2],
				'mm' => $keys[1][2],
				'dd' => $keys[2][2],
				'booking_numbers' => 0,
				'checkedin_numbers' => 0,
				'uncheckedin_numbers' => 0,
			];
		}

		else {

			// set uncheckedin_numbers
			$result['uncheckedin_numbers'] = $result['booking_numbers'] - $result['checkedin_numbers'];
		}
		//echo '<pre>';print_r($result);die();

		//echo '<pre>';print_r($result);die();
		return $result;
	}

	/**
	 * --------------------------------------------------
	 * @param array $date
	 * @param array $time_list
	 * @param array $booking_list
	 * --------------------------------------------------
	 */
	public function setBookingList($date, $time_list, $booking_list)
	{
		//echo '<pre>';print_r($date);die();
		//echo '<pre>';print_r($time_list);die();
		//echo '<pre>';print_r($booking_list);die();

		// initialized
		$result = [];

		/**
		 * --------------------------------------------------
		 * processing as all
		 * --------------------------------------------------
		 */

		foreach($booking_list as $key => $value) {

			// get time
			$time = Carbon::create(
				$date['yy'],
				$date['mm'],
				$date['dd'],
				$value['hh'],
				$value['ii']
			)->format('H:i');
			//echo '<pre>';print_r($time);die();

			// set time
			$booking_list[$key]['time'] = $time;

			// set age
			$booking_list[$key]['age'] = Helper::getAge(Carbon::parse($value['birthday'])->format('Y-m-d'));
		}
		//echo '<pre>';print_r($booking_list);die();

		// set all
		$result[0] = $booking_list;

		foreach($time_list as $key => $value) {
			//echo '<pre>';print_r($key);die();
			// dd($value);die();

			if($key != 0) {
				//echo '<pre>';print_r($value);die();

				//$result[0][$is_pm][$time] = [];
				$result[$value[0]] = [];
			}
		}
		// dd($result);

		foreach($booking_list as $key => $value) {
			// dd($value);

			$result[$value['hh']][] = $value;
		}
		// dd($result);

		return $result;
	}

	/**
	 * --------------------------------------------------
	 * @param string $voucher_number
	 * --------------------------------------------------
	 */
	public function validateVoucherNumber(string $voucher_number)
	{
		//echo '<pre>';print_r($voucher_number);die();

		// initialized
		$result = true;

		$return = $this->statement->count(
			$keys = [
				['voucher_number', '=', $voucher_number],
			],
			$table = 'dtb_booking'
		);
		//echo '<pre>';print_r($return);die();

		if ($return > 0) $result = false;

		//echo '<pre>';var_dump($result);die();
		return $result;
	}

	/**
	 * --------------------------------------------------
	 * @param array $data
	 * --------------------------------------------------
	 */
	public function setSession($data)
	{
		// dd(session()->all());
		// dd($data);

		if (isset($data['booking']['mobile'])) $data['booking']['mobile'] = mb_convert_kana($data['booking']['mobile'], 'n');
		if (isset($data['booking']['zip'])) $data['booking']['zip'] = mb_convert_kana($data['booking']['zip'], 'n');
		// echo '<pre>';print_r($data);die();

		foreach($data as $key => $value) {
			//echo '<pre>';print_r($key);die();
			//echo '<pre>';print_r($key);die();
			//echo '<pre>';print_r($value);die();

			if(Session::get($key) !== null) {
				//die('exist');

				// as booking
				if(is_array($value)) {
					//echo '<pre>';print_r($value);die();

					foreach ($value as $k => $v) {

						Session::put("{$key}.{$k}", $v);
					}
				}

				// as not booking
				else {

					Session::put($key, $value);
				}
			}

			else {
				//die('not exist');

				Session::put($key, $value);
			}
		}
		// dd(session()->all());

		// check session
		// dd(session()->all());
	}


	/**
	 * ==================================================
	 * booking2
	 * ==================================================
	 */

	/**
	 * --------------------------------------------------
	 * @param array $data
	 * --------------------------------------------------
	 */
	public function storeBooking2($data)
	{
		// dd(session()->all());
		// dd($data);

		// initialized
		$values = [];

		// set column_list
		$column_list = [
			'patient_sname',
			'patient_gname',
			'patient_skana',
			'patient_gkana',
			'tel',
			'mobile',
			'gender',
			'zip',
			'address1',
			'address2',
			'address3',
			'is_booked',
			'is_cancel',
			'is_checkedin',
			'is_pencil',
			'is_web',
			'is_walkin',
			'is_staff',
			'is_disease',
			'is_form',
			'yy',
			'mm',
			'dd',
			'hh',
			'ii',
			'mtb_pref_id',
			'mtb_vaccine_id',
		];

		/**
		 * --------------------------------------------------
		 * from frontdesk
		 * --------------------------------------------------
		 */
		if($data['action'] == 'checkedin') {
			// dd('checkedin');
			// dd($data);

			// convert
			// $data['booking']['qr_number'] = mb_convert_kana($data['booking']['qr_number'], 'n');
			// dd($data);die();

			// get length
			$length = mb_strlen($data['booking']['qr_number']);
			// dd($length);

			// set number_list
			if($length == 16) {

				// $number_list = Helper::analyzeQrNumber(
				// 	$data['booking']['qr_number']
				// );
			}
			else {

				// $number_list = [
				// 	'qr_number' => "00000000{$data['booking']['qr_number']}",
				// 	'voucher_number' => $data['booking']['qr_number'],
				// 	'number1' => '0',
				// 	'number2' => '0',
				// 	'number3' => '000000',
				// ];
			}
			//echo '<pre>';print_r($number_list);die();

			// for text
			$data['yy'] = 2024;
			$data['mm'] = 10;
			$data['dd'] = 19;

			$data['booking'] = $this->getBooking(
				$keys = [
					['dtb_booking.signin_code', '=', $data['booking']['qr_number']],
					['dtb_booking.yy', '=', $data['yy']],
					['dtb_booking.mm', '=', $data['mm']],
					['dtb_booking.dd', '=', $data['dd']],
				]
			);
			// dd($data['booking']);

			if(is_null($data['booking'])) return null;

			// $values['qr_number'] = $number_list['qr_number'];
			// $values['voucher_number'] = $number_list['voucher_number'];
			// $values['number1'] = $number_list['number1'];
			// $values['number2'] = $number_list['number2'];
			// $values['number3'] = $number_list['number3'];
			$values['timestamp_checkedin'] = Carbon::now()->toDateTimeString();
			$values['is_checkedin'] = 1;
			// dd($values);
		}

		else {

			/**
			 * --------------------------------------------------
			 * from frontend
			 * --------------------------------------------------
			 */
			if($data['booking']['is_web']) {
				// dd('frontend');

				// set session
				session()->put('booking.is_booked', $data['booking']['is_booked']);
				session()->put('booking.is_web', $data['booking']['is_web']);
				// dd(session()->all());

				foreach ($column_list as $column) {

					if(session()->get("booking.{$column}") !== null) {

						$values[$column] = session()->get("booking.{$column}");
					}
				}
				// dd($values);

				// set birthday
				$values['birthday'] = Carbon::create(
					Session::get('birthday.yy'),
					Session::get('birthday.mm'),
					Session::get('birthday.dd')
				)->ToDateString();
				// dd($values);

				// set time with meridiem
				$values = array_merge($values, [
					'booking_code' => Session::get('booking.booking_code'),
					'timestamp' => Carbon::now()->toDateTimeString(),
					'is_pm' => Helper::getMeridiem(
						Session::get('booking.hh'),
						Session::get('booking.ii')
					),
				]);
				// dd($values);
			}

			/**
			 * --------------------------------------------------
			 * from backend
			 * --------------------------------------------------
			 */
			else {
				// dd('backend');

				foreach ($column_list as $column) {

					if(isset($data['booking'][$column])) {

						$values[$column] = $data['booking'][$column];
					}
				}

				// convert to kana
				// $values['patient_skana'] = Helper::convert2Kana($values['patient_skana']);
				// $values['patient_gkana'] = Helper::convert2Kana($values['patient_gkana']);
				// dd($values);

				// sanitize number
				if(isset($values['mobile'])) {

					$values['mobile'] = Helper::sanitizeNumber($values['mobile']);
					// dd($values['mobile']);
				}

				// set birthday
				$values['birthday'] = Carbon::create(
					$data['birthday']['yy'],
					$data['birthday']['mm'],
					$data['birthday']['dd'],
				)->ToDateString();
				// dd($values);

				// get time
				$time = $this->statement->first(
					$keys = [
						['mtb_time_id', '=', $data['booking']['mtb_time_id']],
					],
					$table = 'mtb_time'
				);
				// dd($time);

				// marge values
				$values = array_merge($values, [
					'timestamp' => Carbon::now()->toDateTimeString(),
					'is_pm' => Helper::getMeridiem(
						$time['hh'],
						$time['ii'],
					),
					'is_booked' => 1,
					'hh' => $time['hh'],
					'ii' => $time['ii'],
					'dtb_staff_id' => Session::get('staff.dtb_staff_id'),
					'_token' => Session::get('_token'),
					'agent_device' => $data['agent']['agent_device'],
					'agent_platform' => $data['agent']['agent_platform'],
					'agent_platform_version' => $data['agent']['agent_platform_version'],
					'agent_browser' => $data['agent']['agent_browser'],
					'agent_browser_version' => $data['agent']['agent_browser_version'],
					'agent_ip' => $data['agent']['agent_ip'],
					'agent_host' => $data['agent']['agent_host'],
					'is_agent_mobile' => $data['agent']['is_agent_mobile'],
					'is_agent_tablet' => $data['agent']['is_agent_tablet'],
					'is_agent_desktop' => $data['agent']['is_agent_desktop'],
					'is_agent_robot' => $data['agent']['is_agent_robot'],
				]);
				// dd($values);
			}
		}

		// checking values
		// dd($values);

		// dd($data['booking']);

		/**
		 * --------------------------------------------------
		 * insert
		 * --------------------------------------------------
		 */
		if(is_null($data['booking']['booking_code'])) {
			// dd('insert');
			// dd($data['booking']);

			// set booking_code
			$data['booking']['booking_code'] = Helper::createRandomKey(128);
			$data['booking']['signin_code'] = Helper::createRandomKey(16);

			// marge values
			$values = array_merge($values, [
				'booking_code' => $data['booking']['booking_code'],
				'signin_code' => $data['booking']['signin_code'],
			]);
			// dd($values);

			$data['booking']['dtb_booking_id'] = $this->statement->insert(
				$values,
				$table = 'dtb_booking'
			);
			// dd($data['booking']['dtb_booking_id']);

			// dd($data['booking']);
			return array_merge($data['booking'], [
				'hh' => $values['hh'],
				'ii' => $values['ii'],
			]);
		}

		/**
		 * --------------------------------------------------
		 * update
		 * --------------------------------------------------
		 */
		else {
			// dd('update');
			// dd($data);

			$return = $this->statement->update(
				$keys = [
					['booking_code', '=', $data['booking']['booking_code']],
				],
				$values,
				$table = 'dtb_booking'
			);
			// dd($return);

			if($return) {

				// get booking
				$data['booking'] = $this->getBooking(
					$keys = [
						['booking_code', '=', $data['booking']['booking_code']],
					]
				);
				// dd($data['booking']);

				return $data['booking'];
			}

			else {

				return $return;
			}
		}
	}


	/**
	 * ==================================================
	 * form
	 * ==================================================
	 */

	/**
	 * --------------------------------------------------
	 * @param array $keys
	 * @param array $orders
	 * @param array $options
	 * --------------------------------------------------
	 */
	public function getFormList($keys = [], $orders = [], $options = [])
	{
		$result = $this->view->getFormList(
			$keys,
			$orders,
			$options
		);

		// dd($result);
		return $result;
	}

	/**
	 * --------------------------------------------------
	 * @param array $data
	 * --------------------------------------------------
	 */
	public function storeForm($data)
	{
		// dd($data);
		// dd(session()->all());

		foreach (session()->get('form') as $key => $value) {
			// dd($value['value']);

			$values = [
				'value' => $value['value'],
				'subform1' => (isset($value['subform1'])) ? $value['subform1'] : null,
				'subform2' => (isset($value['subform2'])) ? $value['subform2'] : null,
				'subform3' => (isset($value['subform3'])) ? $value['subform3'] : null,
				'dtb_booking_id' => $data['booking']['dtb_booking_id'],
				'mtb_form_id' => $key,
			];
			// dd($values);

			// get form
			$form = $this->statement->first(
				$keys = [
					['dtb_booking_id', '=', $data['booking']['dtb_booking_id']],
					['mtb_form_id', '=', $key],
				],
				$table = 'dtb_form'
			);
			// dd($form);

			if ($form) {
				// dd('update');

				$this->statement->update(
					$keys,
					$values,
					$table = 'dtb_form'
				);
			}

			else {
				// dd('insert');

				$this->statement->insert(
					$values,
					$table = 'dtb_form'
				);
			}
		}

		return;
	}


	/**
	 * ==================================================
	 * pencil
	 * ==================================================
	 */

	/**
	 * --------------------------------------------------
	 * @param array $data
	 * --------------------------------------------------
	 */
	public function storePencil($data)
	{
		//echo '<pre>';print_r(Session::all());die();
		//echo '<pre>';print_r($data);die();

		// set booking_code
		Session::put(
			'booking.booking_code',
			Helper::createRandomKey(128)
		);

		// set values
		$values = [
			'booking_code' => Session::get('booking.booking_code'),
			'signin_code' => Helper::createRandomKey(16),
			//'hash_code' => md5(Session::get('booking.booking_code')),
			'yy' => Session::get('booking.yy'),
			'mm' => Session::get('booking.mm'),
			'dd' => Session::get('booking.dd'),
			'hh' => Session::get('booking.hh'),
			'ii' => Session::get('booking.ii'),
			'date_last' => Carbon::create(
				Session::get('date_last.yy'),
				Session::get('date_last.mm'),
				Session::get('date_last.dd'),
			)->toDateString(),
			'shots_number' => Session::get('booking.shots_number'),
			'is_pm' => Helper::getMeridiem(
				Session::get('booking.hh'),
				Session::get('booking.ii')
			),
			'is_pencil' => 1,
			'is_web' => 1,
			'mtb_vaccine_id' => Session::get('booking.mtb_vaccine_id'),
			'_token' => Session::get('_token'),
			'agent_device' => $data['agent']['agent_device'],
			'agent_platform' => $data['agent']['agent_platform'],
			'agent_platform_version' => $data['agent']['agent_platform_version'],
			'agent_browser' => $data['agent']['agent_browser'],
			'agent_browser_version' => $data['agent']['agent_browser_version'],
			'agent_ip' => $data['agent']['agent_ip'],
			'agent_host' => $data['agent']['agent_host'],
			'is_agent_mobile' => $data['agent']['is_agent_mobile'],
			'is_agent_tablet' => $data['agent']['is_agent_tablet'],
			'is_agent_desktop' => $data['agent']['is_agent_desktop'],
			'is_agent_robot' => $data['agent']['is_agent_robot'],
		];
		//echo '<pre>';print_r($values);die();

		// insert
		Session::put('booking.dtb_booking_id', $this->statement->insert(
			$values,
			$table = 'dtb_booking'
		));

		// check session
		//echo '<pre>';print_r(Session::all());die();
	}


	/**
	 * ==================================================
	 * subconfirm
	 * ==================================================
	 */

	/**
	 * --------------------------------------------------
	 * @param array $data
	 * --------------------------------------------------
	 */
	public function storeSubConfirm($data)
	{
		// dd(session()->all());
		// dd($data);

		// set booking_code
		session()->put(
			'booking.booking_code',
			Helper::createRandomKey(128)
		);

		// set values
		$values = [
			'booking_code' => Session::get('booking.booking_code'),
			'signin_code' => Helper::createRandomKey(16),
			//'hash_code' => md5(Session::get('booking.booking_code')),
			'yy' => session()->get('booking.yy'),
			'mm' => session()->get('booking.mm'),
			'dd' => session()->get('booking.dd'),
			'hh' => session()->get('booking.hh'),
			'ii' => session()->get('booking.ii'),
			'date_last' => Carbon::create(
				session()->get('date_last.yy'),
				session()->get('date_last.mm'),
				session()->get('date_last.dd'),
			)->toDateString(),
			'shots_number' => session()->get('booking.shots_number'),
			'is_pm' => Helper::getMeridiem(
				session()->get('booking.hh'),
				session()->get('booking.ii')
			),
			'is_pencil' => 1,
			'is_web' => 1,
			'mtb_vaccine_id' => session()->get('booking.mtb_vaccine_id'),
			'_token' => session()->get('_token'),
			'agent_device' => $data['agent']['agent_device'],
			'agent_platform' => $data['agent']['agent_platform'],
			'agent_platform_version' => $data['agent']['agent_platform_version'],
			'agent_browser' => $data['agent']['agent_browser'],
			'agent_browser_version' => $data['agent']['agent_browser_version'],
			'agent_ip' => $data['agent']['agent_ip'],
			'agent_host' => $data['agent']['agent_host'],
			'is_agent_mobile' => $data['agent']['is_agent_mobile'],
			'is_agent_tablet' => $data['agent']['is_agent_tablet'],
			'is_agent_desktop' => $data['agent']['is_agent_desktop'],
			'is_agent_robot' => $data['agent']['is_agent_robot'],
		];
		// dd($values);

		// insert
		session()->put('booking.dtb_booking_id', $this->statement->insert(
			$values,
			$table = 'dtb_booking'
		));

		// check session
		// dd(session()->all());

		return;
	}


	/**
	 * ==================================================
	 * sms
	 * ==================================================
	 */

	/**
	 * --------------------------------------------------
	 * @param array $data
	 * @param boolean $is_changed
	 * --------------------------------------------------
	 */
	public function sendSms($data, $is_changed = false)
	{
		//echo '<pre>';print_r($data);die();

		// get booking
		$data['booking'] = $this->getBooking(
			$keys = [
				['dtb_booking.booking_code', '=', $data['booking_code']],
			]
		);
		//echo '<pre>';print_r($data['booking']);die();

		// content
		$content = [
			'date' => Carbon::create(
				$data['booking']['yy'],
				$data['booking']['mm'],
				$data['booking']['dd'],
			)->isoFormat('YYYY年MM月DD日（ddd）'),
			'time' => Carbon::create(
				$data['booking']['yy'],
				$data['booking']['mm'],
				$data['booking']['dd'],
				$data['booking']['hh'],
				$data['booking']['ii'],
			)->format('H:i'),
			'vaccine_label' => $data['booking']['vaccine_label'],
		];
		//echo '<pre>';print_r($content);die();

		// set link
		$link = [
			'mypage' => route('frontend.covid.booking.mypage.signin.show', [
				$data['booking']['yy'],
				$data['booking']['mm'],
				$data['booking']['dd'],
				$data['booking']['signin_code'],
			]),
			'qr' => route('frontend.covid.booking.mypage.qr.index', [
				$data['booking']['yy'],
				$data['booking']['mm'],
				$data['booking']['dd'],
				$data['booking']['signin_code'],
			]),
		];
		//echo '<pre>';print_r($link);die();

		$subject = $is_changed
			? '下記の日程にてワクチン接種予約の変更を受け付けました。'
			: '下記の日程にてワクチン接種予約を受け付けました。';

		// set message
		$message = "
平和台病院でございます。
{$subject}

【予約内容】
日程：{$content['date']}
時間：{$content['time']}
ワクチン種別：{$content['vaccine_label']}

【来院時受付QRコード】
{$link['qr']}

【予約の変更・キャンセルについて】
{$link['mypage']}

下記電話番号でも受け付けております。
04-7189-7721
";
		//echo '<pre>';print_r($message);die();

		// $response = Helper::sendVonage($data['booking']['mobile'], $message);
		$response = Helper::sendMediasms($data['booking']['mobile'], $message);

		return $response;
	}

	/**
	 * --------------------------------------------------
	 * @param array $canceled_booking
	 * --------------------------------------------------
	 */
	public function sendSmsCancel($canceled_booking)
	{
		//echo '<pre>';print_r($canceled_booking);die();

		// content
		$content = [
			'date' => Carbon::create(
				$canceled_booking['yy'],
				$canceled_booking['mm'],
				$canceled_booking['dd'],
			)->isoFormat('YYYY年MM月DD日（ddd）'),
			'time' => Carbon::create(
				$canceled_booking['yy'],
				$canceled_booking['mm'],
				$canceled_booking['dd'],
				$canceled_booking['hh'],
				$canceled_booking['ii'],
			)->format('H:i'),
			'vaccine_label' => $canceled_booking['vaccine_label'],
		];
		//echo '<pre>';print_r($content);die();

		// set message
		$message = "
平和台病院でございます。
ワクチン接種予約のキャンセルを受け付けました。

【キャンセル内容】
日程：{$content['date']}
時間：{$content['time']}
ワクチン種別：{$content['vaccine_label']}
";
		//echo '<pre>';print_r($message);die();

		// $response = Helper::sendVonage($canceled_booking['mobile'], $message);
		$response = Helper::sendMediasms($canceled_booking['mobile'], $message);

		return $response;
	}


	/**
	 * ==================================================
	 * sms2
	 * ==================================================
	 */

	/**
	 * --------------------------------------------------
	 * @param array $data
	 * @param boolean $is_changed
	 * --------------------------------------------------
	 */
	public function sendSms2($data, $is_changed = false)
	{
		// dd($data);

		// get booking
		$data['booking'] = $this->getBooking(
			$keys = [
				['dtb_booking.booking_code', '=', $data['booking_code']],
			]
		);
		// dd($data['booking']);

		// content
		$content = [
			'date' => Carbon::create(
				$data['booking']['yy'],
				$data['booking']['mm'],
				$data['booking']['dd'],
			)->isoFormat('YYYY年MM月DD日（ddd）'),
			'time' => Carbon::create(
				$data['booking']['yy'],
				$data['booking']['mm'],
				$data['booking']['dd'],
				$data['booking']['hh'],
				$data['booking']['ii'],
			)->format('H:i'),
			'vaccine_label' => $data['booking']['vaccine_label'],
		];
		// dd($content);

		// set link
		$link = [
			'mypage' => route('frontend.covid.booking2.mypage.signin.show', [
				$data['booking']['yy'],
				$data['booking']['mm'],
				$data['booking']['dd'],
				$data['booking']['signin_code'],
			]),
			'pdf' => route('frontend.covid.booking2.pdf.create', [
				$data['booking']['signin_code'],
			]),
		];
		// dd($link);

		$subject = $is_changed
			? '下記の日程にてワクチン接種予約の変更を受け付けました。'
			: '下記の日程にてワクチン接種予約を受け付けました。';

		// set message
		$message = "
平和台病院でございます。
{$subject}

【予約内容】
日程：{$content['date']}
時間：{$content['time']}
ワクチン種別：{$content['vaccine_label']}

【予診票ダウンロード】
{$link['pdf']}

【予約の変更・キャンセルについて】
{$link['mypage']}

下記電話番号でも受け付けております。
04-7189-7721
";
		// dd($message);

		// $response = Helper::sendVonage($data['booking']['mobile'], $message);
		$response = Helper::sendMediasms($data['booking']['mobile'], $message);

		return $response;
	}
}
