<?php
namespace App\Services;

interface BookingInterface
{
	/**
	 * ==================================================
	 * booking
	 * ==================================================
	 */

	/**
	 * --------------------------------------------------
	 * @param array $keys
	 * @param array $orders
	 * @param array $options
	 * --------------------------------------------------
	 */
	public function getBookingList($keys = [], $orders = [], $options = []);

	/**
	 * --------------------------------------------------
	 * @param array $keys
	 * --------------------------------------------------
	 */
	public function getBooking($keys);

	/**
	 * --------------------------------------------------
	 * @param array $data
	 * --------------------------------------------------
	 */
	public function storeBooking($data);

	/**
	 * --------------------------------------------------
	 * @param array $keys
	 * --------------------------------------------------
	 */
	public function getBookingCountList($keys);

	/**
	 * --------------------------------------------------
	 * @param array $keys
	 * @param array $orders
	 * @param array $options
	 * --------------------------------------------------
	 */
	public function getBookingStatusCountList($keys, $orders, $options);

	/**
	 * --------------------------------------------------
	 * @param array $date
	 * @param array $time_list
	 * @param array $booking_list
	 * --------------------------------------------------
	 */
	public function setBookingList($date, $time_list, $booking_list);

	/**
	 * --------------------------------------------------
	 * @param string $voucher_number
	 * --------------------------------------------------
	 */
	public function validateVoucherNumber(string $voucher_number);

	/**
	 * --------------------------------------------------
	 * @param array $data
	 * --------------------------------------------------
	 */
	public function setSession($date);


	/**
	 * ==================================================
	 * booking2
	 * ==================================================
	 */

	/**
	 * --------------------------------------------------
	 * @param array $data
	 * --------------------------------------------------
	 */
	public function storeBooking2($data);


	/**
	 * ==================================================
	 * form
	 * ==================================================
	 */

	/**
	 * --------------------------------------------------
	 * @param array $keys
	 * @param array $orders
	 * @param array $options
	 * --------------------------------------------------
	 */
	public function getFormList($keys = [], $orders = [], $options = []);

	/**
	 * --------------------------------------------------
	 * @param array $data
	 * --------------------------------------------------
	 */
	public function storeForm($data);


	/**
	 * ==================================================
	 * pencil
	 * ==================================================
	 */

	/**
	 * --------------------------------------------------
	 * @param array $data
	 * --------------------------------------------------
	 */
	public function storePencil($data);


	/**
	 * ==================================================
	 * subconfirm
	 * ==================================================
	 */

	/**
	 * --------------------------------------------------
	 * @param array $data
	 * --------------------------------------------------
	 */
	public function storeSubConfirm($data);


	/**
	 * ==================================================
	 * sms
	 * ==================================================
	 */

	/**
	 * --------------------------------------------------
	 * @param array $data
	 * --------------------------------------------------
	 */
	public function sendSms($data);


	/**
	 * ==================================================
	 * sms2
	 * ==================================================
	 */

	/**
	 * --------------------------------------------------
	 * @param array $data
	 * --------------------------------------------------
	 */
	public function sendSms2($data);
}
