<?php

namespace App\Services;

use Exception;

// use components
use Config,
	DB,
	Session,
	Storage,
	Carbon\Carbon,
	Carbon\CarbonPeriod,
	App\Helper;

// use repository interfaces
use App\Repositories\Statement,
	App\Repositories\View;

// use TcpdfFpdi
use setasign\Fpdi\TcpdfFpdi,
	SimpleSoftwareIO\QrCode\Facades\QrCode,
	TCPDF_FONTS;

class File extends Service implements FileInterface
{
	protected
		$statement,
		$view;

	/**
	 * --------------------------------------------------
	 * @param object $statement
	 * @param object $view
	 * --------------------------------------------------
	 */
	public function __construct(
		Statement $statement,
		View $view
	) {
		$this->statement = $statement;
		$this->view = $view;
	}


	/**
	 * ==================================================
	 * booking
	 * ==================================================
	 */

	/**
	 *
	 * @param array $data
	 */
	public function CreateFormPDF($data)
	{
		// dd($data);
		// echo '<pre>';print_r($data);die();

		// get data
		$address1 = $data['booking']['address1'];
		$age = $data['booking']['age'];
		$is_disease = $data['booking']['is_disease'];
		
		// for test
		// $age = 60;
		// $is_disease = 1;
		// dd($age);

		// set storage_path
		$storage_path = storage_path('app/public/pdf');
		// dd($storage_path);

		// set initialized
		// 当院書式
		$result = 0;

		if ($age >= 65 || ($age >= 60 AND $age < 65 AND $is_disease)) {
			
			$result = 1;
		}
		// dd($result);

		// create qrcode
		$qrcode = QrCode::format('png')
			->size(120)
			->color(0, 0, 0)
			->errorCorrection('H')
			->generate($data['booking']['signin_code']);
		// dd($qrcode);

		// set qrcode_path
		$qrcode_path = "public/pdf/qrcode/{$data['booking']['signin_code']}.png";

		// storage png 
		Storage::disk('local')->put($qrcode_path, $qrcode);
		// dd('ok');

		// set template_path
		$template_path = storage_path("app/public/pdf/form{$result}.pdf");
		// dd($template_path);

		$pdf = new TcpdfFpdi();

		$pdf->setPrintHeader(false);
		$pdf->setPrintFooter(false);
		$pdf->SetAutoPageBreak(false);
		$pdf->SetMargins(0, 0, 0);
		$pdf->addPage();

		$pdf->setSourceFile($template_path);
		$page = $pdf->importPage(1);
		$pdf->useTemplate($page);

		// dd($result);
		// wtiting to form1.pdf
		// 我孫子市フォーマット
		if ($result) {
			// dd('form1');
			// dd($data['form_list']);

			// set font
			$pdf->setFont('kozminproregular', '', 10);

			// 受診日
			$pdf->Text(80, 43, $data['booking']['yy']);
			$pdf->Text(98, 43, $data['booking']['mm']);
			$pdf->Text(109, 43, $data['booking']['dd']);

			// 個人情報
			$pdf->Text(55, 59, $data['booking']['patient_name']);
			$data['booking']['patient_kana'] = mb_convert_kana($data['booking']['patient_kana'], 'c');
			// dd($data['booking']['patient_kana']);

			if ($data['booking']['is_web']) {

				// $pdf->Text(55, 59, $data['booking']['patient_name']);
			}

			if($data['booking']['mtb_pref_id'] != 0) {

				// create address
				$pdf->Text(55, 49, implode('', [
					$data['booking']['pref_label'],
					$data['booking']['address1'],
					$data['booking']['address2'],
					$data['booking']['address3'],
				]));

				$pdf->Text(26, 270, implode('', [
					$data['booking']['pref_label'],
					$data['booking']['address1'],
					$data['booking']['address2'],
					$data['booking']['address3'],
				]));
			}
			
			// $pdf->Text(157, 49, $data['booking']['mobile'][0]);
			// $pdf->Text(173, 49, $data['booking']['mobile'][1] . '-' . $data['booking']['mobile'][2]);
			$pdf->Text(157, 49, $data['booking']['mobile']);
			if (is_null($data['booking']['mobile'])) $pdf->Text(157, 49, $data['booking']['tel']);
			$pdf->Text(153, 55, $data['booking']['wareki']['name'] . $data['booking']['wareki']['year']);
			$pdf->Text(172, 55, Carbon::parse($data['booking']['birthday'])->month);
			$pdf->Text(182, 55, Carbon::parse($data['booking']['birthday'])->day);
			$pdf->Text(176, 59, $data['booking']['age']);

			$pdf->SetFontSize(8);
			$pdf->Text(55, 55, $data['booking']['patient_kana']);

			// 接種年月日
			$pdf->Text(133, 252, $data['booking']['yy']);
			$pdf->Text(156, 252, $data['booking']['mm']);
			$pdf->Text(172, 252, $data['booking']['dd']);
			$pdf->Text(145, 265, '西暦 ' . $data['booking']['yy']);
			$pdf->Text(170, 265, $data['booking']['mm']);
			$pdf->Text(183, 265, $data['booking']['dd']);

			// if ($data['booking']['is_web']) {

				
			// }
			
			$pdf->Text(26, 275, $data['booking']['patient_name']);
			$pdf->Text(84, 275, $data['booking']['wareki']['name'] . $data['booking']['wareki']['year']);
			$pdf->Text(100, 275, Carbon::parse($data['booking']['birthday'])->month);
			$pdf->Text(110, 275, Carbon::parse($data['booking']['birthday'])->day);

			$pdf->SetLineWidth(0.3);
			if ($data['booking']['is_web']) {
				$pdf->Ellipse(($data['booking']['gender']) ? 102 : 109, 61, 3, 0);
			}
			else {
				if ($data['booking']['dtb_booking_id'] == 82 || $data['booking']['dtb_booking_id'] == 83) $pdf->Ellipse(($data['booking']['gender']) ? 102 : 109, 61, 3, 0);
			}
			// $pdf->Ellipse(($data['booking']['wareki']['name'] == '大正') ? 147 : 157, 57, 5, 2);

			/**
			 * 質問内容
			 */
			if ($data['booking']['is_web']) {

				$pdf->SetLineWidth(0.3);
				if(isset($data['form_list'][0])) $pdf->Ellipse(($data['form_list'][0]['value']) ? 166 : 153, 74, 6, 2);
				if(isset($data['form_list'][1])) $pdf->Ellipse(($data['form_list'][1]['value']) ? 166 : 153, 80, 6, 2);
				if(isset($data['form_list'][2])) $pdf->Ellipse(($data['form_list'][2]['value']) ? 153 : 166, 85, 6, 2);
				if(isset($data['form_list'][3])) $pdf->Ellipse(($data['form_list'][3]['value']) ? 153 : 166, 92, 6, 2);
				if(isset($data['form_list'][4])) $pdf->Ellipse(($data['form_list'][4]['value']) ? 153 : 166, 99, 6, 2);
				// if(isset($data['form_list'][5])) $pdf->Ellipse(($data['form_list'][5]['value']) ? 166 : 153, 105, 6, 2);
				// $pdf->Ellipse(($data['form_list'][6]['value']) ? 153 : 166, 112, 6, 2);
				if(isset($data['form_list'][7])) $pdf->Ellipse(($data['form_list'][7]['value']) ? 153 : 166, 122, 6, 2);
				if(isset($data['form_list'][8])) $pdf->Ellipse(($data['form_list'][8]['value']) ? 153 : 166, 130, 6, 2);
				if(isset($data['form_list'][9])) $pdf->Ellipse(($data['form_list'][9]['value']) ? 153 : 166, 136, 6, 2);
				if(isset($data['form_list'][10])) $pdf->Ellipse(($data['form_list'][10]['value']) ? 153 : 166, 142, 6, 2);
				if(isset($data['form_list'][11])) $pdf->Ellipse(($data['form_list'][11]['value']) ? 153 : 166, 150, 6, 2);
				if(isset($data['form_list'][12])) $pdf->Ellipse(($data['form_list'][12]['value']) ? 166 : 153, 157, 6, 2);
				if(isset($data['form_list'][13])) $pdf->Ellipse(($data['form_list'][13]['value']) ? 153 : 166, 161, 6, 2);
				if(isset($data['form_list'][14])) $pdf->Ellipse(($data['form_list'][14]['value']) ? 153 : 166, 165, 6, 2);
				if (isset($data['form_list'][15])) $pdf->Ellipse(($data['form_list'][15]['value']) ? 153 : 166, 175, 6, 2);

				if ($data['form_list'][4]['value'] == 1) {
					if(isset($data['form_list'][5])) $pdf->Ellipse(($data['form_list'][5]['value']) ? 166 : 153, 105, 6, 2);
				}

				$pdf->setFont('kozminproregular', '', 8);
				if (isset($data['form_list'][2])) if ($data['form_list'][2]['value']) $pdf->Text(30, 87, $data['form_list'][2]['subform1']);
				if (isset($data['form_list'][3])) if ($data['form_list'][3]['value']) $pdf->Text(30, 94, $data['form_list'][3]['subform1']);
				// if ($data['form_list'][6]['value']) $pdf->Text(70, 114, $data['form_list'][6]['subform1']);
				if (isset($data['form_list'][7])) if ($data['form_list'][7]['value']) $pdf->Text(32, 123, $data['form_list'][7]['subform1']);
				if (isset($data['form_list'][8])) if ($data['form_list'][8]['value']) $pdf->Text(112, 127, $data['form_list'][8]['subform1']);
				if (isset($data['form_list'][10])) if ($data['form_list'][10]['value']) $pdf->Text(22, 144, $data['form_list'][10]['subform1']);
				if (isset($data['form_list'][11])) if ($data['form_list'][11]['value']) $pdf->Text(58, 152, Carbon::parse($data['form_list'][11]['subform1'])->month);
				if (isset($data['form_list'][11])) if ($data['form_list'][11]['value']) $pdf->Text(68, 152, Carbon::parse($data['form_list'][11]['subform1'])->day);
				if (isset($data['form_list'][11])) if ($data['form_list'][11]['value']) $pdf->Text(80, 152, $data['form_list'][11]['subform2']);
				if (isset($data['form_list'][14])) if ($data['form_list'][14]['value']) $pdf->Text(44, 168, $data['form_list'][14]['subform1']);
				if (isset($data['form_list'][15])) if ($data['form_list'][15]['value']) $pdf->Text(27, 176, $data['form_list'][15]['subform1']);

				$pdf->setFont('kozminproregular', '', 6);
				if (isset($data['form_list'][10])) if ($data['form_list'][10]['value']) $pdf->Text(61, 144, $data['form_list'][10]['subform2']);
				if (isset($data['form_list'][10])) if ($data['form_list'][10]['value']) $pdf->Text(102, 144, $data['form_list'][10]['subform3']);
			}

			// set image
			$pdf->Image(storage_path(
				"app/public/pdf/qrcode/{$data['booking']['signin_code']}.png"),
				182,
				9,
				16,
				16
			);
		}

		// wtiting to form0.pdf
		// 平和台病院フォーマット
		else {
			// dd('form0');
			// dd($data['form_list']);

			// 受診日
			// $pdf->Text(80, 43, $data['booking']['yy']);
			// $pdf->Text(98, 43, $data['booking']['mm']);
			// $pdf->Text(109, 43, $data['booking']['dd']);

			/**
			 * 個人情報
			 */

			$data['booking']['patient_kana'] = mb_convert_kana($data['booking']['patient_kana'], 'c');
			// dd($data['booking']['patient_kana']);

			// set font
			$pdf->setFont('kozminproregular', '', 12);
			$pdf->Text(55, 52, $data['booking']['patient_name']);

			$pdf->setFont('kozminproregular', '', 10);

			if ($data['booking']['mtb_pref_id'] != 0) {

				$pdf->Text(55, 38, implode('', [
					$data['booking']['pref_label'],
					$data['booking']['address1'],
					$data['booking']['address2'],
					$data['booking']['address3'],
				]));
			}
			
			// $pdf->Text(160, 38, $data['booking']['mobile'][0]);
			// $pdf->Text(175, 38, $data['booking']['mobile'][1] . '-' . $data['booking']['mobile'][2]);
			$pdf->Text(160, 38, $data['booking']['mobile']);
			if (is_null( $data['booking']['mobile']))  $pdf->Text(160, 38, $data['booking']['tel']);
			$pdf->Text(55, 45, $data['booking']['patient_kana']);
			$pdf->Text(130, 62, $data['booking']['wareki']['name'] . $data['booking']['wareki']['year']);
			$pdf->Text(150, 62, Carbon::parse($data['booking']['birthday'])->month);
			$pdf->Text(162, 62, Carbon::parse($data['booking']['birthday'])->day);
			$pdf->Text(180, 62, $data['booking']['age']);

			// 接種年月日
			$pdf->Text(138, 263, '西暦 ' . $data['booking']['yy']);
			$pdf->Text(161, 263, $data['booking']['mm']);
			$pdf->Text(168, 263, $data['booking']['dd']);

			$pdf->SetLineWidth(0.3);
			if($data['booking']['is_web']) $pdf->Ellipse(($data['booking']['gender']) ? 63 : 73, 64, 3, 0);

			/**
			 * 質問内容
			 */

			$pdf->SetLineWidth(0.3);
			if(isset($data['form_list'][0])) $pdf->Ellipse(($data['form_list'][0]['value']) ? 170 : 156, 80, 6, 2);
			if(isset($data['form_list'][1])) $pdf->Ellipse(($data['form_list'][1]['value']) ? 170 : 156, 85, 6, 2);
			if(isset($data['form_list'][2])) $pdf->Ellipse(($data['form_list'][2]['value']) ? 156 : 170, 92, 6, 2);
			if(isset($data['form_list'][3])) $pdf->Ellipse(($data['form_list'][3]['value']) ? 156 : 170, 102, 6, 2);
			if(isset($data['form_list'][4])) $pdf->Ellipse(($data['form_list'][4]['value']) ? 156 : 170, 111, 6, 2);
			// if(isset($data['form_list'][5])) $pdf->Ellipse(($data['form_list'][5]['value']) ? 170 : 156, 120, 6, 2);
			// $pdf->Ellipse(($data['form_list'][6]['value']) ? 156 : 170, 131, 6, 2);
			if(isset($data['form_list'][7])) $pdf->Ellipse(($data['form_list'][7]['value']) ? 156 : 170, 142, 6, 2);
			if(isset($data['form_list'][8])) $pdf->Ellipse(($data['form_list'][8]['value']) ? 156 : 170, 152, 6, 2);
			if(isset($data['form_list'][9])) $pdf->Ellipse(($data['form_list'][9]['value']) ? 156 : 170, 160, 6, 2);
			if(isset($data['form_list'][10])) $pdf->Ellipse(($data['form_list'][10]['value']) ? 156 : 170, 168, 6, 2);
			if(isset($data['form_list'][11])) $pdf->Ellipse(($data['form_list'][11]['value']) ? 156 : 170, 179, 6, 2);
			if(isset($data['form_list'][12])) $pdf->Ellipse(($data['form_list'][12]['value']) ? 170 : 156, 187, 6, 2);
			if(isset($data['form_list'][13])) $pdf->Ellipse(($data['form_list'][13]['value']) ? 156 : 170, 193, 6, 2);
			if(isset($data['form_list'][14])) $pdf->Ellipse(($data['form_list'][14]['value']) ? 156 : 170, 198, 6, 2);
			if(isset($data['form_list'][15])) $pdf->Ellipse(($data['form_list'][15]['value']) ? 156 : 170, 211, 6, 2);

			if(isset($data['form_list'][4])) {
				if ($data['form_list'][4]['value'] == 1) {
					if(isset($data['form_list'][5])) $pdf->Ellipse(($data['form_list'][5]['value']) ? 170 : 156, 120, 6, 2);
				}	
			}

			$pdf->setFont('kozminproregular', '', 9);
			if(isset($data['form_list'][2])) if ($data['form_list'][2]['value']) $pdf->Text(22, 93, $data['form_list'][2]['subform1']);
			if(isset($data['form_list'][3])) if ($data['form_list'][3]['value']) $pdf->Text(22, 103, $data['form_list'][3]['subform1']);
			// if(isset($data['form_list'][6])) if ($data['form_list'][6]['value']) $pdf->Text(54, 131, $data['form_list'][6]['subform1']);
			if(isset($data['form_list'][7])) if ($data['form_list'][7]['value']) $pdf->Text(22, 142, $data['form_list'][7]['subform1']);
			if(isset($data['form_list'][8])) if ($data['form_list'][8]['value']) $pdf->Text(122, 153, $data['form_list'][8]['subform1']);
			if(isset($data['form_list'][10])) if ($data['form_list'][10]['value']) $pdf->Text(122, 169, $data['form_list'][10]['subform1']);
			if(isset($data['form_list'][11])) if ($data['form_list'][11]['value']) $pdf->Text(63, 180, Carbon::parse($data['form_list'][11]['subform1'])->month);
			if(isset($data['form_list'][11])) if ($data['form_list'][11]['value']) $pdf->Text(77, 180, Carbon::parse($data['form_list'][11]['subform1'])->day);
			if(isset($data['form_list'][11])) if ($data['form_list'][11]['value']) $pdf->Text(102, 180, $data['form_list'][11]['subform2']);
			if(isset($data['form_list'][14])) if ($data['form_list'][14]['value']) $pdf->Text(38, 201, $data['form_list'][14]['subform1']);
			if(isset($data['form_list'][15])) if ($data['form_list'][15]['value']) $pdf->Text(22, 212, $data['form_list'][15]['subform1']);

			$pdf->setFont('kozminproregular', '', 7);
			if(isset($data['form_list'][10])) if ($data['form_list'][10]['value']) $pdf->Text(32, 170, $data['form_list'][10]['subform2']);
			if(isset($data['form_list'][10])) if ($data['form_list'][10]['value']) $pdf->Text(78, 170, $data['form_list'][10]['subform3']);

			/**
			 * QRコード
			 */
			$pdf->Image(storage_path(
				"app/public/pdf/qrcode/{$data['booking']['signin_code']}.png"),
				180,
				10,
				20,
				20
			);
		}
		
		// set file_name
		// $file_name = implode('', [
		// 	$data['booking']['patient_sname'],
		// 	$data['booking']['patient_gname'],
		// 	'様 ',
		// 	'問診票_',
		// 	Carbon::now()->format('Ymd'),
		// 	'.pdf',
		// ]);
		// dd($file_name);

		/**
		 * --------------------------------------------------
		 * output to browser
		 * --------------------------------------------------
		 */
		// return $pdf->Output($file_name, 'I');

		/**
		 * --------------------------------------------------
		 * output to download
		 * --------------------------------------------------
		 */
		// return $pdf->Output($file_name, 'D');

		/**
		 * --------------------------------------------------
		 * storage
		 * --------------------------------------------------
		 */

		// set file_path
		$file_path = implode('/', [
			'public',
			'pdf',
			$data['booking']['yy'],
			Carbon::create($data['booking']['yy'], $data['booking']['mm'], $data['booking']['dd'])->format('md'),
			$data['booking']['signin_code'] . '.pdf',
		]);
		// dd($file_path);

		// output to local disk
		$content = $pdf->Output('report.pdf', 'S');
		Storage::disk('local')->put($file_path, $content);

		// ob_clean();
		unset($pdf); 
	}
}
