<?php

namespace App\Services;

use Illuminate\Support\Facades\DB;
use Exception;

// use components
use Session,
	Carbon\Carbon,
	Carbon\CarbonPeriod;

// use repository interfaces
use App\Repositories\Statement,
	App\Repositories\View;

class Maintenance extends Service implements MaintenanceInterface
{
	protected
		$statement,
		$view;

	/**
	 *
	 * @param Statement $statement
	 * @param View $view
	 * @param MasterInterface $master
	 */
	public function __construct(
		Statement $statement,
		View $view
	) {
		$this->statement = $statement;
		$this->view = $view;
	}


	/**
	 * ==================================================
	 * voucher
	 * ==================================================
	 */

	/**
	 *
	 * @param unknown $data
	 * @return unknown
	 */
	public function updateVoucher($data)
	{
		$booking_list = $this->statement->get(
			$keys = [
				['is_booked', '=', 1],
			],
			$orders = [],
			$table = 'dtb_booking'
		);
		//echo '<pre>';print_r($booking_list);die();

		if($booking_list) {

			foreach($booking_list as $key => $value) {
				//echo '<pre>';print_r($value);die();

				if(mb_strlen($value['voucher_number']) != mb_strwidth($value['voucher_number'])) {
					//echo '<pre>';print_r($value['voucher_number']);die();

					$voucher_number = mb_convert_kana(
						$value['voucher_number'],
						'n'
					);
					//echo '<pre>';print_r($voucher_number);die();

					$this->statement->update(
						$keys = [
							['dtb_booking_id', '=', $value['dtb_booking_id']],
						],
						$values = [
							'voucher_number' => $voucher_number,
						],
						$table = 'dtb_booking'
					);
				}
			}
		}

		return;
	}
}
