<?php

namespace App\Services;

use Illuminate\Support\Facades\DB;
use Exception;

// use components
use	Carbon\Carbon,
	Config,
	Session,
	App\Helper;

// use repository interfaces
use App\Repositories\Statement,
	App\Repositories\View;

class Master extends Service implements MasterInterface
{
	protected
		$statement,
		$view;

	/**
	 * --------------------------------------------------
	 * @param object $statement
	 * @param object $view
	 * --------------------------------------------------
	 */
	public function __construct(
		Statement $statement,
		View $view
	) {
		$this->statement = $statement;
		$this->view = $view;
	}


	/**
	 * ==================================================
	 * master
	 * ==================================================
	 */

	/**
	 * --------------------------------------------------
	 * @param array $keys
	 * @param array $orders
	 * @param string $table
	 * @return array
	 * --------------------------------------------------
	 */
	public function getMasterList($keys = [], $orders = [], $table)
	{
		//echo '<pre>';print_r($table);die();

		$result = $this->statement->get(
			$keys,
			$orders,
			"mtb_{$table}"
		);

		//echo '<pre>';print_r($result);die();
		return $result;
	}

	/**
	 * --------------------------------------------------
	 * @param array $keys
	 * @param array $orders
	 * @return array
	 * --------------------------------------------------
	 */
	public function getMasterDropdownList($keys = [], $orders = [], $table)
	{
		//echo '<pre>';print_r($keys);die();

		// initialized
		$result = [];

		$return = $this->getMasterList($keys, $orders, $table);
		//echo '<pre>';print_r($return);die();

		foreach($return as $key => $value) {
			//echo '<pre>';print_r($value);die();

			$result[$value["mtb_{$table}_id"]] = $value["{$table}_label"];
		}

		//echo '<pre>';print_r($result);die();
		return $result;
	}

	/**
	 * --------------------------------------------------
	 * @param array $keys
	 * @param string $table
	 * @return array
	 * --------------------------------------------------
	 */
	public function getMaster($keys, $table)
	{
		$result = $this->statement->first(
			$keys,
			"mtb_{$table}"
		);

		//echo '<pre>';print_r($result);die();
		return $result;
	}

	/**
	 * --------------------------------------------------
	 * @param array $data
	 * --------------------------------------------------
	 */
	public function storeMaster($data)
	{
		//echo '<pre>';print_r($data);die();

		// initialized
		$values = [];

		$values = [
			"{$data['table']}_label" => $data['master']["{$data['table']}_label"],
			'seq' => $data['master']['seq'],
			'remark' => $data['master']['remark'],
			//'is_disabled' => $data['master']['is_disabled'],
		];
		//echo '<pre>';print_r($values);die();

		/**
		 * --------------------------------------------------
		 * insert
		 * --------------------------------------------------
		 */
		if(is_null($data['master']["mtb_{$data['table']}_id"])) {

			$this->statement->insert(
				$values,
				$table = "mtb_{$data['table']}");
		}

		/**
		 * --------------------------------------------------
		 * update
		 * --------------------------------------------------
		 */
		else {

			$this->statement->update(
				$keys = [
					["mtb_{$data['table']}_id", '=', $data['master']["mtb_{$data['table']}_id"]],
				],
				$values,
				$table = "mtb_{$data['table']}"
			);
		}
	}


	/**
	 * ==================================================
	 * language
	 * ==================================================
	 */

	/**
	 * --------------------------------------------------
	 * @param array $keys
	 * @param array $orders
	 * --------------------------------------------------
	 */
	public function getLanguageList($keys = [], $orders = [])
	{
		$result = $this->statement->get(
			$keys,
			$orders,
			$table = 'mtb_language'
		);

		//echo '<pre>';print_r($result);die();
		return $result;
	}

	/**
	 * --------------------------------------------------
	 * @param array $keys
	 * @param array $orders
	 * --------------------------------------------------
	 */
	public function getLanguageDropDownList($keys = [], $orders = [])
	{
		$result = [];

		$return = $this->getLanguageList(
			$keys,
			$orders
		);

		if($return) {

			foreach($return as $key => $value) {

				$result[$value['language_code']] = $value['language_label'];
			}
		}

		//echo '<pre>';print_r($result);die();
		return $result;
	}

	/**
	 * --------------------------------------------------
	 * @param array $keys
	 * --------------------------------------------------
	 */
	public function getLanguage($keys = [])
	{
		$result = $this->statement->first(
			$keys,
			$table = 'mtb_language'
		);

		//echo '<pre>';print_r($result);die();
		return $result;
	}

	/**
	 * --------------------------------------------------
	 * @param string $language_code
	 * --------------------------------------------------
	 */
	public function getLanguageId($language_code)
	{
		$mtb_language_id = $this->statement->field(
			$field = 'mtb_language_id',
			$keys = [
				['language_code', '=', $language_code],
			],
			$table = 'mtb_language'
		);
		//print_r($result);die();

		Session::put('lang_id', $mtb_language_id);
	}


	/**
	 * ==================================================
	 * accepted_number
	 * ==================================================
	 */

	/**
	 * --------------------------------------------------
	 * @param array $keys
	 * @param array $orders
	 * @param array $options
	 * --------------------------------------------------
	 */
	public function getAcceptedNumberList($keys = [], $orders = [], $options = [])
	{
		$result = $this->statement->get(
			$keys,
			$orders,
			$table = 'mtb_accepted_number'
		);

		//echo '<pre>';print_r($result);die();
		return $result;
	}

	/**
	 * --------------------------------------------------
	 * @param array $keys
	 * --------------------------------------------------
	 */
	public function getAcceptedNumber($keys)
	{
		$result = $this->statement->first(
			$keys,
			$table = 'mtb_accepted_number'
		);

		//echo '<pre>';print_r($result);die();
		return $result;
	}

	/**
	 * --------------------------------------------------
	 * @param array $data
	 * --------------------------------------------------
	 */
	public function storeAcceptedNumber($data)
	{
		//echo '<pre>';print_r($data);die();

		$values = [];

		$column_list = [
			'hh',
			'ii',
			'accepted_number',
			'remark',
		];

		foreach($column_list as $column) {

			if(isset($data['accepted_number'][$column])) {

				$values[$column] = $data['accepted_number'][$column];
			}
		}
		//echo '<pre>';print_r($values);die();

		// processing for comment
		if(!is_null($data['accepted_number']['mtb_accepted_number_id'])) {

			if(!isset($data['accepted_number']['remark'])) $values['remark'] = null;
		}

		// insert
		if(!isset($data['accepted_number']['mtb_accepted_number_id'])) {
			//die('insert');

			$data['accepted_number']['mtb_accepted_number_id'] = $this->statement->insert(
				$values,
				$table = 'mtb_accepted_number'
			);
		}

		// update
		else {
			//die('update');

			$this->statement->update(
				$keys = [
					['mtb_accepted_number_id', '=', $data['accepted_number']['mtb_accepted_number_id']],
				],
				$values,
				$table = 'mtb_accepted_number'
			);
		}

		//echo '<pre>';print_r($data);die();
		return $data;
	}


	/**
	 * ==================================================
	 * date
	 * ==================================================
	 */

	/**
	 * --------------------------------------------------
	 * @param array $keys
	 * @param array $orders
	 * @param array $options
	 * --------------------------------------------------
	 */
	public function getDateList($keys = [], $orders = [], $options = [])
	{
		$result = [];

		$return = $this->statement->get(
			$keys,
			$orders,
			$table = 'mtb_date'
		);
		//echo '<pre>';print_r($return);die();

		foreach($return as $key => $value) {

			$result[$value['mtb_date_id']] = $value;
		}

		//echo '<pre>';print_r($result);die();
		return $result;
	}

	/**
	 * --------------------------------------------------
	 * @param array $keys
	 * @param array $orders
	 * --------------------------------------------------
	 */
	public function getDateIsExistList($keys = [], $orders = [])
	{
		// initialized
		$result = [];

		$return = $this->view->getDateList(
			$keys,
			$orders,
			$options = []
		);
		//echo '<pre>';print_r($return);die();

		if($return) {

			foreach($return as $key => $value) {

				$result[$value['dd']] = [
					'date' => $value['date'],
					'yy' => $value['yy'],
					'mm' => $value['mm'],
					'accepted_numbers' => $value['accepted_numbers'],
					'mtb_vaccine_id' => $value['mtb_vaccine_id'],
					'vaccine_label' => $value['vaccine_label'],
				];
			}
		}

		//echo '<pre>';print_r($result);die();
		return $result;
	}

	/**
	 * --------------------------------------------------
	 * @param array $keys
	 * --------------------------------------------------
	 */
	public function getDate($keys)
	{
		$result = $this->view->getDate(
			$keys
		);

		//echo '<pre>';print_r($result);die();
		return $result;
	}

	/**
	 * --------------------------------------------------
	 * @param array $data
	 * --------------------------------------------------
	 */
	public function storeDate($data)
	{
		//echo '<pre>';print_r($data);die();

		// delete
		$this->statement->delete(
			$keys = [
				['mtb_date_id', '=', $data['date']['mtb_date_id']],
			],
			$table = 'mtb_time'
		);

		$date = Carbon::create(
			$data['date']['yy'],
			$data['date']['mm'],
			$data['date']['dd'],
		)->toDateString();
		//echo '<pre>';print_r($date);die();

		// initialized
		$values = [];

		$column_list = [
			'yy',
			'mm',
			'dd',
		];

		foreach($column_list as $column) {

			if(isset($data['date'][$column])) {

				$values[$column] = $data['date'][$column];
			}
		}
		//echo '<pre>';print_r($values);die();

		$values['date'] = $date;
		$values['mtb_vaccine_id'] = $data['mtb_vaccine_id'];
		//echo '<pre>';print_r($values);die();

		// insert processing
		if(is_null($data['date']['mtb_date_id'])) {
			//die('insert');

			$data['date']['mtb_date_id'] = $this->statement->insert(
				$values,
				$table = 'mtb_date'
			);
			//echo '<pre>';print_r($data['date']);die();
		}

		// update processing
		else {
			//die('update');

			$this->statement->update(
				$keys = [
					['mtb_date_id', '=', $data['date']['mtb_date_id']],
				],
				$values,
				$table = 'mtb_date'
			);
		}

		// initialized
		$values = [];
		$accepted_numbers = 0;

		foreach($data['time'] as $hh => $ii_list) {
			//echo '<pre>';print_r($ii_list);die();

			foreach($ii_list as $ii => $accepted_number) {

				//if($accepted_number > 0) {
					$values[] = [
						'date' => $date,
						'hh' => $hh,
						'ii' => $ii,
						'accepted_number' => $accepted_number,
						'mtb_date_id' => $data['date']['mtb_date_id'],
					];

					$accepted_numbers += $accepted_number;
				//}
			}
		}
		//echo '<pre>';print_r($values);die();

		$this->statement->inserts(
			$values,
			$table = 'mtb_time'
		);

		//echo '<pre>';print_r($accepted_numbers);die();

		// update accepted_numbers
		$this->statement->update(
			$keys = [
				['mtb_date_id', '=', $data['date']['mtb_date_id']],
			],
			$values = [
				'accepted_numbers' => $accepted_numbers,
			],
			$table = 'mtb_date'
		);

		return $data['date']['mtb_date_id'];
	}

	/**
	 * --------------------------------------------------
	 * @param array $keys
	 * --------------------------------------------------
	 */
	public function getMinDate($keys)
	{
		$result = $this->view->getMinDate(
			$keys
		);

		//echo '<pre>';print_r($result);die();
		return ($result) ? $result['dd'] : null;
	}


	/**
	 * ==================================================
	 * time
	 * ==================================================
	 */

	/**
	 * --------------------------------------------------
	 * @param array $keys
	 * @param array $orders
	 * @param array $options
	 * --------------------------------------------------
	 */
	public function getTimeList($keys = [], $orders = [], $options = [])
	{
		$result = [];

		$return = $this->view->getTimeList(
			$keys,
			$orders,
			$options
		);

		foreach($return as $key => $value) {

			$result[$value['hh']][$value['ii']] = $value;
		}

		//echo '<pre>';print_r($result);die();
		return $result;
	}

	/**
	 * --------------------------------------------------
	 * @param array $keys
	 * @param array $orders
	 * @param array $options
	 * --------------------------------------------------
	 */
	public function getTimeDropdownList($keys = [], $orders = [], $options = [])
	{
		$result = [];

		$return = $this->view->getTimeList(
			$keys,
			$orders,
			$options
		);
		//echo '<pre>';print_r($return);die();

		// set all
		//$result[0] = 'すべて';

		// set time
		foreach($return as $key => $value) {

			$result[$value['mtb_time_id']] = [
				$value['hh'],
				$value['ii'],
			];
		}

		//echo '<pre>';print_r($result);die();
		return $result;
	}

	/**
	 * --------------------------------------------------
	 * @param array $keys
	 * --------------------------------------------------
	 */
	public function getTime($keys)
	{

	}

	/**
	 * --------------------------------------------------
	 * @param array $data
	 * --------------------------------------------------
	 */
	public function storeTime($data)
	{

	}

	/**
	 * --------------------------------------------------
	 * @param array $data
	 * --------------------------------------------------
	 */
	public function getEnabledTimeList($data)
	{
		//echo '<pre>';print_r($data);die();

		// initialized
		$result = [];

		// get time_list
		$time_list = $this->view->getTimeList(
			$keys = [
				['yy', '=', $data['yy']],
				['mm', '=', $data['mm']],
				['dd', '=', $data['dd']],
			],
			$orders = [],
			$options = []
		);
		//echo '<pre>';print_r($time_list);die();

		// get booking_list
		$booking_list = $this->view->getBookingCountListByDay(
			$keys = [
				'yy' => $data['yy'],
				'mm' => $data['mm'],
				'dd' => $data['dd'],
				'is_booked' => 1,
			]
		);
		//echo '<pre>';print_r($booking_list);die();

		foreach($time_list as $time) {
			//echo '<pre>';print_r($time);die();

			// set with mtb_time_id
			$result[$time['mtb_time_id']] = [
				'hh' => $time['hh'],
				'ii' => $time['ii'],
				'booked_number' => 0,
				'accepted_number' => $time['accepted_number'],
				'is_disabled' => ($time['accepted_number'] == 0) ? 1 : 0,
			];
			//echo '<pre>';print_r($result);die();

			foreach($booking_list as $booking) {
				//echo '<pre>';print_r($booking);die();

				// set current booked number
				if(($booking['hh'] == $time['hh']) && ($booking['ii'] == $time['ii'])) {

					$booked_number = $booking['cnt'];

					$result[$time['mtb_time_id']]['booked_number'] = $booked_number;

					if($booked_number >= $time['accepted_number']) {

						$result[$time['mtb_time_id']]['is_disabled'] = 1;
					}
					break;
				}
			}
		}

		//echo '<pre>';print_r($result);die();
		return $result;
	}


	/**
	 * ==================================================
	 * publish
	 * ==================================================
	 */

	/**
	 * --------------------------------------------------
	 * @param array $keys
	 * --------------------------------------------------
	 */
	public function getPublish($keys)
	{
		$result = $this->statement->first(
			$keys,
			$table = 'mtb_publish'
		);

		//echo '<pre>';print_r($result);die();
		return $result;
	}

	/**
	 * --------------------------------------------------
	 * @param array $data
	 * --------------------------------------------------
	 */
	public function storePublish($data)
	{
		//echo '<pre>';print_r($data);die();

		// initialized
		$values = [];

		$column_list = [
			'date_publish',
			'remark',
			'is_unpublish',
		];

		foreach($column_list as $column) {

			$values[$column] = $data['publish'][$column];
		}
		//echo '<pre>';print_r($values);die();

		if(!$data['publish']['is_unpublish']) $values['date_publish'] = null;
		//echo '<pre>';print_r($values);die();

		$this->statement->update(
			$keys = [
				['mtb_publish_id', '=', $data['publish']['mtb_publish_id']],
			],
			$values,
			$table = 'mtb_publish'
		);

		return;
	}


	/**
	 * ==================================================
	 * vaccine
	 * ==================================================
	 */

	/**
	 * --------------------------------------------------
	 * @param array $data
	 * --------------------------------------------------
	 */
	public function storeVaccine($data)
	{
		//echo '<pre>';print_r($data);die();

		// initialized
		$values = [];

		$column_list = [
			'vaccine_label',
			'seq',
			'remark',
			'is_show',
		];

		foreach($column_list as $column) {

			$values[$column] = $data['vaccine'][$column];
		}
		//echo '<pre>';print_r($values);die();

		/**
		 * --------------------------------------------------
		 * insert
		 * --------------------------------------------------
		 */
		if(is_null($data['vaccine']['mtb_vaccine_id'])) {

			$this->statement->insert(
				$values,
				$table = 'mtb_vaccine');
		}

		/**
		 * --------------------------------------------------
		 * update
		 * --------------------------------------------------
		 */
		else {

			$this->statement->update(
				$keys = [
					["mtb_vaccine_id", '=', $data['vaccine']['mtb_vaccine_id']],
				],
				$values,
				$table = 'mtb_vaccine'
			);
		}
	}
}
