<?php

namespace App\Services;

use Illuminate\Support\Facades\DB;
use Exception;

// use components
use Session,
	Carbon\Carbon,
	Carbon\CarbonPeriod;

// use repository interfaces
use App\Repositories\Statement,
	App\Repositories\View;

// use service interfaces
use App\Services\MasterInterface;

class Math extends Service implements MathInterface
{
	protected
		$statement,
		$view;

	protected
		$master;

	/**
	 *
	 * @param Statement $statement
	 * @param View $view
	 * @param MasterInterface $master
	 */
	public function __construct(
		Statement $statement,
		View $view,
		MasterInterface $master
	) {
		$this->statement = $statement;
		$this->view = $view;

		$this->master = $master;
	}


	/*
	 |--------------------------------------------------------------------------
	 |
	 |--------------------------------------------------------------------------
	 |
	 */

	/**
	 *
	 * @param unknown $data
	 * @return unknown
	 */
	public function getCountTimeList($data)
	{
		//echo '<pre>';print_r($data);die();

		// initialized
		$result = [];

		$total = [
			'booked' => 0,
			'confirmed' => 0,
			'unconfirmed' => 0,
			'walkin' => 0,
		];

		$am = [
			'booked' => 0,
			'confirmed' => 0,
			'unconfirmed' => 0,
			'walkin' => 0,
		];

		$pm = [
			'booked' => 0,
			'confirmed' => 0,
			'unconfirmed' => 0,
			'walkin' => 0,
		];

		foreach($data['time_list'] as $key => $value) {
			//echo '<pre>';print_r($value);die();

			// booking
			$result['booking'][$key] = $this->statement->count(
				$keys = [
					['yy', '=', $data['yy']],
					['mm', '=', $data['mm']],
					['dd', '=', $data['dd']],
					['hh', '=', $value[0]],
					['ii', '=', $value[1]],
					['is_booked', '=', 1],
					['is_cancel', '=', 0],
					['is_walkin', '=', 0],
				],
				$table = 'dtb_booking'
			);
			//echo '<pre>';print_r($result);die();

			// confirmed
			$result['confirmed'][$key] = $this->statement->count(
				$keys = [
					['yy', '=', $data['yy']],
					['mm', '=', $data['mm']],
					['dd', '=', $data['dd']],
					['hh', '=', $value[0]],
					['ii', '=', $value[1]],
					['is_booked', '=', 1],
					['is_cancel', '=', 0],
					['is_checkedin', '=', 1],
					['is_walkin', '=', 0],
				],
				$table = 'dtb_booking'
			);
			//echo '<pre>';print_r($result);die();

			// unconfirmed
			$result['unconfirmed'][$key] = $result['booking'][$key] - $result['confirmed'][$key];
			//echo '<pre>';print_r($result);die();

			// walkin
			$result['walkin'][$key] = $this->statement->count(
				$keys = [
					['yy', '=', $data['yy']],
					['mm', '=', $data['mm']],
					['dd', '=', $data['dd']],
					['hh', '=', $value[0]],
					['ii', '=', $value[1]],
					['is_booked', '=', 1],
					['is_cancel', '=', 0],
					['is_checkedin', '=', 1],
					['is_walkin', '=', 1],
				],
				$table = 'dtb_booking'
			);
			//echo '<pre>';print_r($result);die();

			$total['booked'] += $result['booking'][$key];
			$total['confirmed'] += $result['confirmed'][$key];
			$total['unconfirmed'] += $result['unconfirmed'][$key];
			$total['walkin'] += $result['walkin'][$key];

			if($value[0] > 12) {

				$pm['booked'] += $result['booking'][$key];
				$pm['confirmed'] += $result['confirmed'][$key];
				$pm['unconfirmed'] += $result['unconfirmed'][$key];
				$pm['walkin'] += $result['walkin'][$key];
			}

			else {

				$am['booked'] += $result['booking'][$key];
				$am['confirmed'] += $result['confirmed'][$key];
				$am['unconfirmed'] += $result['unconfirmed'][$key];
				$am['walkin'] += $result['walkin'][$key];
			}
		}

		//echo '<pre>';print_r($am);die();
		//echo '<pre>';print_r($pm);die();

		$result = array_merge($result, [
			'total' => $total,
			'am' => $am,
			'pm' => $pm,
		]);

		//echo '<pre>';print_r($result);die();
		return $result;
	}

	/**
	 *
	 * @param unknown $data
	 * @return unknown
	 */
	public function getMathList($data)
	{
		//echo '<pre>';print_r($data);die();

		$result = [
			'am' => [
				'done' => 0,
				'notyet' => 0,
				'manual' => 0,
			],
			'pm' => [
				'done' => 0,
				'notyet' => 0,
				'manual' => 0,
			],
		];

		// get time_list
		$time_list = $this->statement->get(
			$keys = [
				['is_default', '=', 1],
				['is_disabled', '=', 0],
			],
			$orders = [],
			$table = 'mtb_time');
		//echo '<pre>';print_r($time_list);die();

		foreach($time_list as $key => $value) {

			// am
			if($value->is_am) {

				//
				$result['am']['done'] += $data['count_time_list']['done'][$value->mtb_time_id];
				$result['am']['notyet'] += $data['count_time_list']['notyet'][$value->mtb_time_id];
				$result['am']['manual'] += $data['count_time_list']['manual'][$value->mtb_time_id];
			}

			// pm
			else {

				//
				$result['pm']['done'] += $data['count_time_list']['done'][$value->mtb_time_id];
				$result['pm']['notyet'] += $data['count_time_list']['notyet'][$value->mtb_time_id];
				$result['pm']['manual'] += $data['count_time_list']['manual'][$value->mtb_time_id];
			}
		}

		//echo '<pre>';print_r($result);die();
		return $result;
	}
}
