<?php
namespace App\Services;

interface ServiceInterface
{
	/**
	 * --------------------------------------------------
	 * @param unknown $keys
	 * @param unknown $orders
	 * @param unknown $table
	 * --------------------------------------------------
	 */
	public function getList($keys, $orders, $table);

	/**
	 * --------------------------------------------------
	 * @param unknown $keys
	 * @param unknown $table
	 * --------------------------------------------------
	 */
	public function getFirst($keys, $table);

	/**
	 * --------------------------------------------------
	 * @param unknown $field
	 * @param unknown $keys
	 * @param unknown $table
	 * --------------------------------------------------
	 */
	public function getField($field, $keys, $table);

	/**
	 * --------------------------------------------------
	 * @param unknown $field
	 * @param unknown $keys
	 * @param unknown $table
	 * --------------------------------------------------
	 */
	public function getMax($field, $keys, $table);

    /**
	 * --------------------------------------------------
	 * @param unknown $field
	 * @param unknown $keys
	 * @param unknown $table
	 * --------------------------------------------------
	 */
	public function getMin($field, $keys, $table);

	/**
	 * --------------------------------------------------
	 * @param unknown $keys
	 * @param unknown $table
	 * --------------------------------------------------
	 */
	public function getCount($keys, $table);

	/**
	 * --------------------------------------------------
	 * @param array $values
	 * @param string $table
	 * --------------------------------------------------
	 */
	public function insertRow($values, $table);

    /**
	 * --------------------------------------------------
	 * @param array $keys
	 * @param array $values
	 * @param string $table
	 * --------------------------------------------------
	 */
	public function updateRow($keys, $values, $table);

	/**
	 * --------------------------------------------------
	 * @param array $keys
	 * @param string $table
	 * --------------------------------------------------
	 */
	public function deleteRow($keys, $table);
}
