<?php

namespace App\Services;

use Illuminate\Support\Facades\DB;
use Exception;

// use components
use	Carbon\Carbon,
	Config,
	Session,
	App\Helper;

// use repository interfaces
use App\Repositories\Statement,
	App\Repositories\View;

class Staff extends Service implements StaffInterface
{
	protected
		$statement,
		$view;

	/**
	 * --------------------------------------------------
	 * @param object $statement
	 * @param object $view
	 * --------------------------------------------------
	 */
	public function __construct(
		Statement $statement,
		View $view
	) {
		$this->statement = $statement;
		$this->view = $view;
	}

	/**
	 * ==================================================
	 * date
	 * ==================================================
	 */

    /**
	 * --------------------------------------------------
	 * @param array $keys
	 * @param array $orders
	 * @param array $options
	 * --------------------------------------------------
	 */
	public function getStaffList($keys = [], $orders = [], $options = [])
	{
		$result = $this->view->getStaffList(
			$keys,
			$orders,
			$options
		);

		//echo '<pre>';print_r($result);die();
		return $result;
	}

	/**
	 * --------------------------------------------------
	 * @param array $keys
	 * @param array $orders
	 * @param array $options
	 * --------------------------------------------------
	 */
	public function getStaffDropdownList($keys = [], $orders = [], $options = [])
	{
		$result = [];

		$return = $this->getStaffList(
			$keys,
			$orders,
			$options
		);
		//echo '<pre>';print_r($return);die();
	}

	/**
	 * --------------------------------------------------
	 * @param array $keys
	 * --------------------------------------------------
	 */
	public function getStaff($keys)
	{
        $result = $this->view->getStaff(
			$keys
		);

		//echo '<pre>';print_r($result);die();
		return $result;
	}

	/**
	 * --------------------------------------------------
	 * @param array $data
	 * --------------------------------------------------
	 */
	public function storeStaff($data)
	{

	}
}
