let video;
let prev, prev_ctx;
let canvas, canvas_ctx;
let voucher;
let qr;
let h, i;
let x1, y1;

window.addEventListener('load', function() {

	video = document.createElement('video');
	video.setAttribute("autoplay","");
	video.setAttribute("muted","");
	video.setAttribute("playsinline","");
	video.onloadedmetadata = function(e) {
		video.play();
	};

	prev = document.getElementById("preview");
	prev_ctx = prev.getContext("2d");

	canvas = document.createElement('canvas');
	canvas_ctx = canvas.getContext("2d");

    voucher = document.getElementById("voucher");
	qr = document.getElementById("qr");

	//カメラ使用の許可ダイアログが表示される
	navigator.mediaDevices.getUserMedia (

		//マイクはオフ, カメラの設定   できれば背面カメラ    できれば640×480
		{
			audio: false,
			video: {
				facingMode : 'environment',
				width: { ideal: 380 },
				height: { ideal: 600 }

				// "width": {
				// 	"ideal": 400
				// },
				// "height": {
				// 	"ideal": 200
				// }
			}
		}
	)
	//許可された場合
	.then (
		function(stream) {
			video.srcObject = stream;

			//0.5秒後にスキャンする
			setTimeout(Scan, 500);
		}
	)
	//許可されなかった場合
	.catch(
		function(err) {
			//qr.innerHTML = qr.innerHTML + err + '\n';
		}
	);
});
