@extends('backend.layouts.main')

{{-- content --}}
@section('content')

@include('backend.layouts.components.covid.booking.nav')

<!-- section -->
<section class="mb-3">

	<!-- toolbar -->
	<div class="d-flex justify-content-center align-items-center">
		<div>
			<a
				class=""
				href="{!! route('admin.covid.booking.calendar.index', [
					$date['prev']['yy'],
					$date['prev']['mm'],
					$mtb_vaccine_id,
				]) !!}"
			>
				<i class="fa-solid fa-circle-chevron-left fa-fw fa-2x"></i>
			</a>
		</div>
		<div class="mx-3">
			<span class="fs-4 fw-bold">
				{!! \Carbon\Carbon::create($yy, $mm, 1)->format(__("lang.date.yymm")) !!}
			</span>
		</div>
		<div>
			<a
				class=""
				href="{!! route('admin.covid.booking.calendar.index', [
					$date['next']['yy'],
					$date['next']['mm'],
					$mtb_vaccine_id,
				]) !!}"
			>
				<i class="fa-solid fa-circle-chevron-right fa-fw fa-2x"></i>
			</a>
		</div>
	</div>
	<!-- /.toolbar -->

</section>
<!-- /.section -->

<!-- section -->
<section class="mb-5">

	<!-- toolbar -->
	<div class="d-flex justify-content-center align-items-center mb-3">
		<div class="me-auto">
			<div class="input-group input-group-sm">
				<span class="input-group-text">
					{!! __("lang.master.vaccine.title") !!}
				</span>
				{!! Form::select('id', [''=>'指定なし'] + $vaccine_list, $mtb_vaccine_id, [
					'class' => 'form-select fw-bold',
				]) !!}
			</div>
		</div>
		<div></div>
	</div>
	<!-- /.toolbar -->

	@include('backend.layouts.components.booking')

</section>
<!-- /.section -->
@endsection

{{-- css --}}
@section('css')
<style>
small {
	font-size: 0.6rem;
}
</style>
@stop

{{-- js --}}
@section('js')
<script>
$(function() {

	$(document).on('change', 'select[name="id"]', function() {

		const id = $(this).val();
		const url = [
			'{!! route('admin.covid.booking.calendar.index', [
				$yy,
				$mm,
			]) !!}',
			id
		].join('/');

		window.location.href = url;
	});
});
</script>
@stop
