@extends('backend.layouts.main')

{{-- content --}}
@section('content')

@include('backend.layouts.components.covid.booking.nav')

<div class="row g-4">

	<!-- aside -->
	<aside class="col-lg-3">
		{!! Form::open($form) !!}
		{!! Form::hidden('yy', $yy) !!}
		{!! Form::hidden('mm', $mm) !!}
		{!! Form::hidden('dd', $dd) !!}

		<div class="card">
			<div class="card-body">

				<div class="mb-3">
					<label
						class="form-label"
						for=""
					>
						<span class="fw-bold">
							{!! __("lang.booking.date_booking") !!}
						</span>
					</label>
					<div class="input-group">
						{!! Form::select('booking[yy]', ['' => ''] + $yy_list, (isset($booking)) ? $booking['yy'] : '', [
							'class' => 'form-select',
							'style' => 'width:30%',
						]) !!}
						{!! Form::select('booking[mm]', ['' => ''] + $date_list['month_list'], (isset($booking)) ? $booking['mm'] : '', [
							'class' => 'form-select',
						]) !!}
						{!! Form::select('booking[dd]', ['' => ''] + $date_list['day_list'], (isset($booking)) ? $booking['dd'] : '', [
							'class' => 'form-select',
						]) !!}
					</div>
				</div>
				<div class="mb-3">
					<label
						class="form-label"
						for=""
					>
						<span class="fw-bold">
							{!! __("lang.booking.mobile") !!}
						</span>
					</label>
					{!! Form::tel('booking[mobile]', (isset($booking)) ? $booking['mobile'] : '', [
						'class' => 'form-control alphanumeric',
						'autofocus' => '',
					]) !!}
				</div>
				<div class="mb-3">
					<label
						class="form-label"
						for=""
					>
						<span class="fw-bold">
							{!! __("lang.booking.tel") !!}
						</span>
					</label>
					{!! Form::tel('booking[tel]', (isset($booking)) ? $booking['tel'] : '', [
						'class' => 'form-control alphanumeric',
					]) !!}
				</div>
				<div class="mb-3">
					<label
						class="form-label"
						for=""
					>
						<span class="fw-bold">
							{!! __("lang.booking.birthday") !!}
						</span>
					</label>
					<div class="input-group">
						{!! Form::select('birthday[yy]', ['' => ''] + $date_list['year_list'], (isset($birthday)) ? $birthday['yy'] : '', [
							'class' => 'form-select',
							'style' => 'width:30%',
						]) !!}
						{!! Form::select('birthday[mm]', ['' => ''] + $date_list['month_list'], (isset($birthday)) ? $birthday['mm'] : '', [
							'class' => 'form-select',
						]) !!}
						{!! Form::select('birthday[dd]', ['' => ''] + $date_list['day_list'], (isset($birthday)) ? $birthday['dd'] : '', [
							'class' => 'form-select',
						]) !!}
					</div>
				</div>
				<div class="mb-3">
					<label
						class="form-label"
						for=""
					>
						<span class="fw-bold">
							{!! __("lang.booking.patient_kana") !!}
						</span>
					</label>
					<div class="input-group">
						{!! Form::text('booking[patient_skana]', (isset($booking)) ? $booking['patient_skana'] : '', [
							'class' => 'form-control',
						]) !!}
						{!! Form::text('booking[patient_gkana]', (isset($booking)) ? $booking['patient_gkana'] : '', [
							'class' => 'form-control',
						]) !!}
					</div>
				</div>

				<div class="d-grid gap-2">
					<button
						class="btn btn-primary"
						type="submit"
					>
						<span class="fw-bold">
							{!! __("lang.button.search") !!}
						</span>
					</button>
					<a
						class="btn btn-light border border-secondary"
						href="{!! route('admin.covid.booking.search.index', [
							$yy,
							$mm,
							$dd,
						]) !!}"
					>
						<span class="fw-bold">
							{!! __("lang.button.reset") !!}
						</span>
					</a>
				</div>

			</div>
		</div>

		{!! Form::close() !!}
	</aside>
	<!-- /.aside -->

	<!-- main -->
	<main class="col col-lg-9">

		@if(isset($booking_list))

			<!-- toolbar -->
			<div class="d-flex justify-content-between align-items-center mb-3">
				<div>
					{!! __("lang.form.count") !!}：<span class="fw-bold">
						{!! $booking_list_count !!}
					</span>
				</div>
				<div>

				</div>
			</div>
			<!-- /.toolbar -->

			<!-- table -->
			<div class="table-responsive">
				<table class="table">
					<colgroup>
						<col>
						<col>
						<col>
						<col>
						<col>
						<col>
						<col width="100%">
						<col>
						<col>
					</colgroup>
					<thead>
						<tr>
							<th nowrap>
								&nbsp;
							</th>
							<th nowrap>
								#
							</th>
							<th nowrap>
								{!! __("lang.booking.date_booking") !!}
							</th>
							<th nowrap>
								{!! __("lang.booking.time_booking") !!}
							</th>
							<th nowrap>
								{!! __("lang.master.vaccine.title") !!}
							</th>
							<th nowrap>
								{!! __("lang.booking.voucher_number") !!}
							</th>
							<th nowrap>
								{!! __("lang.booking.patient_kana") !!}
							</th>
							<th nowrap>
								{!! __("lang.booking.birthday") !!}（{!! __("lang.booking.age") !!}）
							</th>
							<th nowrap>
								連絡先
							</th>
						</tr>
					</thead>
					<tbody>
						@if($booking_list_count > 0)
							@foreach($booking_list as $key => $value)
								<tr>
									<td nowrap>
										<div
											class="btn-group btn-group-sm"
											role="group"
										>
											<a
												class="btn btn-outline-secondary"
												href="{!! route('admin.covid.booking.status.show', [
													$value['yy'],
													$value['mm'],
													$value['dd'],
													$value['booking_code'],
												]) !!}"
											>
												<span class="fw-bold">
													{!! __("lang.button.show") !!}
												</span>
											</a>
											<a
												class="btn btn-outline-secondary"
												href="{!! route('admin.covid.booking.status.update', [
													$value['yy'],
													$value['mm'],
													$value['dd'],
                                                    $value['mtb_vaccine_id'],
													$value['booking_code'],
												]) !!}"
											>
												<span class="fw-bold">
													{!! __("lang.button.edit") !!}
												</span>
											</a>
										</div>
									</td>
									<th scope="row">
										{!! $key + 1 !!}
									</th>
									<td nowrap>
										{!! \Carbon\Carbon::create(
											$value['yy'],
											$value['mm'],
											$value['dd'],
										)->isoFormat('YYYY年MM月DD日（ddd）') !!}
									</td>
									<td nowrap>
										{!! \Carbon\Carbon::create(
											$value['yy'],
											$value['mm'],
											$value['dd'],
											$value['hh'],
											$value['ii'],
										)->format('H:i') !!}
									</td>
									<td nowrap>
										{!! $value['vaccine_label'] !!}
									</td>
									<td nowrap>
										{!! $value['voucher_number'] !!}
									</td>
									<td nowrap>
										{!! implode(' ', [
											$value['patient_skana'],
											$value['patient_gkana'],
										]) !!}
									</td>
									<td nowrap>
										{!! \Carbon\Carbon::parse($value['birthday'])->isoFormat('YYYY年MM月DD日') !!}（{!! App\Helper::getAge($value['birthday']) !!}）
									</td>
									<td nowrap>
										@if(is_null($value['mobile']))
											{!! $value['tel'] !!}
										@else
											{!! $value['mobile'] !!}
										@endif
									</td>
								</tr>
							@endforeach
						@else
							<tr>
								<td nowrap>
									<div
										class="btn-group btn-group-sm"
										role="group"
									>
										<a
											class="btn btn-outline-secondary disabled"
											href="#"
										>
											<span class="fw-bold">
												{!! __("lang.button.show") !!}
											</span>
										</a>
										<a
											class="btn btn-outline-secondary disabled"
											href="#"
										>
											<span class="fw-bold">
												{!! __("lang.button.edit") !!}
											</span>
										</a>
									</div>
								</td>
								<td colspan="7">
									{!! __("lang.error.empty") !!}
								</td>
							</tr>
						@endif
					</tbody>
				</table>
			</div>
			<!-- /.table -->
		@else

		@endif

	</main>
	<!-- /.main -->

</div>
@endsection

{{-- css --}}
@section('css')
<style>

</style>
@stop

{{-- js --}}
@section('js')
<script>
$(function() {

	$('.alphanumeric').on('input', function(e) {
		let value = $(e.currentTarget).val();
		value = value
			.replace(/[０-９]/g, function(s) {
				return String.fromCharCode(s.charCodeAt(0) - 65248);
			})
			.replace(/[^0-9]/g, '');
	  	$(e.currentTarget).val(value);
	});
});
</script>
@stop
