@extends('backend.layouts.main')

{{-- content --}}
@section('content')
@include('backend.layouts.components.tab')

<!-- row -->
<div class="row g-4 mb-5">

	<!-- aside -->
	<aside class="col col-lg-3">

		<div class="card mb-4">
			<ul class="list-group list-group-flush">
				<li class="list-group-item d-flex justify-content-between align-items-center">
					<div>
						<span class="fw-bold">
							接種日
						</span>
					</div>
					<div class="">
						<span class="fw-bold fs-5">
							{!! $booking['yy'] !!}
						</span>
						<span class="">
							{!! __("lang.date.yy") !!}
						</span>
						<span class="fw-bold fs-5">
							{!! $booking['mm'] !!}
						</span>
						<span class="">
							{!! __("lang.date.mm") !!}
						</span>
						<span class="fw-bold fs-5">
							{!! $booking['dd'] !!}
						</span>
						<span class="">
							{!! __("lang.date.dd") !!}
						</span>
					</div>
				</li>
				<li class="list-group-item d-flex justify-content-between align-items-center">
					<div>
						<span class="fw-bold">
							予約枠
						</span>
					</div>
					<div class="text-primary">
						<span class="fw-bold fs-5">
							{!! $count['accepted_numbers'] !!}
						</span>
						<span class="">
							{!! __("lang.unit.user") !!}
						</span>
					</div>
				</li>
				<li class="list-group-item d-flex justify-content-between align-items-center">
					<div>
						<span class="fw-bold">
							確定数
						</span>
					</div>
					<div class="text-success">
						<span class="fw-bold fs-5">
							{!! $count['booked_numbers'] !!}
						</span>
						<span class="">
							{!! __("lang.unit.user") !!}
						</span>
					</div>
				</li>
				<li class="list-group-item d-flex justify-content-between align-items-center">
					<div>
						<span class="fw-bold">
							残数
						</span>
					</div>
					<div class="text-warning">
						<span class="fw-bold fs-5">
							{!! $count['accepted_numbers'] - $count['booked_numbers'] !!}
						</span>
						<span class="">
							{!! __("lang.unit.user") !!}
						</span>
					</div>
				</li>
			</ul>
		</div>

		@if($booking['is_web'])
			<div class="card mb-3">
				<ul class="list-group list-group-flush">
					<li class="list-group-item d-flex justify-content-between align-items-center">
						<div class="">
							<span class="fw-bold">
								{!! __("lang.agent.agent_device") !!}
							</span>
						</div>
						<div class="">
							{!! $booking['agent_device'] !!}
						</div>
					</li>
					<li class="list-group-item d-flex justify-content-between align-items-center">
						<div class="">
							<span class="fw-bold">
								{!! __("lang.agent.agent_platform") !!}
							</span>
						</div>
						<div class="">
							{!! $booking['agent_platform'] !!}
						</div>
					</li>
					<li class="list-group-item d-flex justify-content-between align-items-center">
						<div class="">
							<span class="fw-bold">
								{!! __("lang.agent.agent_platform_version") !!}
							</span>
						</div>
						<div class="">
							{!! $booking['agent_platform_version'] !!}
						</div>
					</li>
					<li class="list-group-item d-flex justify-content-between align-items-center">
						<div class="">
							<span class="fw-bold">
								{!! __("lang.agent.agent_browser") !!}
							</span>
						</div>
						<div class="">
							{!! $booking['agent_browser'] !!}
						</div>
					</li>
					<li class="list-group-item d-flex justify-content-between align-items-center">
						<div class="">
							<span class="fw-bold">
								{!! __("lang.agent.agent_browser_version") !!}
							</span>
						</div>
						<div class="">
							{!! $booking['agent_browser_version'] !!}
						</div>
					</li>
					<li class="list-group-item d-flex justify-content-between align-items-center">
						<div class="">
							<span class="fw-bold">
								{!! __("lang.agent.agent_ip") !!}
							</span>
						</div>
						<div class="">
							{!! $booking['agent_ip'] !!}
						</div>
					</li>
					<li class="list-group-item d-flex justify-content-between align-items-center">
						<div class="">
							<span class="fw-bold">
								ロケーション
							</span>
						</div>
						<div class="">
							{!! implode(', ', [
								$geoip['city'],
								$geoip['state_name'],
							]) !!}
						</div>
					</li>
					<li class="list-group-item d-flex justify-content-between align-items-center">
						<div class="">
							<span class="fw-bold">
								{!! __("lang.agent.is_agent_mobile") !!}
							</span>
						</div>
						<div class="">
							@if($booking['is_agent_mobile'])
								{!! __("lang.dictionary.is_yesno.1") !!}
							@else
								{!! __("lang.dictionary.is_yesno.0") !!}
							@endif
						</div>
					</li>
					<li class="list-group-item d-flex justify-content-between align-items-center">
						<div class="">
							<span class="fw-bold">
								{!! __("lang.agent.is_agent_tablet") !!}
							</span>
						</div>
						<div class="">
							@if($booking['is_agent_tablet'])
								{!! __("lang.dictionary.is_yesno.1") !!}
							@else
								{!! __("lang.dictionary.is_yesno.0") !!}
							@endif
						</div>
					</li>
					<li class="list-group-item d-flex justify-content-between align-items-center">
						<div class="">
							<span class="fw-bold">
								{!! __("lang.agent.is_agent_desktop") !!}
							</span>
						</div>
						<div class="">
							@if($booking['is_agent_desktop'])
								{!! __("lang.dictionary.is_yesno.1") !!}
							@else
								{!! __("lang.dictionary.is_yesno.0") !!}
							@endif
						</div>
					</li>
				</ul>
			</div>
		@endif

	</aside>
	<!-- /.aside -->

	<!-- main -->
	<main class="col">

		<div class="card mb-3">
			<div class="card-body pb-2">

				<div class="row mb-2">
					<label
						class="col-lg-2 col-form-label text-lg-end"
						for=""
					>
						{!! __("lang.booking.is_web") !!}
					</label>
					<div class="col">
						{!! Form::text('', __("lang.dictionary.is_web.{$booking['is_web']}"), [
							'class' => 'form-control-plaintext',
							'readonly' => '',
						]) !!}
					</div>
				</div>
				<div class="row mb-2">
					<label
						class="col-lg-2 col-form-label text-lg-end"
						for=""
					>
						{!! __("lang.master.vaccine.title") !!}
					</label>
					<div class="col">
						{!! Form::text('', $booking['vaccine_label'], [
							'class' => 'form-control-plaintext',
							'readonly' => '',
						]) !!}
					</div>
				</div>
				<div class="row mb-2">
					<label
						class="col-lg-2 col-form-label text-lg-end"
						for=""
					>
						{!! __("lang.booking.is_staff") !!}
					</label>
					<div class="col">
						{!! Form::text('', __("lang.dictionary.is_yesno.{$booking['is_staff']}"), [
							'class' => 'form-control-plaintext',
							'readonly' => '',
						]) !!}
					</div>
				</div>
				<div class="row mb-2">
					<label
						class="col-lg-2 col-form-label text-lg-end"
						for=""
					>
						{!! __("lang.booking.is_disease") !!}
					</label>
					<div class="col">
						{!! Form::text('', __("lang.dictionary.is_yesno.{$booking['is_disease']}"), [
							'class' => 'form-control-plaintext',
							'readonly' => '',
						]) !!}
					</div>
				</div>
				<div class="row mb-2">
					<label
						class="col-lg-2 col-form-label text-lg-end"
						for=""
					>
						{!! __("lang.booking.date") !!}
					</label>
					<div class="col">
						{!! Form::text('', \Carbon\Carbon::create(
							$booking['yy'],
							$booking['mm'],
							$booking['dd']
						)->isoFormat('YYYY年MM月DD日（ddd）'), [
							'class' => 'form-control-plaintext',
							'readonly' => '',
						]) !!}
					</div>
				</div>
				<div class="row mb-2">
					<label
						class="col-lg-2 col-form-label text-lg-end"
						for=""
					>
						{!! __("lang.booking.time") !!}
					</label>
					<div class="col">
						{!! Form::text('', \Carbon\Carbon::create(
							$booking['yy'],
							$booking['mm'],
							$booking['dd'],
							$booking['hh'],
							$booking['ii'],
						)->format(__("lang.date.hhii")), [
							'class' => 'form-control-plaintext',
							'readonly' => '',
						]) !!}
					</div>
				</div>
				<div class="row mb-2">
					<label
						class="col-lg-2 col-form-label text-lg-end"
						for=""
					>
						{!! __("lang.booking.date_last") !!}
					</label>
					<div class="col">
						{!! Form::text('', \Carbon\Carbon::parse(
							$booking['date_last']
						)->format(__("lang.date.yymmdd")), [
							'class' => 'form-control-plaintext',
							'readonly' => '',
						]) !!}
					</div>
				</div>
				<div class="row mb-2">
					<label
						class="col-lg-2 col-form-label text-lg-end"
						for=""
					>
						{!! __("lang.booking.shots_number") !!}
					</label>
					<div class="col">
						{!! Form::text('', $booking['shots_number'] . '回', [
							'class' => 'form-control-plaintext',
							'readonly' => '',
						]) !!}
					</div>
				</div>
				<div class="row mb-2">
					<label
						class="col-lg-2 col-form-label text-lg-end"
						for=""
					>
						{!! __("lang.booking.voucher_number") !!}
					</label>
					<div class="col">
						{!! Form::text('', $booking['voucher_number'], [
							'class' => 'form-control-plaintext',
							'readonly' => '',
						]) !!}
					</div>
				</div>
				<div class="row mb-2">
					<label
						class="col-lg-2 col-form-label text-lg-end"
						for=""
					>
						{!! __("lang.booking.patient_kana") !!}
					</label>
					<div class="col">
						{!! Form::text('', implode(' ', [
							$booking['patient_skana'],
							$booking['patient_gkana'],
						]), [
							'class' => 'form-control-plaintext',
							'readonly' => '',
						]) !!}
					</div>
				</div>
				<div class="row mb-2">
					<label
						class="col-lg-2 col-form-label text-lg-end"
						for=""
					>
						{!! __("lang.booking.birthday") !!}
					</label>
					<div class="col">
						{!! Form::text('', \Carbon\Carbon::parse(
							$booking['birthday']
						)->format(__("lang.date.yymmdd")) . '（' . \App\Helper::getAge($booking['birthday']) . '歳）', [
							'class' => 'form-control-plaintext',
							'readonly' => '',
						]) !!}
					</div>
				</div>
				<div class="row mb-2">
					<label
						class="col-lg-2 col-form-label text-lg-end"
						for=""
					>
						{!! __("lang.booking.mobile") !!}
					</label>
					<div class="col">
						{!! Form::text('', $booking['mobile'], [
							'class' => 'form-control-plaintext',
							'readonly' => '',
						]) !!}
					</div>
				</div>
				<div class="row mb-0">
					<label
						class="col-lg-2 col-form-label text-lg-end"
						for=""
					>
						{!! __("lang.booking.tel") !!}
					</label>
					<div class="col">
						{!! Form::text('', $booking['tel'], [
							'class' => 'form-control-plaintext',
							'readonly' => '',
						]) !!}
					</div>
				</div>

			</div>
		</div>

	</main>
	<!-- /.main -->

</div>

<!-- scroll-to-top -->
<div
	class="scroll-to-top"
	style="z-index:999"
>
	<a
		class="btn btn-primary"
		href="{!! route('admin.covid.booking.update', [
			$booking['yy'],
			$booking['mm'],
			$booking['dd'],
			$booking['mtb_vaccine_id'],
			$booking_code,
		]) !!}"
		style="width:180px;"
	>
		<span class="fw-bold">
			{!! __("lang.button.edit") !!}
		</span>
	</a>
	<button
		class="btn btn-danger"
		type="button"
		data-bs-toggle="offcanvas"
		data-bs-target="#delete"
		aria-controls="delete"
		style="width:180px;"
	>
		<span class="fw-bold">
			{!! __("lang.button.delete") !!}
		</span>
	</button>
	<a
		class="btn btn-light border border-secondary"
		href="{!! url()->previous() !!}"
		style="width:180px;"
	>
		<span class="fw-bold">
			{!! __("lang.button.back") !!}
		</span>
	</a>
</div>
<!-- /.scroll-to-top -->

<!-- offcanvas -->
<div
	class="offcanvas offcanvas-bottom"
	tabindex="-1"
	id="delete"
>
	<div class="offcanvas-body text-center">
		<p class="fw-bold text-danger lead mt-3 mb-5">
			この予約を削除します。削除するとデータ復旧はできません。<br>
			本当によろしいですか？
		</p>
		<div class="d-grid gap-2 d-md-block">
			<a
				class="btn btn-danger"
				type="button"
				style="width:200px;"
				href="{!! route('admin.covid.booking.destroy', [
						$booking['yy'],
						$booking['mm'],
						$booking['dd'],
						$booking['booking_code'],
					]) !!}"
			>
				<span class="fw-bold">
					{!! __("lang.dictionary.is_yesno.1") !!}
				</span>
			</a>
			<button
				class="btn btn-outline-secondary"
				type="button"
				data-bs-dismiss="offcanvas"
				aria-label="Close"
				style="width:200px;"
			>
				<span class="fw-bold">
					{!! __("lang.dictionary.is_yesno.0") !!}
				</span>
			</button>
		</div>
	</div>
</div>
<!-- /.offcanvas -->
@endsection

{{-- css --}}
@section('css')
<style>

</style>
@stop

{{-- js --}}
@section('js')
<script>
$(function() {
	//
});
</script>
@stop
