@extends('backend.layouts.main')

{{-- content --}}
@section('content')
{!! Form::open($form) !!}
{!! Form::hidden('yy', $yy) !!}
{!! Form::hidden('mm', $mm) !!}
{!! Form::hidden('dd', $dd) !!}

@include('backend.layouts.components.covid.booking.nav')

{{-- section --}}
<section class="mb-3">

	<!-- toolbar -->
	<div class="d-flex justify-content-center align-items-center">
		<div>
			<a
				class=""
				href="{!! route('admin.covid.booking.status.index', [
					$date['prev']['yy'],
					$date['prev']['mm'],
					$date['prev']['dd'],
				]) !!}"
			>
				<i class="fa-solid fa-circle-chevron-left fa-fw fa-2x"></i>
			</a>
		</div>
		<div class="mx-3">
			<span class="fs-4 fw-bold">
				{!! \Carbon\Carbon::create($yy, $mm, $dd)->format(__("lang.date.yymmdd")) !!}（{!! \Carbon\Carbon::create(
					$yy,
					$mm,
					$dd,
				)->isoFormat('ddd') !!}）
			</span>
		</div>
		<div>
			<a
				class=""
				href="{!! route('admin.covid.booking.status.index', [
					$date['next']['yy'],
					$date['next']['mm'],
					$date['next']['dd'],
				]) !!}"
			>
				<i class="fa-solid fa-circle-chevron-right fa-fw fa-2x"></i>
			</a>
		</div>
	</div>
	<!-- /.toolbar -->

</section>
{{-- /.section --}}

{{-- section --}}
<section class="mb-5">

	<div class="row row-cols-1 row-cols-lg-4 g-3 mb-3">
		<div>
			<div class="card border border-secondary border-3 h-100">
				<div class="card-body py-1" style="margin-top:10px;">
					<dl class="d-flex justify-content-between align-items-center mb-0">
						<dt class="mb-0">
							ワクチン種別
						</dt>
						<dd class="text-dark mb-0">
							<span class="fw-bold fs-6">
								@if(isset($date['vaccine_label']))
									{!! $date['vaccine_label'] !!}
								@endif
							</span>
						</dd>
					</dl>
				</div>
			</div>
		</div>
		<div class="col">
			<div class="card border border-primary border-3 h-100">
				<div class="card-body py-1">
					<dl class="d-flex justify-content-between align-items-center text-primary mb-0">
						<dt class="mb-0">
							予約枠
						</dt>
						<dd class="text-primary mb-0">
							<span class="fw-bold fs-3">
								{!! (is_null($count['accepted_numbers'])) ? '-' : number_format($count['accepted_numbers']) !!}
							</span>
							<span class="">
								名
							</span>
						</dd>
					</dl>
				</div>
			</div>
		</div>
		<div class="col">
			<div class="card border border-success border-3 h-100">
				<div class="card-body py-1">
					<dl class="d-flex justify-content-between align-items-center text-success mb-0">
						<dt class="mb-0">
							確定数
						</dt>
						<dd class="text-success mb-0">
							<span class="fw-bold fs-3">
								{!! number_format($count['booked_numbers']) !!}
							</span>
							<span class="">
								名
							</span>
						</dd>
					</dl>
				</div>
			</div>
		</div>
		<div class="col">
			<div class="card border border-danger border-3 h-100">
				<div class="card-body py-1">
					<dl class="d-flex justify-content-between align-items-center text-danger mb-0">
						<dt class="mb-0">
							残数
						</dt>
						<dd class="mb-0">
							<span class="fw-bold fs-3">
								{!! number_format($count['accepted_numbers'] - $count['booked_numbers']) !!}
							</span>
							<span class="">
								名
							</span>
						</dd>
					</dl>
				</div>
			</div>
		</div>
	</div>

	@if($booking_list)
		<!-- nav -->
		<ul class="nav nav-tabs nav-justified mb-1">
			@foreach($booking_list as $hour => $content)

				{{-- 全て --}}
				@if($hour == 0)
					<li class="nav-item">
						<button
							class="nav-link py-1 active"
							data-bs-toggle="tab"
							data-bs-target="#tab{!! $hour !!}"
							type="button"
							role="tab"
							aria-controls="tab{!! $hour !!}"
							aria-selected="true"
						>
							<span class="fw-bold">
								全て
							</span>
						</button>
					</li>

				{{-- 時間別 --}}
				@else
					<li class="nav-item">
						<button
							class="nav-link py-1"
							data-bs-toggle="tab"
							data-bs-target="#tab{!! $hour !!}"
							type="button"
							role="tab"
							aria-controls="tab{!! $hour !!}"
							aria-selected="false"
						>
							<span class="fw-bold">
								{!! $hour !!}時
							</span>
						</button>
					</li>
				@endif
			@endforeach
		</ul>
		<!-- /.nav -->

		<!-- tab-content -->
		<div class="tab-content">
			@foreach($booking_list as $hour => $content)
				<div
					class="tab-pane fade {!! ($hour == 0) ? 'show active' : '' !!}"
					id="tab{!! $hour !!}"
					role="tabpanel"
					tabindex="0"
				>
					<!-- toolbar -->
					<div class="d-flex justify-content-between align-items-center mt-3 mb-3">
						<div>
							件数：<span class="fw-bold">{!! count($content) !!}</span>
						</div>
						<div>
							<div class="btn-group btn-group-sm" role="group">
								<a
									class="btn btn-outline-secondary border-secondary border-2"
									href="{!! route('admin.covid.export.vaccine.index', [
										$yy,
										$mm,
										$dd,
									]) !!}"
									style="margin-right: -1px;"
								>
									<span class="small fw-bold">
										{!! implode('', [
											'旧システム用CSV',
											__("lang.button.download"),
										]) !!}
									</span>
								</a>
								<a
									class="btn btn-outline-secondary border-secondary border-2"
									href="{!! route('admin.covid.export.day.index', [
										$yy,
										$mm,
										$dd,
									]) !!}"
								>
									<span class="small fw-bold">
										{!! implode('', [
											'予約リスト',
											__("lang.button.download"),
										]) !!}
									</span>
								</a>
							</div>
						</div>
					</div>
					<!-- /.toolbar -->

					<!-- table -->
					<table class="table">
						<colgroup>
							<col>
							@if ($hour == 0)
								<col>
							@endif
							<col>
							<col>
							{{-- <col> --}}
							<col>
							<col>
							{{-- <col> --}}
							<col>
							<col width="100%">
							<col>
							{{-- <col> --}}
							<col>
							<col>
							<col>
							<col>
						</colgroup>
						<thead>
							<tr>
								<th scope="col" nowrap>
									&nbsp;
								</th>
								@if ($hour == 0)
									<th scope="col" nowrap>
										<div class="text-center pt-1">
											<input
												type="checkbox"
												name="all_check"
												id="all"
												class="border"
											>
										</div>
									</th>
								@endif
								<th scope="col" nowrap>
									#
								</th>
								<th scope="col" nowrap>
									時間
								</th>
								<th scope="col" nowrap>
									受付
								</th>
								{{-- <th scope="col" nowrap>
									{!! __("lang.booking.voucher_number") !!}
								</th> --}}
								<th scope="col" nowrap>
									市区町村
								</th>
								{{-- <th scope="col" nowrap>
									医従者
								</th> --}}
								<th scope="col" nowrap>
									{{-- {!! __("lang.booking.is_disease") !!} --}}
									基疾
								</th>
								<th scope="col" nowrap>
									{!! __("lang.booking.patient_kana") !!}
								</th>
								<th scope="col" nowrap>
									{!! __("lang.booking.birthday") !!}（{!! __("lang.booking.age") !!}）
								</th>
								{{-- <th scope="col" nowrap>
									接種回数
								</th> --}}
								<th scope="col" nowrap>
									{!! __("lang.booking.mobile") !!}
								</th>
								<th scope="col" nowrap>
									{!! __("lang.booking.tel") !!}
								</th>
								<th scope="col" nowrap>
									予約受付日時
								</th>
								<th scope="col" nowrap>
									応対者
								</th>
							</tr>
						</thead>
						<tbody class="table-group-divider">
							@if(count($content) > 0)
								@foreach($content as $key => $value)
									<tr>
										<td nowrap>
											<div
												class="btn-group btn-group-sm"
												role="group"
											>
												<a
													class="btn btn-outline-{!! (App\Helper::getIsPDF($value)) ? 'primary' : 'secondary disabled' !!}"
													href="{!! route('admin.covid.booking.pdf.create', [
														$value['booking_code'],
													]) !!}"
													target="_blank"
													style="width:60px;"
												>
													<span class="small fw-bold">
														問診票
													</span>
												</a>
												<a
													class="btn btn-outline-primary"
													href="{!! route('admin.covid.booking.status.show', [
														$value['yy'],
														$value['mm'],
														$value['dd'],
														$value['booking_code'],
													]) !!}"
												>
													<span class="small fw-bold">
														{!! __("lang.button.show") !!}
													</span>
												</a>
												<a
													class="btn btn-outline-primary"
													href="{!! route('admin.covid.booking.status.update', [
														$value['yy'],
														$value['mm'],
														$value['dd'],
														$value['mtb_vaccine_id'],
														$value['booking_code'],
													]) !!}"
												>
													<span class="small fw-bold">
														{!! __("lang.button.edit") !!}
													</span>
												</a>
											</div>
										</td>
										@if ($hour == 0)
											<td nowrap>
												<div class="text-center pt-1">
													@if (App\Helper::getIsPDF($value))
														{!! Form::checkbox("bulk[]", $value['signin_code'], true, [
															'class' => 'bulk border',
														]) !!}
													@else
														{!! Form::checkbox('', '', false, [
															'class' => '',
															'disabled' => '',
														]) !!}
													@endif
												</div>
											</td>
										@endif
										<th scope="col" nowrap>
											{!! $key + 1 !!}
										</th>
										<td nowrap>
											{!! $value['time'] !!}
										</td>
										<td nowrap>
											@if($value['is_walkin'])
												<span class="fw-bold text-warning">
													未予
												</span>
											@else
												<span class="fw-bold {!! ($value['is_web']) ? 'text-primary' : 'text-danger' !!}">
													{!! __("lang.dictionary.is_web.{$value['is_web']}") !!}
												</span>
											@endif
										</td>
										{{-- <td nowrap>
											{!! $value['voucher_number'] !!}
										</td> --}}
										<td nowrap>
											{!! $value['address1'] !!}
										</td>
										{{-- <td nowrap>
											<div class="text-center text-dark">
												@if($value['is_staff'])
													<i class="fa-solid fa-check fa-fw fa-lg"></i>
												@endif
											</div>
										</td> --}}
										<td nowrap>
											<div class="text-center text-dark">
												@if($value['is_disease'])
													<i class="fa-solid fa-check fa-fw fa-lg"></i>
												@endif
											</div>
										</td>
										<td>
											{!! implode(' ', [
												$value['patient_skana'],
												$value['patient_gkana']
											]) !!}
										</td>
										<td nowrap>
											{!! \Carbon\Carbon::parse($value['birthday'])->format(__("lang.date.yymmdd")) !!}（{!! App\Helper::getAge(\Carbon\Carbon::parse($value['birthday'])->format('Y-m-d')) !!}）
										</td>
										{{-- <td nowrap>
											<div class="text-center">
												{!! $value['shots_number'] !!}
												<small>
													回
												</small>
											</div>
										</td> --}}
										<td nowrap>
											{!! $value['mobile'] !!}
										</td>
										<td nowrap>
											{!! $value['tel'] !!}
										</td>
										<td nowrap>
											{!! \Carbon\Carbon::parse($value['timestamp'])->format(__("lang.date.yymmddhhii")) !!}
										</td>
										<td nowrap>
											@if(!$value['is_web'])
												@if(!is_null($value['staff_sname']))
													{!! implode(' ', [
														$value['staff_sname'],
														$value['staff_gname'],
													]) !!}
												@endif
											@endif
										</td>
									</tr>
								@endforeach
							@else
								<tr>
									<td nowrap>
										<div
											class="btn-group"
											role="group"
										>
											<a
												class="btn btn-outline-secondary btn-sm disabled"
												href=""
											>
												<small class="fw-bold">
													{!! __("lang.button.show") !!}
												</small>
											</a>
											<a
												class="btn btn-outline-secondary btn-sm disabled"
												href=""
											>
												<small class="fw-bold">
													{!! __("lang.button.edit") !!}
												</small>
											</a>
										</div>
									</td>
									<td colspan="14">
										<div class="fw-bold text-muted text-center">
											{!! __("lang.error.empty") !!}
										</div>
									</td>
								</tr>
							@endif
						</tbody>
					</table>
				</div>
			@endforeach
		</div>
		<!-- /.tab-content -->
	@else
		<div
			class="alert alert-secondary"
			role="alert"
		>
			<p class="text-center mb-0">
				{!! __("lang.error.empty") !!}
			</p>
		</div>
	@endif
</section>
{{-- /.section --}}

{{-- button --}}
<div
	class="scroll-to-top"
	style="z-index:999"
>
	@if(!is_null($count['accepted_numbers']))
		@if($count['remain_numbers'] > 0)
			<a
				class="btn btn-primary"
				href="{!! route('admin.covid.booking.status.update', [
					$yy,
					$mm,
					$dd,
					$date['mtb_vaccine_id'],
				]) !!}"
				style="width:140px;"
			>
				<span class="fw-bold">
					{!! __("lang.booking.create") !!}
				</span>
			</a>
		@endif
	@endif
	<button
		class="btn btn-outline-primary"
		type="submit"
		style="width:140px;"
	>
		<span class="fw-bold">
			一括印刷
		</span>
	</button>
	<a
		class="btn btn-dark"
		href="#page-top"
	>
		<span class="fw-bold">
			<i class="fas fa-angle-up"></i>
		</span>
	</a>
</div>
{{-- /.button --}}

{!! Form::close() !!}
@endsection
{{-- /.content --}}

{{-- css --}}
@section('css')
<style>

</style>
@stop

{{-- js --}}
@section('js')
<script>
$(function() {
	
	$('#all').on('click',function() {
		$('input[name="bulk[]"]').prop('checked',this.checked);
	});

	$('input[name="bulk[]"]').on('click',function(){
		if($('.bulk :checked').length == $('.bulk input').length ) {
			$('#all').prop('checked',true);
		} else {
			$('#all').prop('checked',false);
		}
	});
});
</script>
@stop
