@extends('backend.layouts.main')

{{-- content --}}
@section('content')

@include('backend.layouts.components.covid.booking.nav')

{!! Form::open($form) !!}
{!! Form::hidden('booking[booking_code]', $booking_code) !!}
{!! Form::hidden('booking[yy]', $yy) !!}
{!! Form::hidden('booking[mm]', $mm) !!}
{!! Form::hidden('booking[dd]', $dd) !!}
{!! Form::hidden('booking[is_web]', 0) !!}
{!! Form::hidden('booking[mtb_vaccine_id]', $date['mtb_vaccine_id']) !!}

<!-- row -->
<div class="row g-4 mb-5">

	<!-- aside -->
	<aside class="col col-lg-3">

		<div class="card mb-4">
			<ul class="list-group list-group-flush">
				<li class="list-group-item d-flex justify-content-between align-items-center">
					<div>
						<span class="fw-bold">
							接種日
						</span>
					</div>
					<div class="">
						{{-- <span class="fw-bold fs-5">
							{!! \Carbon\Carbon::create(
								$yy,
								$mm,
								$dd
							)->format(__("lang.date.yymmdd")) !!}
						</span> --}}
						<span class="fw-bold fs-5">
							{!! $yy !!}
						</span>
						<span class="">
							{!! __("lang.date.yy") !!}
						</span>
						<span class="fw-bold fs-5">
							{!! $mm !!}
						</span>
						<span class="">
							{!! __("lang.date.mm") !!}
						</span>
						<span class="fw-bold fs-5">
							{!! $dd !!}
						</span>
						<span class="">
							{!! __("lang.date.dd") !!}
						</span>
					</div>
				</li>
				<li class="list-group-item d-flex justify-content-between align-items-center">
					<div>
						<span class="fw-bold">
							予約枠
						</span>
					</div>
					<div class="text-primary">
						<span class="fw-bold fs-5">
							{!! $count['accepted_numbers'] !!}
						</span>
						<span class="">
							{!! __("lang.unit.user") !!}
						</span>
					</div>
				</li>
				<li class="list-group-item d-flex justify-content-between align-items-center">
					<div>
						<span class="fw-bold">
							確定数
						</span>
					</div>
					<div class="text-success">
						<span class="fw-bold fs-5">
							{!! $count['booked_numbers'] !!}
						</span>
						<span class="">
							{!! __("lang.unit.user") !!}
						</span>
					</div>
				</li>
				<li class="list-group-item d-flex justify-content-between align-items-center">
					<div>
						<span class="fw-bold">
							残数
						</span>
					</div>
					<div class="text-warning">
						<span class="fw-bold fs-5">
							{!! $count['accepted_numbers'] - $count['booked_numbers'] !!}
						</span>
						<span class="">
							{!! __("lang.unit.user") !!}
						</span>
					</div>
				</li>
			</ul>
		</div>

		@include('backend.layouts.components.sidebar-calendar')

	</aside>
	<!-- /.aside -->

	<!-- main -->
	<main class="col col-lg-9">

		{{-- alert --}}
		@if($errors->any())
			<div class="alert alert-danger mb-4" role="alert">
				<ul class="mb-0 ps-3">
					@foreach ($errors->all() as $error)
						<li>
							{!! $error !!}
						</li>
					@endforeach
				</ul>
			</div>
		@endif
		{{-- /.alert --}}

		<span class="p-country-name" style="display:none;">Japan</span>
		<div class="card mb-3">
			<div class="card-body pb-0">

				<div class="row mb-3">
					<label
						class="col-lg-2 col-form-label text-lg-end"
						for=""
					>
						{!! __("lang.booking.date") !!}
					</label>
					<div class="col">
						{!! Form::text('', \Carbon\Carbon::create(
							$yy,
							$mm,
							$dd
						)->isoFormat('YYYY年MM月DD日（ddd）'), [
							'class' => 'form-control-plaintext',
							'readonly' => '',
						]) !!}
					</div>
				</div>
				<div class="row mb-3">
					<label
						class="col-lg-2 col-form-label text-lg-end"
						for=""
					>
						{!! __("lang.booking.time") !!}
						<span class="badge rounded-pill text-bg-danger">
							{!! __("lang.form.required") !!}
						</span>
					</label>
					<div class="col col-lg-3">
						@if(is_null($booking_code))
							<select
								class="form-select"
								name="booking[mtb_time_id]"
							>
								@foreach($time_list as $key => $value)
									<option
										value="{!! $key !!}"
										@if(isset($booking))
											{!! (($value['hh'] == $booking['hh']) && ($value['ii'] == $booking['ii'])) ? 'selected' : '' !!}
										@else
											{!! ($key == old("booking.mtb_time_id")) ? 'selected' : '' !!}
										@endif
										{!! ($value['accepted_number'] == 0 || $value['accepted_number'] <= $value['booked_number']) ? 'disabled' : '' !!}
									>
										{!! ($value['accepted_number'] == 0 || $value['accepted_number'] <= $value['booked_number']) ? '×' : '○' !!}&nbsp;
										{!! \Carbon\Carbon::create(
											$yy,
											$mm,
											$dd,
											$value['hh'],
											$value['ii']
										)->format('H:i') !!}
										（{!! $value['booked_number'] !!} / {!! $value['accepted_number'] !!}）
									</option>
								@endforeach
							</select>
						@else
							<select
								class="form-select"
								name="booking[mtb_time_id]"
							>
								@foreach($time_list as $key => $value)
									<option
										value="{!! $key !!}"
										@if(isset($booking))
											{!! (($value['hh'] == $booking['hh']) && ($value['ii'] == $booking['ii'])) ? 'selected' : '' !!}
										@else
											{!! ($key == old("booking.mtb_time_id")) ? 'selected' : '' !!}
										@endif
										{{--{!! ($value['accepted_number'] == 0 || $value['accepted_number'] <= $value['booked_number']) ? 'disabled' : '' !!}--}}
									>
										{!! ($value['accepted_number'] == 0 || $value['accepted_number'] <= $value['booked_number']) ? '×' : '○' !!}&nbsp;
										{!! \Carbon\Carbon::create(
											$yy,
											$mm,
											$dd,
											$value['hh'],
											$value['ii']
										)->format('H:i') !!}
										（{!! $value['booked_number'] !!} / {!! $value['accepted_number'] !!}）
									</option>
								@endforeach
							</select>
							{{--{!! Form::text('booking[mtb_time_id]', \Carbon\Carbon::create(
								$date['yy'],
								$date['mm'],
								$date['dd'],
								$time['hh'],
								$time['ii'],
								00
							)->format('H:i'), [
								'class' => 'form-control-plaintext',
								'readonly' => '',
							]) !!}
							{!! Form::hidden('booking[mtb_time_id]', $time['mtb_time_id']) !!}--}}
						@endif
					</div>
				</div>
				<div class="row mb-3">
					<label
						class="col-lg-2 col-form-label text-lg-end"
						for=""
					>
						{!! __("lang.master.vaccine.title") !!}
					</label>
					<div class="col">
						@if(isset($date['mtb_date_id']))
							{!! Form::text('', $vaccine_list[$date['mtb_vaccine_id']], [
								'class' => 'form-control-plaintext',
								'readonly' => '',
							]) !!}
						@endif
					</div>
				</div>
				<div class="row mb-3">
					<label
						class="col-lg-2 col-form-label text-lg-end"
						for=""
					>
						{!! __("lang.booking.is_web") !!}
					</label>
					<div class="col">
						{!! Form::text('', __("lang.dictionary.is_web." . ((isset($booking)) ? $booking['is_web'] : 0)), [
							'class' => 'form-control-plaintext',
							'readonly' => '',
						]) !!}
					</div>
				</div>
				<div class="row mb-3 d-none">
					<label
						class="col-lg-2 col-form-label text-lg-end"
						for=""
					>
						{!! __("lang.booking.is_staff") !!}
						<span class="badge rounded-pill text-bg-danger">
							{!! __("lang.form.required") !!}
						</span>
					</label>
					<div class="col">
						@for($i = 1; $i >= 0; $i--)
							<div class="form-check-inline me-1">
								{!! Form::radio('booking[is_staff]', $i, (isset($booking)) ? (($i == $booking['is_staff']) ? true : false) : (($i == 0) ? true : false), [
									'class' => 'btn-check',
									'id' => "is_staff{$i}",
									'autocomplete' => 'off',
								]) !!}
								<label
									class="btn btn-outline-primary mb-0 px-3"
									for="is_staff{!! $i !!}"
									style="width:100px;"
								>
									<span class="fw-bold">
										{!! __("lang.dictionary.is_yesno.{$i}") !!}
									</span>
								</label>
							</div>
						@endfor
					</div>
				</div>
				<div class="row mb-3">
					<label
						class="col-lg-2 col-form-label text-lg-end"
						for=""
					>
						{!! __("lang.booking.is_disease") !!}
						<span class="badge rounded-pill text-bg-danger">
							{!! __("lang.form.required") !!}
						</span>
					</label>
					<div class="col">
						@for($i = 1; $i >= 0; $i--)
							<div class="form-check-inline me-1">
								{!! Form::radio('booking[is_disease]', $i, (isset($booking)) ? (($i == $booking['is_disease']) ? true : false) : (($i == 0) ? true : false), [
									'class' => 'btn-check',
									'id' => "is_disease{$i}",
									'autocomplete' => 'off',
								]) !!}
								<label
									class="btn btn-outline-primary btn-sm mb-0 px-3"
									for="is_disease{!! $i !!}"
									style="width:100px;"
								>
									<span class="fw-bold">
										{!! __("lang.dictionary.is_yesno.{$i}") !!}
									</span>
								</label>
							</div>
						@endfor
					</div>
				</div>
				<div class="row mb-3">
					<label
						class="col-lg-2 col-form-label text-lg-end"
						for=""
					>
						{!! __("lang.booking.patient_kana") !!}
						<span class="badge rounded-pill text-bg-danger">
							{!! __("lang.form.required") !!}
						</span>
					</label>
					<div class="col col-lg-6">
						<div class="input-group">
							{!! Form::text('booking[patient_skana]', (isset($booking)) ? $booking['patient_skana'] : '', [
								'class' => 'form-control',
								'placeholder' => '例）ふさ',
							]) !!}
							{!! Form::text('booking[patient_gkana]', (isset($booking)) ? $booking['patient_gkana'] : '', [
								'class' => 'form-control',
								'placeholder' => '例）いちろう',
							]) !!}
						</div>
					</div>
				</div>
				<div class="row mb-3">
					<label
						class="col-lg-2 col-form-label text-lg-end"
						for=""
					>
						{!! __("lang.booking.birthday") !!}
						<span class="badge rounded-pill text-bg-danger">
							{!! __("lang.form.required") !!}
						</span>
					</label>
					<div class="col col-lg-8">
						<div class="input-group">
							{{-- {!! Form::number('birthday[yy]', (isset($booking)) ? $birthday['yy'] : '1970', [
								'class' => 'form-control',
								'min' => '0',
								'pattern' => '^[0-9]+$',
							]) !!} --}}
							{{-- {!! Form::selectRange('birthday[yy]', 1900, date('Y'), (isset($booking)) ? $birthday['yy'] : 1970, [
								'class' => 'form-select',
							]) !!} --}}
							{!! Form::select('birthday[yy]', $wareki_list, (isset($booking)) ? $birthday['yy'] : 1970, [
								'class' => 'form-select',
							]) !!}
							<span class="input-group-text">
								{!! __("lang.date.yy") !!}
							</span>
							{!! Form::selectRange('birthday[mm]', 1, 12, (isset($booking)) ? $birthday['mm'] : '', [
								'class' => 'form-select',
							]) !!}
							<span class="input-group-text">
								{!! __("lang.date.mm") !!}
							</span>
							{!! Form::selectRange('birthday[dd]', 1, 31, (isset($booking)) ? $birthday['dd'] : '', [
								'class' => 'form-select',
							]) !!}
							<span class="input-group-text">
								{!! __("lang.date.dd") !!}
							</span>
						</div>
					</div>
				</div>
				<div class="row mb-3">
					<label
						class="col-lg-2 col-form-label text-lg-end"
						for=""
					>
						{!! __("lang.booking.mobile") !!}
					</label>
					<div class="col col-lg-6">
						{!! Form::tel('booking[mobile]', (isset($booking)) ? $booking['mobile'] : '', [
							'class' => 'form-control',
							'placeholder' => '例）09012345678',
						]) !!}
					</div>
				</div>
				<div class="row mb-3">
					<label
						class="col-lg-2 col-form-label text-lg-end"
						for=""
					>
						{!! __("lang.booking.tel") !!}
					</label>
					<div class="col col-lg-6">
						{!! Form::text('booking[tel]', (isset($booking)) ? $booking['tel'] : '', [
							'class' => 'form-control',
							'placeholder' => '例）0471891111',
						]) !!}
					</div>
				</div>

				<div class="row mb-3">
					<label
						class="col-lg-2 col-form-label text-lg-end"
						for=""
					>
						郵便番号
					</label>
					<div class="col col-lg-2">
						{!! Form::tel('booking[zip]', (isset($booking)) ? $booking['zip'] : '', [
							'class' => 'form-control p-postal-code',
							'placeholder' => '例）2701101',
							'maxlength' => 7,
						]) !!}
					</div>
				</div>
				<div class="row mb-3">
					<label
						class="col-lg-2 col-form-label text-lg-end"
						for=""
					>
						<span class="badge rounded-pill text-bg-danger me-2">
							{!! __("lang.form.required") !!}
						</span>
						<span class="fw-bold">
							住所
						</span>
					</label>
					<div class="col col-lg-6">
						<div class="input-group mb-2">
							{!! Form::select('booking[mtb_pref_id]', $pref_list, (isset($booking)) ? $booking['mtb_pref_id'] : 12, [
								'class' => 'form-select p-region-id',
							]) !!}
						</div>
						<div class="input-group mb-2">
							{!! Form::text('booking[address1]', isset($booking) ? $booking['address1'] : '', [
								'class' => 'form-control p-locality',
								'placeholder' => '例）我孫子市',
								// 'disabled' => '',
							]) !!}
						</div>
						<div class="input-group mb-2">
							{!! Form::text('booking[address2]', isset($booking) ? $booking['address2'] : '', [
								'class' => 'form-control p-street-address',
								'placeholder' => '例）布佐',
							]) !!}
						</div>
						<div class="input-group">
							{!! Form::text('booking[address3]', isset($booking) ? $booking['address3'] : '', [
								'class' => 'form-control p-extended-address',
								'placeholder' => '例）834-28 建物名等',
							]) !!}
						</div>
					</div>
				</div>

			</div>
		</div>

	</main>
	<!-- /.main -->

</div>
<!-- /.row -->

<!-- scroll-to-top -->
<div
	class="scroll-to-top"
	style="z-index:999"
>
	@if(isset($booking))
		<button
			class="btn btn-success"
			id="submit"
			type="submit"
			name="action"
			value="store"
			style="width:180px;"
		>
			<span class="fw-bold">
				更新
			</span>
		</button>
	@else
		@if(isset($date['mtb_date_id']))
			{{--@if($count['accepted_numbers'] > $count['booked_numbers'] || !is_null($booking_code))--}}
			@if($count['accepted_numbers'] > $count['booked_numbers'])
				<button
					class="btn btn-primary"
					id="submit"
					type="submit"
					name="action"
					value="store"
					style="width:180px;"
				>
					<span class="fw-bold">
						{!! __("lang.button.submit") !!}
					</span>
				</button>
			@endif
		@endif
	@endif
	<a
		class="btn btn-light border border-secondary"
		href="{!! route('admin.covid.booking.status.index', [
			$yy,
			$mm,
			$dd,
		]) !!}"
		style="width:180px;"
	>
		<span class="fw-bold">
			{!! __("lang.button.back") !!}
		</span>
	</a>
</div>
<!-- /.scroll-to-top -->

{!! Form::close() !!}
@endsection

{{-- css --}}
@section('css')
<style>

</style>
@stop

{{-- js --}}
@section('js')
<script src="https://yubinbango.github.io/yubinbango/yubinbango.js" charset="UTF-8"></script>
<script>
$(function() {

	$('form').submit(function() {

		const mobile = $('input[name="booking[mobile]"]').val();
		const tel = $('input[name="booking[tel]"]').val();

		if(mobile == '' && tel == '') {
			alert('携帯電話番号、または自宅電話番号を入力してください');
			return false;
		}
	});
});
</script>
@stop
