@extends('backend.layouts.main')

{{-- content --}}
@section('content')
@include('backend.layouts.components.tab')

{!! Form::open($form) !!}
{!! Form::hidden('booking[booking_code]', $booking_code) !!}
{!! Form::hidden('booking[yy]', $yy) !!}
{!! Form::hidden('booking[mm]', $mm) !!}
{!! Form::hidden('booking[dd]', $dd) !!}
{!! Form::hidden('booking[is_web]', 0) !!}
{!! Form::hidden('booking[mtb_vaccine_id]', $date['mtb_vaccine_id']) !!}

<!-- row -->
<div class="row g-4 mb-5">

	<!-- aside -->
	<aside class="col col-lg-3">

		<div class="card mb-4">
			<ul class="list-group list-group-flush">
				<li class="list-group-item d-flex justify-content-between align-items-center">
					<div>
						<span class="fw-bold">
							接種日
						</span>
					</div>
					<div class="">
						{{-- <span class="fw-bold fs-5">
							{!! \Carbon\Carbon::create(
								$yy,
								$mm,
								$dd
							)->format(__("lang.date.yymmdd")) !!}
						</span> --}}
						<span class="fw-bold fs-5">
							{!! $yy !!}
						</span>
						<span class="">
							{!! __("lang.date.yy") !!}
						</span>
						<span class="fw-bold fs-5">
							{!! $mm !!}
						</span>
						<span class="">
							{!! __("lang.date.mm") !!}
						</span>
						<span class="fw-bold fs-5">
							{!! $dd !!}
						</span>
						<span class="">
							{!! __("lang.date.dd") !!}
						</span>
					</div>
				</li>
				<li class="list-group-item d-flex justify-content-between align-items-center">
					<div>
						<span class="fw-bold">
							予約枠
						</span>
					</div>
					<div class="text-primary">
						<span class="fw-bold fs-5">
							{!! $count['accepted_numbers'] !!}
						</span>
						<span class="">
							{!! __("lang.unit.user") !!}
						</span>
					</div>
				</li>
				<li class="list-group-item d-flex justify-content-between align-items-center">
					<div>
						<span class="fw-bold">
							確定数
						</span>
					</div>
					<div class="text-success">
						<span class="fw-bold fs-5">
							{!! $count['booked_numbers'] !!}
						</span>
						<span class="">
							{!! __("lang.unit.user") !!}
						</span>
					</div>
				</li>
				<li class="list-group-item d-flex justify-content-between align-items-center">
					<div>
						<span class="fw-bold">
							残数
						</span>
					</div>
					<div class="text-warning">
						<span class="fw-bold fs-5">
							{!! $count['accepted_numbers'] - $count['booked_numbers'] !!}
						</span>
						<span class="">
							{!! __("lang.unit.user") !!}
						</span>
					</div>
				</li>
			</ul>
		</div>

		@include('backend.layouts.components.sidebar-calendar')

	</aside>
	<!-- /.aside -->

	<!-- main -->
	<main class="col col-lg-9">

		{{-- alert --}}
		@if($errors->any())
			<div class="alert alert-danger mb-4" role="alert">
				<ul class="mb-0 ps-3">
					@foreach ($errors->all() as $error)
						<li>
							{!! $error !!}
						</li>
					@endforeach
				</ul>
			</div>
		@endif
		{{-- /.alert --}}

		<div class="card mb-3">
			<div class="card-body pb-0">

				<div class="row mb-3">
					<label
						class="col-lg-2 col-form-label text-lg-end"
						for=""
					>
						{!! __("lang.booking.date") !!}
					</label>
					<div class="col">
						{!! Form::text('', \Carbon\Carbon::create(
							$yy,
							$mm,
							$dd
						)->isoFormat('YYYY年MM月DD日（ddd）'), [
							'class' => 'form-control-plaintext',
							'readonly' => '',
						]) !!}
					</div>
				</div>
				<div class="row mb-3">
					<label
						class="col-lg-2 col-form-label text-lg-end"
						for=""
					>
						{!! __("lang.booking.time") !!}
						<span class="badge rounded-pill text-bg-danger">
							{!! __("lang.form.required") !!}
						</span>
					</label>
					<div class="col">
						@if(is_null($booking_code))
							<select
								class="form-select"
								name="booking[mtb_time_id]"
							>
								@foreach($time_list as $key => $value)
									<option
										value="{!! $key !!}"
										@if(isset($booking))
											{!! (($value['hh'] == $booking['hh']) && ($value['ii'] == $booking['ii'])) ? 'selected' : '' !!}
										@else
											{!! ($key == old("booking.mtb_time_id")) ? 'selected' : '' !!}
										@endif
										{!! ($value['accepted_number'] == 0 || $value['accepted_number'] <= $value['booked_number']) ? 'disabled' : '' !!}
									>
										{!! ($value['accepted_number'] == 0 || $value['accepted_number'] <= $value['booked_number']) ? '×' : '○' !!}&nbsp;
										{!! \Carbon\Carbon::create(
											$yy,
											$mm,
											$dd,
											$value['hh'],
											$value['ii']
										)->format('H:i') !!}
										（{!! $value['booked_number'] !!} / {!! $value['accepted_number'] !!}）
									</option>
								@endforeach
							</select>
						@else
                            <select
								class="form-select"
								name="booking[mtb_time_id]"
							>
								@foreach($time_list as $key => $value)
									<option
										value="{!! $key !!}"
										@if(isset($booking))
											{!! (($value['hh'] == $booking['hh']) && ($value['ii'] == $booking['ii'])) ? 'selected' : '' !!}
										@else
											{!! ($key == old("booking.mtb_time_id")) ? 'selected' : '' !!}
										@endif
										{{--{!! ($value['accepted_number'] == 0 || $value['accepted_number'] <= $value['booked_number']) ? 'disabled' : '' !!}--}}
									>
										{!! ($value['accepted_number'] == 0 || $value['accepted_number'] <= $value['booked_number']) ? '×' : '○' !!}&nbsp;
										{!! \Carbon\Carbon::create(
											$yy,
											$mm,
											$dd,
											$value['hh'],
											$value['ii']
										)->format('H:i') !!}
										（{!! $value['booked_number'] !!} / {!! $value['accepted_number'] !!}）
									</option>
								@endforeach
							</select>
							{{--{!! Form::text('booking[mtb_time_id]', \Carbon\Carbon::create(
								$date['yy'],
								$date['mm'],
								$date['dd'],
								$time['hh'],
								$time['ii'],
								00
							)->format('H:i'), [
								'class' => 'form-control-plaintext',
								'readonly' => '',
							]) !!}
							{!! Form::hidden('booking[mtb_time_id]', $time['mtb_time_id']) !!}--}}
						@endif
					</div>
				</div>
				<div class="row mb-3">
					<label
						class="col-lg-2 col-form-label text-lg-end"
						for=""
					>
						{!! __("lang.master.vaccine.title") !!}
					</label>
					<div class="col">
						@if(isset($date['mtb_date_id']))
							{!! Form::text('', $vaccine_list[$date['mtb_vaccine_id']], [
								'class' => 'form-control-plaintext',
								'readonly' => '',
							]) !!}
						@endif
					</div>
				</div>
				<div class="row mb-3">
					<label
						class="col-lg-2 col-form-label text-lg-end"
						for=""
					>
						{!! __("lang.booking.is_web") !!}
					</label>
					<div class="col">
						{!! Form::text('', __("lang.dictionary.is_web." . ((isset($booking)) ? $booking['is_web'] : 0)), [
							'class' => 'form-control-plaintext',
							'readonly' => '',
						]) !!}
					</div>
				</div>
				<div class="row mb-3 d-none">
					<label
						class="col-lg-2 col-form-label text-lg-end"
						for=""
					>
						{!! __("lang.booking.is_staff") !!}
						<span class="badge rounded-pill text-bg-danger">
							{!! __("lang.form.required") !!}
						</span>
					</label>
					<div class="col">
						@for($i = 1; $i >= 0; $i--)
							<div class="form-check-inline me-1">
								{!! Form::radio('booking[is_staff]', $i, (isset($booking)) ? (($i == $booking['is_staff']) ? true : false) : (($i == 0) ? true : false), [
									'class' => 'btn-check',
									'id' => "is_staff{$i}",
									'autocomplete' => 'off',
								]) !!}
								<label
									class="btn btn-outline-primary mb-0 px-3"
									for="is_staff{!! $i !!}"
									style="width:100px;"
								>
									<span class="fw-bold">
										{!! __("lang.dictionary.is_yesno.{$i}") !!}
									</span>
								</label>
							</div>
						@endfor
					</div>
				</div>
				<div class="row mb-3 d-none">
					<label
						class="col-lg-2 col-form-label text-lg-end"
						for=""
					>
						{!! __("lang.booking.is_disease") !!}
						<span class="badge rounded-pill text-bg-danger">
							{!! __("lang.form.required") !!}
						</span>
					</label>
					<div class="col">
						@for($i = 1; $i >= 0; $i--)
							<div class="form-check-inline me-1">
								{!! Form::radio('booking[is_disease]', $i, (isset($booking)) ? (($i == $booking['is_disease']) ? true : false) : (($i == 0) ? true : false), [
									'class' => 'btn-check',
									'id' => "is_disease{$i}",
									'autocomplete' => 'off',
								]) !!}
								<label
									class="btn btn-outline-primary mb-0 px-3"
									for="is_disease{!! $i !!}"
									style="width:100px;"
								>
									<span class="fw-bold">
										{!! __("lang.dictionary.is_yesno.{$i}") !!}
									</span>
								</label>
							</div>
						@endfor
					</div>
				</div>
				<div class="row mb-3">
					<label
						class="col-lg-2 col-form-label text-lg-end"
						for=""
					>
						{!! __("lang.booking.date_last") !!}
						<span class="badge rounded-pill text-bg-danger">
							{!! __("lang.form.required") !!}
						</span>
					</label>
					<div class="col">
						<div class="input-group">
							{{-- {!! Form::number('date_last[yy]', (isset($booking)) ? $date_last['yy'] : date('Y'), [
								'class' => 'form-control',
								'min' => '0',
								'pattern' => '^[0-9]+$',
							]) !!} --}}
							{!! Form::selectRange('date_last[yy]', 2021, (date('Y') + 1), (isset($booking)) ? $date_last['yy'] : '', [
								'class' => 'form-select',
							]) !!}
							<span class="input-group-text">
								{!! __("lang.date.yy") !!}
							</span>
							{!! Form::selectRange('date_last[mm]', 1, 12, (isset($booking)) ? $date_last['mm'] : '', [
								'class' => 'form-select',
							]) !!}
							<span class="input-group-text">
								{!! __("lang.date.mm") !!}
							</span>
							{!! Form::selectRange('date_last[dd]', 1, 31, (isset($booking)) ? $date_last['dd'] : '', [
								'class' => 'form-select',
							]) !!}
							<span class="input-group-text">
								{!! __("lang.date.dd") !!}
							</span>
						</div>
					</div>
				</div>
				<div class="row mb-3">
					<label
						class="col-lg-2 col-form-label text-lg-end"
						for=""
					>
						{!! __("lang.booking.shots_number") !!}
						<span class="badge rounded-pill text-bg-danger">
							{!! __("lang.form.required") !!}
						</span>
					</label>
					<div class="col">
						@for($i = $numbers['from']; $i <= $numbers['to']; $i++)
							<div class="form-check-inline me-1">
								{!! Form::radio('booking[shots_number]', $i, (isset($booking)) ? (($i == $booking['shots_number']) ? true : false) : (($i == 3) ? true : false), [
									'class' => 'btn-check',
									'id' => "last{$i}",
									'autocomplete' => 'off',
								]) !!}
								<label
									class="btn btn-outline-primary mb-0 px-3"
									for="last{!! $i !!}"
									style="width:100px;"
								>
									<span class="fw-bold">
										{!! $i !!}回目
									</span>
								</label>
							</div>
						@endfor
					</div>
				</div>
				<div class="row mb-3">
					<label
						class="col-lg-2 col-form-label text-lg-end"
						for=""
					>
						{!! __("lang.booking.voucher_number") !!}
						<span class="badge rounded-pill text-bg-danger">
							{!! __("lang.form.required") !!}
						</span>
					</label>
					<div class="col">
						<div class="input-group">
							{!! Form::text('booking[voucher_number]', (isset($booking)) ? $booking['voucher_number'] : '', [
								'class' => 'form-control',
								'id' => 'voucher_number',
								'minlength' => '10',
								'maxlength' => '10',
							]) !!}
							<div class="input-group-text">
							   <span id="count">{!! (isset($booking)) ? 10 : 0 !!}</span>&nbsp;/&nbsp;10
							</div>
						</div>
					</div>
				</div>
				<div class="row mb-3">
					<label
						class="col-lg-2 col-form-label text-lg-end"
						for=""
					>
						{!! __("lang.booking.patient_kana") !!}
						<span class="badge rounded-pill text-bg-danger">
							{!! __("lang.form.required") !!}
						</span>
					</label>
					<div class="col">
						<div class="input-group">
							{!! Form::text('booking[patient_skana]', (isset($booking)) ? $booking['patient_skana'] : '', [
								'class' => 'form-control',
							]) !!}
							{!! Form::text('booking[patient_gkana]', (isset($booking)) ? $booking['patient_gkana'] : '', [
								'class' => 'form-control',
							]) !!}
						</div>
					</div>
				</div>
				<div class="row mb-3">
					<label
						class="col-lg-2 col-form-label text-lg-end"
						for=""
					>
						{!! __("lang.booking.birthday") !!}
						<span class="badge rounded-pill text-bg-danger">
							{!! __("lang.form.required") !!}
						</span>
					</label>
					<div class="col">
						<div class="input-group">
							{{-- {!! Form::number('birthday[yy]', (isset($booking)) ? $birthday['yy'] : '1970', [
								'class' => 'form-control',
								'min' => '0',
								'pattern' => '^[0-9]+$',
							]) !!} --}}
							{{-- {!! Form::selectRange('birthday[yy]', 1900, date('Y'), (isset($booking)) ? $birthday['yy'] : 1970, [
								'class' => 'form-select',
							]) !!} --}}
							{!! Form::select('birthday[yy]', $wareki_list, (isset($booking)) ? $birthday['yy'] : 1970, [
								'class' => 'form-select',
							]) !!}
							<span class="input-group-text">
								{!! __("lang.date.yy") !!}
							</span>
							{!! Form::selectRange('birthday[mm]', 1, 12, (isset($booking)) ? $birthday['mm'] : '', [
								'class' => 'form-select',
							]) !!}
							<span class="input-group-text">
								{!! __("lang.date.mm") !!}
							</span>
							{!! Form::selectRange('birthday[dd]', 1, 31, (isset($booking)) ? $birthday['dd'] : '', [
								'class' => 'form-select',
							]) !!}
							<span class="input-group-text">
								{!! __("lang.date.dd") !!}
							</span>
						</div>
					</div>
				</div>
				<div class="row mb-3">
					<label
						class="col-lg-2 col-form-label text-lg-end"
						for=""
					>
						{!! __("lang.booking.mobile") !!}
					</label>
					<div class="col">
						{!! Form::text('booking[mobile]', (isset($booking)) ? $booking['mobile'] : '', [
							'class' => 'form-control',
						]) !!}
					</div>
				</div>
				<div class="row mb-3">
					<label
						class="col-lg-2 col-form-label text-lg-end"
						for=""
					>
						{!! __("lang.booking.tel") !!}
					</label>
					<div class="col">
						{!! Form::text('booking[tel]', (isset($booking)) ? $booking['tel'] : '', [
							'class' => 'form-control',
						]) !!}
					</div>
				</div>
                <div class="row mb-3">
					<label
						class="col-lg-2 col-form-label text-lg-end"
						for=""
					>
						未予約
					</label>
					<div class="col">
						@for($i = 1; $i >= 0; $i--)
							<div class="form-check-inline me-1">
								{!! Form::radio('booking[is_walkin]', $i, (isset($booking)) ? (($i == $booking['is_walkin']) ? true : false) : (($i == 0) ? true : false), [
									'class' => 'btn-check',
									'id' => "is_walkin{$i}",
									'autocomplete' => 'off',
								]) !!}
								<label
									class="btn btn-outline-primary mb-0 px-3"
									for="is_walkin{!! $i !!}"
									style="width:100px;"
								>
									<span class="fw-bold">
										{!! __("lang.dictionary.is_yesno.{$i}") !!}
									</span>
								</label>
							</div>
						@endfor
					</div>
				</div>

			</div>
		</div>

	</main>
	<!-- /.main -->

</div>
<!-- /.row -->

<!-- scroll-to-top -->
<div
	class="scroll-to-top"
	style="z-index:999"
>
	@if(isset($booking))
		<button
			class="btn btn-success"
			id="submit"
			type="submit"
			name="action"
			value="store"
			style="width:180px;"
		>
			<span class="fw-bold">
				更新
			</span>
		</button>
	@else
		@if(isset($date['mtb_date_id']))
			{{--@if($count['accepted_numbers'] > $count['booked_numbers'] || !is_null($booking_code))--}}
			@if($count['accepted_numbers'] > $count['booked_numbers'])
				<button
					class="btn btn-primary"
					id="submit"
					type="submit"
					name="action"
					value="store"
					style="width:180px;"
				>
					<span class="fw-bold">
						{!! __("lang.button.submit") !!}
					</span>
				</button>
			@endif
		@endif
	@endif
	<a
		class="btn btn-light border border-secondary"
		href="{!! route('admin.covid.booking.index', [
			$yy,
			$mm,
			$dd,
		]) !!}"
		style="width:180px;"
	>
		<span class="fw-bold">
			{!! __("lang.button.back") !!}
		</span>
	</a>
</div>
<!-- /.scroll-to-top -->

{!! Form::close() !!}
@endsection

{{-- css --}}
@section('css')
<style>

</style>
@stop

{{-- js --}}
@section('js')
<script>
$(function() {

	$('#voucher_number').bind('keyup change', function() {
		$('#count').text($(this).val().length);
	});

	$('select[name="vaccine_id').on('change', function() {
		const id = $(this).val();
		const url = [
			'{!! route('admin.covid.booking.update', [
				$yy,
				$mm,
				0,
			]) !!}',
			id,
			'{!! $booking_code !!}'
		].join('/');
		//alert(url);

		window.location.href = url;
	});

	$('form').submit(function() {

		const mobile = $('input[name="booking[mobile]"]').val();
		const tel = $('input[name="booking[tel]"]').val();

		if(mobile == '' && tel == '') {
			alert('携帯電話番号、または自宅電話番号を入力してください');
			return false;
		}
	});
});
</script>
@stop
