@extends('backend.layouts.main')

{{-- content --}}
@section('content')
@include('backend.layouts.components.tab')

<!-- section -->
<section class="mb-3">
	{!! Form::open($form) !!}
	{!! Form::hidden('yy', $yy) !!}
	{!! Form::hidden('mm', $mm) !!}
	{!! Form::hidden('dd', $dd) !!}
	{!! Form::hidden('action', 'checkedin') !!}

	<!-- toolbar -->
	<div class="d-flex justify-content-center align-items-center mb-3">
		<div>
			<a
				class=""
				href="{!! route('admin.covid.frontdesk.index', [
					$date['prev']['yy'],
					$date['prev']['mm'],
					$date['prev']['dd'],
				]) !!}"
			>
				<i class="fa-solid fa-circle-chevron-left fa-fw fa-2x"></i>
			</a>
		</div>
		<div class="mx-3">
			<span class="fs-4 fw-bold">
				{!! \Carbon\Carbon::create(
					$yy,
					$mm,
					$dd
				)->isoFormat('YYYY年M月D日（ddd）') !!}
			</span>
		</div>
		<div>
			<a
				class=""
				href="{!! route('admin.covid.frontdesk.index', [
					$date['next']['yy'],
					$date['next']['mm'],
					$date['next']['dd'],
				]) !!}"
			>
				<i class="fa-solid fa-circle-chevron-right fa-fw fa-2x"></i>
			</a>
		</div>
	</div>
	<!-- /.toolbar -->

	<div class="row justify-content-center">
		<div class="col col-lg-8">

			<div class="alert alert-primary text-center mb-3">
				<h4 class="">
					バーコードリーダーで予約受付番号を読み取ってください
				</h4>
				<hr>
				<p class="fs-4 fw-bold mb-0">
					{{-- <span class="ms-1">
						<i class="fa-solid fa-triangle-exclamation fa-fw fa-lg"></i>
					</span> --}}
					【注意】キーボードは必ず半角入力にしてください
				</p>
			</div>

			<div class="card">
				<div class="card-body p-4">

					<div class="mb-4">
						{!! Form::text('booking[qr_number]', '', [
							'class' => 'form-control fs-2 fw-bold',
							'autofocus' => '',
						]) !!}
					</div>
					<div class="d-grid gap-2">
						<button
							class="btn btn-primary btn-lg"
							type="submit"
						>
							<span class="fw-bold">
								読み取る
							</span>
						</button>
					</div>

				</div>
			</div>

		</div>
	</div>

	{!! Form::close() !!}
</section>
<!-- /.section -->
@endsection

{{-- css --}}
@section('css')
<style>

</style>
@stop

{{-- js --}}
@section('js')
<script>
$(function() {

	$('input[name="booking[qr_number]"]').keyup(function() {
		$('form').submit();
	});
});
</script>
@stop
