@extends('backend.layouts.main')

{{-- content --}}
@section('content')

@include('backend.layouts.components.covid.frontdesk.nav')

<div class="row g-4">

	<!-- aside -->
	<aside class="col-lg-3">
		{!! Form::open($form) !!}
		{!! Form::hidden('yy', $yy) !!}
		{!! Form::hidden('mm', $mm) !!}
		{!! Form::hidden('dd', $dd) !!}

		<div class="card">
			<div class="card-body">

				<div class="mb-3">
					<label
						class="form-label"
						for=""
					>
						<span class="fw-bold">
							{!! __("lang.booking.voucher_number") !!}
						</span>
					</label>
					{!! Form::text('booking[voucher_number]', (isset($booking)) ? $booking['voucher_number'] : '', [
						'class' => 'form-control alphanumeric',
					]) !!}
				</div>
				<div class="mb-3">
					<label
						class="form-label"
						for=""
					>
						<span class="fw-bold">
							携帯電話
							{{--{!! __("lang.booking.mobile") !!}--}}
						</span>
					</label>
					{!! Form::tel('booking[mobile]', (isset($booking)) ? $booking['mobile'] : '', [
						'class' => 'form-control alphanumeric',
						'autofocus' => '',
					]) !!}
				</div>
				<div class="mb-3">
					<label
						class="form-label"
						for=""
					>
						<span class="fw-bold">
							自宅電話
							{{--{!! __("lang.booking.tel") !!}--}}
						</span>
					</label>
					{!! Form::tel('booking[tel]', (isset($booking)) ? $booking['tel'] : '', [
						'class' => 'form-control alphanumeric',
						'autofocus' => '',
					]) !!}
				</div>
				{{--<div class="mb-3">
					<label
						class="form-label"
						for=""
					>
						<span class="fw-bold">
							{!! __("lang.booking.time_booking") !!}
						</span>
					</label>
					<div class="input-group">
						{!! Form::select('booking[time]', ['' => '指定なし'] + $time_list, (isset($birthday)) ? $birthday['yy'] : '', [
							'class' => 'form-select',
							'style' => 'width:30%',
						]) !!}
					</div>
				</div>--}}
				<div class="mb-3">
					<label
						class="form-label"
						for=""
					>
						<span class="fw-bold">
							氏名（ひらかな）
							{{--{!! __("lang.booking.patient_kana") !!}--}}
						</span>
					</label>
					<div class="input-group">
						{!! Form::text('booking[patient_skana]', (isset($booking)) ? $booking['patient_skana'] : '', [
							'class' => 'form-control',
							'placeholder' => 'そうぞう',
						]) !!}
						{!! Form::text('booking[patient_gkana]', (isset($booking)) ? $booking['patient_gkana'] : '', [
							'class' => 'form-control',
							'placeholder' => 'いちろう',
						]) !!}
					</div>
				</div>

				<div class="d-grid gap-2">
					<button
						class="btn btn-primary"
						type="submit"
					>
						<span class="fw-bold">
							{!! __("lang.button.search") !!}
						</span>
					</button>
					<a
						class="btn btn-light border border-secondary"
						href="{!! route('admin.covid.frontdesk.list.index', [
							$yy,
							$mm,
							$dd,
						]) !!}"
					>
						<span class="fw-bold">
							{!! __("lang.button.reset") !!}
						</span>
					</a>
				</div>

			</div>
		</div>

		{!! Form::close() !!}
	</aside>
	<!-- /.aside -->

	<!-- main -->
	<main class="col col-lg-9">

		@if(isset($booking_list))

			<!-- toolbar -->
			<div class="d-flex justify-content-between align-items-center mb-3">
				<div>
					{!! __("lang.form.count") !!}：<span class="fw-bold">
						{!! $booking_list_count !!}
					</span>
				</div>
				<div>

				</div>
			</div>
			<!-- /.toolbar -->

			<!-- table -->
			<div class="table-responsive">
				<table class="table">
					<colgroup>
						<col>
						<col>
						<col>
						<col>
						<col>
						<col>
						<col>
						<col width="100%">
						<col>
						<col>
						<col>
					</colgroup>
					<thead>
						<tr>
							<th nowrap>
								&nbsp;
							</th>
							<th nowrap>
								#
							</th>
							<th nowrap>
								{!! __("lang.booking.date_booking") !!}
							</th>
							<th nowrap>
								{!! __("lang.booking.time_booking") !!}
							</th>
							<th nowrap>
								{!! __("lang.booking.time_checkedin") !!}
							</th>
							<th nowrap>
								{!! __("lang.master.vaccine.title") !!}
							</th>
							<th nowrap>
								{!! __("lang.booking.voucher_number") !!}
							</th>
							<th nowrap>
								{!! __("lang.booking.patient_kana") !!}
							</th>
							<th nowrap>
								{!! __("lang.booking.birthday") !!}（{!! __("lang.booking.age") !!}）
							</th>
							<th nowrap>
								携帯電話
							</th>
							<th nowrap>
								自宅電話
							</th>
						</tr>
					</thead>
					<tbody>
						@if($booking_list_count > 0)
							@foreach($booking_list as $key => $value)
								<tr class="{!! ($value['is_checkedin']) ? 'table-primary' : '' !!}">
									<td nowrap>
										<div class="form-check form-switch mb-0 mx-1">
											{!! Form::checkbox('', $value['booking_code'], $value['is_checkedin'], [
												'class' => 'form-check-input mb-0',
												'style' => 'transform: scale(1.3)',
											]) !!}
										</div>
									</td>
									<th scope="row">
										{!! $key + 1 !!}
									</th>
									<td nowrap>
										{!! \Carbon\Carbon::create(
											$value['yy'],
											$value['mm'],
											$value['dd'],
										)->isoFormat('YYYY年MM月DD日（ddd）') !!}
									</td>
									<td nowrap>
										<div class="text-center">
											{!! \Carbon\Carbon::create(
												$value['yy'],
												$value['mm'],
												$value['dd'],
												$value['hh'],
												$value['ii'],
											)->format('H:i') !!}
										</div>
									</td>
									<td>
										<div class="text-center">
											@if($value['is_checkedin'])
												<span class="fw-bold text-primary">
													{!! \Carbon\Carbon::parse($value['timestamp_checkedin'])->format('H:i') !!}
												</span>
											@endif
										</div>
									</td>
									<td nowrap>
										{!! $value['vaccine_label'] !!}
									</td>
									<td nowrap>
										{!! $value['voucher_number'] !!}
									</td>
									<td nowrap>
										{!! implode(' ', [
											$value['patient_skana'],
											$value['patient_gkana'],
										]) !!}
									</td>
									<td nowrap>
										{!! \Carbon\Carbon::parse($value['birthday'])->isoFormat('YYYY年MM月DD日') !!}（{!! App\Helper::getAge($value['birthday']) !!}）
									</td>
									<td nowrap>
										@if(!is_null($value['mobile']))
											{!! $value['mobile'] !!}
										@endif
									</td>
									<td nowrap>
										@if(!is_null($value['tel']))
											{!! $value['tel'] !!}
										@endif
									</td>
								</tr>
							@endforeach
						@else
							<tr>
								<td nowrap>
									<div class="form-check form-switch mb-0 mx-1">
										{!! Form::checkbox('', '', '', [
											'class' => 'form-check-input mb-0',
											'style' => 'transform: scale(1.3)',
											'disabled' => '',
										]) !!}
									</div>
								</td>
								<td colspan="11">
									{!! __("lang.error.empty") !!}
								</td>
							</tr>
						@endif
					</tbody>
				</table>
			</div>
			<!-- /.table -->
		@else

		@endif

	</main>
	<!-- /.main -->

</div>
@endsection

{{-- css --}}
@section('css')
<style>

</style>
@stop

{{-- js --}}
@section('js')
<script>
$(function() {

	$('.form-check-input').change(function() {

		const id = $(this).val();
		//alert(id);return false;

		// set url
		const url = [
			'{!! route('ajax.ischeckedin.update') !!}',
			id,
			(Boolean(this.checked)) ? 1 : 0
		].join('/');
		//console.log(url);return false;

		$.ajax({
			type: 'GET',
			scriptCharset: 'utf-8',
			url: url,
			dataType: 'json',
			success: function(data) {
				location.reload();
			},
			error:function(ts) {
				alert('エラーが発生しました。');
			}
		});
	});
});
</script>
@stop
