@extends('backend.layouts.main')

{{-- content --}}
@section('content')

@include('backend.layouts.components.covid.frontdesk.nav')

<!-- section -->
<section class="mb-3">

	<!-- div -->
	<div class="row justify-content-center">
		<div class="col col-lg-8">

			@if(isset($booking))
				<div
					class="alert alert-primary mb-4 p-5"
					role="alert"
				>
					<h3 class="alert-heading text-center">
						下記の予約者を受付処理しました
					</h3>
					<hr class="my-4">
					<dl class="row fs-4">
						<dt class="col col-lg-4 text-end mb-0">
							予約受付番号：
						</dt>
						<dd class="col mb-0">
							<span class="fw-bold" style="letter-spacing:.4em;">
								{!! $booking['voucher_number'] !!}
							</span>
						</dd>
					</dl>
					<dl class="row fs-4">
						<dt class="col col-lg-4 text-end mb-0">
							氏名：
						</dt>
						<dd class="col mb-0">
							{!! implode('', [
								$booking['patient_skana'],
								$booking['patient_gkana'],
							]) !!}
							さん
						</dd>
					</dl>
					<dl class="row fs-4 mb-0">
						<dt class="col col-lg-4 text-end mb-0">
							生年月日：
						</dt>
						<dd class="col mb-0">
							{!! \Carbon\Carbon::parse($booking['birthday'])->format(__("lang.date.yymmdd")) !!}
						</dd>
					</dl>
				</div>
			@else

				@if(is_null($booking_code))
					<div
						class="alert alert-danger mb-4 p-5"
						role="alert"
					>
						<h3 class="alert-heading text-center lh-base">
							この予約者は存在しません<br>
                            再読み取りしてください
						</h3>
					</div>
				@else
					<div
						class="alert alert-warning mb-4 p-5"
						role="alert"
					>
						<h3 class="alert-heading text-center">
							この予約者はすでに受付済みです
						</h3>
					</div>
				@endif
			@endif

			<p class="fs-4 fw-bold text-danger text-center">
				2秒後にバーコード受付画面に戻ります
			</p>

		</div>
	</div>
	<!-- /.div -->

</section>
<!-- /.section -->
@endsection

{{-- css --}}
@section('css')
<style>

</style>
@stop

{{-- js --}}
@section('js')
<script>
$(function() {

    //
    setTimeout(function(){
		window.location.href = '{!! route('admin.covid.frontdesk.qr.index', [
			$yy,
			$mm,
			$dd,
		]) !!}';
	}, 2 * 1000);
});


</script>
@stop
