@extends('backend.layouts.main')

{{-- content --}}
@section('content')

@include('backend.layouts.components.covid.frontdesk.nav')

<!-- section -->
<section class="mb-5">

	<!-- toolbar -->
	<div class="d-flex justify-content-center align-items-center">
		<div>
			<a
				class=""
				href="{!! route('admin.covid.frontdesk.status.index', [
					$link_list['last_day']['yy'],
					$link_list['last_day']['mm'],
					$link_list['last_day']['dd'],
				]) !!}"
			>
				<i class="fa-solid fa-circle-chevron-left fa-fw fa-2x"></i>
			</a>
		</div>
		<div class="mx-3">
			<span class="fs-4 fw-bold">
				{!! \Carbon\Carbon::create(
					$yy,
					$mm,
					$dd
				)->isoFormat('YYYY年M月D日（ddd）') !!}
			</span>
		</div>
		<div>
			<a
				class=""
				href="{!! route('admin.covid.frontdesk.status.index', [
					$link_list['next_day']['yy'],
					$link_list['next_day']['mm'],
					$link_list['next_day']['dd'],
				]) !!}"
			>
				<i class="fa-solid fa-circle-chevron-right fa-fw fa-2x"></i>
			</a>
		</div>
	</div>
	<!-- /.toolbar -->

</section>
<!-- /.section -->

@if($booking_count > 0)
	<!-- section -->
	<section class="mb-5">

		<div class="row g-4">

			<div class="col col-lg-6">
				<div class="d-flex justify-content-center align-items-center mb-2">
					<h6>
						合計
					</h6>
				</div>
				<table class="table mb-0">
					<thead class="table-group-divider">
						<tr class="text-center">
							<th nowrap class="bg-secondary-subtle">
								受付総数
							</th>
							<th nowrap>
								事前予約
							</th>
							<th nowrap>
								受付済
							</th>
							<th nowrap>
								未受付
							</th>
							<th nowrap>
								手受付
							</th>
						</tr>
					</thead>
					<tbody class="table-group-divider">
						<tr class="text-center">
							<td class="bg-secondary-subtle">
								<span class="fw-bold fs-5">
									{!! $count_list['total']['confirmed'] + $count_list['total']['walkin'] !!}
								</span>
								<span class="small text-secondary">
									人
								</span>
							</td>
							<td>
								<span class="fw-bold fs-5 text-primary">
									{!! $count_list['total']['booked'] !!}
								</span>
								<span class="small text-secondary">
									人
								</span>
							</td>
							<td>
								<span class="fw-bold fs-5 text-success">
									{!! $count_list['total']['confirmed'] !!}
								</span>
								<span class="small text-secondary">
									人
								</span>
							</td>
							<td>
								<span class="fw-bold fs-5 text-danger">
									{!! $count_list['total']['unconfirmed'] !!}
								</span>
								<span class="small text-secondary">
									人
								</span>
							</td>
							<td>
								<span class="fw-bold fs-5 text-warning">
									{!! $count_list['total']['walkin'] !!}
								</span>
								<span class="small text-secondary">
									人
								</span>
							</td>
						</tr>
					</tbody>
				</table>

			</div>

			<div class="col">
				<div class="d-flex justify-content-center align-items-center mb-2">
					<h6>
						午前
					</h6>
				</div>
				<table class="table mb-0">
					<thead class="table-group-divider">
						<tr class="text-center">
							<th nowrap>
								受付総数
							</th>
							<th nowrap>
								受付済
							</th>
							<th nowrap>
								未受付
							</th>
							<th nowrap>
								手受付
							</th>
						</tr>
					</thead>
					<tbody class="table-group-divider">
						<tr class="text-center">
							<td>
								<span class="fw-bold fs-5 text-primary">
									{!! $count_list['am']['booked'] !!}
								</span>
								<span class="small text-secondary">
									人
								</span>
							</td>
							<td>
								<span class="fw-bold fs-5 text-success">
									{!! $count_list['am']['confirmed'] !!}
								</span>
								<span class="small text-secondary">
									人
								</span>
							</td>
							<td>
								<span class="fw-bold fs-5 text-danger">
									{!! $count_list['am']['unconfirmed'] !!}
								</span>
								<span class="small text-secondary">
									人
								</span>
							</td>
							<td>
								<span class="fw-bold fs-5 text-warning">
									{!! $count_list['am']['walkin'] !!}
								</span>
								<span class="small text-secondary">
									人
								</span>
							</td>
						</tr>
					</tbody>
				</table>

			</div>

			<div class="col">
				<div class="d-flex justify-content-center align-items-center mb-2">
					<h6>
						午後
					</h6>
				</div>
				<table class="table mb-0">
					<thead class="table-group-divider">
						<tr class="text-center">
							<th nowrap>
								受付総数
							</th>
							<th nowrap>
								受付済
							</th>
							<th nowrap>
								未受付
							</th>
							<th nowrap>
								手受付
							</th>
						</tr>
					</thead>
					<tbody class="table-group-divider">
						<tr class="text-center">
							<td>
								<span class="fw-bold fs-5 text-primary">
									{!! $count_list['pm']['booked'] !!}
								</span>
								<span class="small text-secondary">
									人
								</span>
							</td>
							<td>
								<span class="fw-bold fs-5 text-success">
									{!! $count_list['pm']['confirmed'] !!}
								</span>
								<span class="small text-secondary">
									人
								</span>
							</td>
							<td>
								<span class="fw-bold fs-5 text-danger">
									{!! $count_list['pm']['unconfirmed'] !!}
								</span>
								<span class="small text-secondary">
									人
								</span>
							</td>
							<td>
								<span class="fw-bold fs-5 text-warning">
									{!! $count_list['pm']['walkin'] !!}
								</span>
								<span class="small text-secondary">
									人
								</span>
							</td>
						</tr>
					</tbody>
				</table>

			</div>

		</div>

	</section>
	<!-- /.section -->

	<!-- section -->
	<section class="mb-5">

		<div class="d-flex justify-content-center align-items-center mb-2">
			<h6>
				時間別状況
			</h6>
		</div>
		<div class="table-responsive">
			<table class="table mb-0">
				<colgroup>
					<col width="{!! 100 - (round(100 / count($time_list), 1)) * count($time_list) !!}%">
					@foreach($time_list as $key => $value)
						<col width="{!! round(100 / count($time_list), 1) !!}%">
					@endforeach
				</colgroup>
				<thead class="table-group-divider">
					<tr class="text-end">
						<th nowrap>
							<div class="text-end">
								予約時間
							</div>
						</th>
						@foreach($time_list as $key => $value)
							<th nowrap>
								<div class="text-center">
									{!! \Carbon\Carbon::create(
										$yy,
										$mm,
										$dd,
										$value[0],
										$value[1]
									)->format('H:i') !!}
								</div>
							</th>
						@endforeach
					</tr>
				</thead>
				<tbody class="table-group-divider">
					<tr class="text-end">
						<th nowrap>
							<div class="text-end">
								事前予約
							</div>
						</th>
						@foreach($time_list as $key => $value)
							<td nowrap>
								<div class="text-center">
									<span class="fw-bold fs-6 text-primary">
										{!! $count_list['booking'][$key] !!}
									</span>
								</div>
							</td>
						@endforeach
					</tr>
					<tr class="text-end">
						<th nowrap>
							<div class="text-end">
								受付済
							</div>
						</th>
						@foreach($time_list as $key => $value)
							<td nowrap>
								<div class="text-center">
									<span class="fw-bold fs-6 text-success">
										{!! $count_list['confirmed'][$key] !!}
									</span>
								</div>
							</td>
						@endforeach
					</tr>
					<tr class="text-end">
						<th nowrap>
							<div class="text-end">
								未受付
							</div>
						</th>
						@foreach($time_list as $key => $value)
							<td nowrap>
								<div class="text-center">
									<span class="fw-bold fs-6 text-danger">
										{!! $count_list['unconfirmed'][$key] !!}
									</span>
								</div>
							</td>
						@endforeach
					</tr>
					<tr>
						<th nowrap>
							<div class="text-end">
								手受付
							</div>
						</th>
						@foreach($time_list as $key => $value)
							<td nowrap>
								<div class="text-center">
									<span class="fw-bold fs-6 text-warning">
										{!! $count_list['walkin'][$key] !!}
									</span>
								</div>
							</td>
						@endforeach
					</tr>
				</tbody>
			</table>
		</div>

	</section>
	<!-- /.section -->

	<!-- section -->
	<section class="mb-5">

		<table class="table table-borderless mb-0">
			<colgroup>
				<col width="{!! 100 - (round(100 / count($time_list), 1)) * count($time_list) !!}%">
				<col width="{!! (round(100 / count($time_list), 1)) * count($time_list) !!}%">
			</colgroup>
			<tbody class="">
				<tr>
					<td nowrap>
						&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
					</td>
					<td>
						<canvas id="chart" style="display: block; width: 100%; height: 380px;"></canvas>
					</td>
				</tr>
			</tbody>
		</table>

	</section>
	<!-- /.section -->

@else
	<!-- section -->
	<section class="mb-5">

		<div class="alert alert-secondary text-center">
			接種予定はありません
		</div>

	</section>
	<!-- /.section -->
@endif

@endsection

{{-- css --}}
@section('css')
<style>

</style>
@stop

{{-- js --}}
@section('js')
<script
	src="https://cdnjs.cloudflare.com/ajax/libs/Chart.js/3.2.0/chart.min.js"
	integrity="sha512-VMsZqo0ar06BMtg0tPsdgRADvl0kDHpTbugCBBrL55KmucH6hP9zWdLIWY//OTfMnzz6xWQRxQqsUFefwHuHyg=="
	crossorigin="anonymous"
></script>
<script
	src="https://cdn.jsdelivr.net/npm/chartjs-adapter-date-fns@next/dist/chartjs-adapter-date-fns.bundle.min.js"
></script>

<script>
$(function() {

	@if($booking_count > 0)
		const ctx = document.getElementById('chart');
		const myChart = new Chart(ctx, {
			type: 'bar',
			data: {
				labels: ['{!! implode("','", $timeline_list) !!}'],
				datasets: [
					{
						label: '受付済',
						data: [{!! implode(',', $count_list['confirmed']) !!}],
						backgroundColor: '#a3cfbb',
						stack: 'stack-1',
					},
					{
						label: '未受付',
						data: [{!! implode(',', $count_list['unconfirmed']) !!}],
						backgroundColor: '#f1aeb5',
						stack: 'stack-1',
					},
					{
						label: '手受付',
						data: [{!! implode(',', $count_list['walkin']) !!}],
						backgroundColor: '#fecba1',
						stack: 'stack-1',
					}
				],
			},
            options: {

            }
		});
	@endif
});
</script>
@stop
