@extends('backend.layouts.main')

{{-- content --}}
@section('content')
{!! Form::open($form) !!}
{!! Form::hidden('date[mtb_date_id]', $date['mtb_date_id']) !!}
{!! Form::hidden('date[yy]', $yy) !!}
{!! Form::hidden('date[mm]', $mm) !!}
{!! Form::hidden('date[dd]', $dd) !!}

<!-- section -->
<section class="">

	<div class="row">

		<aside class="col col-lg-2">

			<div class="d-flex justify-content-between align-items-center mb-3">
				<h5 class="text-center">
					{!! \Carbon\Carbon::create(
						$yy,
						$mm,
						1,
					)->format(__("lang.date.yymm")) !!}
				</h5>
			</div>

			<div class="list-group">
				@for($i = 1; $i <= $date['day']; $i++)
					<a
						class="list-group-item list-group-item-action d-flex justify-content-between align-items-center {!! ($i == $dd) ? 'active' : '' !!}"
						href="{!! route('admin.covid.master.date.update', [
							$yy,
							$mm,
							$i,
						]) !!}"
					>
						<div>
							<span class="fw-bold">
								{!! implode('', [
									$i,
									__("lang.date.dd"),
								]) !!}
							</span>（{!! \Carbon\Carbon::create(
								$yy,
								$mm,
								$i,
							)->isoFormat('ddd') !!}）
						</div>
						<div>
							@if(isset($date_list[$i]))
								<span class="badge rounded-pill text-bg-primary me-1">
									設定
								</span>
							@endif
							<span class="">
								<i class="fa-solid fa-angle-right fa-fw"></i>
							</span>
						</div>
					</a>
				@endfor
			</div>

		</aside>

		<main class="col">

			<div class="d-flex justify-content-between align-items-center mb-3">
				<h5 class="text-center">
					{!! \Carbon\Carbon::create(
						$yy,
						$mm,
						$dd,
					)->format(__("lang.date.yymmdd")) !!}（{!! \Carbon\Carbon::create(
						$yy,
						$mm,
						$dd,
					)->isoFormat('ddd') !!}）
					上限枠設定
				</h5>
			</div>

			<div class="card mb-3">
				<div class="card-body pb-0">

					<div class="input-group mb-0">
						<span
							class="input-group-text"
							style="width:100px;"
						>
							<small class="fw-bold">
								{!! __("lang.master.vaccine.title") !!}
							</small>
						</span>
						{!! Form::select('mtb_vaccine_id', $vaccine_list, (isset($date_list[$dd])) ? $date_list[$dd]['mtb_vaccine_id'] : '', [
							'class' => 'form-select',
						]) !!}
					</div>
					<hr>

					@foreach($accepted_number_list as $key => $value)
						<div class="input-group mb-3">
							<span
								class="input-group-text"
								style="width:100px;"
							>
								<span class="fw-bold">
									{!! \Carbon\Carbon::create(
										$yy,
										$mm,
										$dd,
										$value['hh'],
										$value['ii'],
									)->format(__("lang.date.hhii")) !!}
								</span>
							</span>
							@if(is_null($date['mtb_date_id']))
								{!! Form::number("time[{$value['hh']}][{$value['ii']}]", (isset($time_list[$value['hh']][$value['ii']])) ? $time_list[$value['hh']][$value['ii']]['accepted_number'] : 0, [
									'class' => 'form-control',
									'id' => "time{$key}",
								]) !!}
							@else
								{!! Form::number("time[{$value['hh']}][{$value['ii']}]", (isset($time_list[$value['hh']][$value['ii']])) ? $time_list[$value['hh']][$value['ii']]['accepted_number'] : 0, [
									'class' => 'form-control',
									'id' => "time{$key}",
								]) !!}
							@endif
							<span class="input-group-text">
								人
							</span>
							<button
								class="btn btn-outline-secondary"
								type="button"
								onclick="resetNumber({!! $key !!})"
							>
								<small>
									{!! __("lang.button.reset") !!}
								</small>
							</button>
						</div>
					@endforeach
				</div>
			</div>

		</main>

	</div>

</section>
<!-- /.section -->

<!-- scroll-to-top -->
<div
	class="scroll-to-top"
	style="z-index: 9999;"
>
	<a
		class="btn btn-light border border-secondary px-5"
		href="{!! route('admin.covid.master.date.index', [
			$yy,
			$mm,
			$dd,
		]) !!}"
	>
		{!! __("lang.button.back") !!}
	</a>
	<button
		class="btn btn-primary px-5"
		type="submit"
		name="action"
		value="store"
	>
		<span class="fw-bold">
			{!! __("lang.button.submit") !!}
		</span>
	</button>
</div>
<!-- /.scroll-to-top -->

{!! Form::close() !!}
@endsection

{{-- css --}}
@section('css')
<style>

</style>
@stop

{{-- js --}}
@section('js')
<script>
$(function() {
	//
});

let resetNumber = (id) => {

	$('#time' + id).val(0);
};
</script>
@stop
