@extends('backend.layouts.main')

{{-- content --}}
@section('content')
<div class="row g-4">

	<!-- aside -->
	<aside class="col-lg-3">
		{!! Form::open($form) !!}
		{!! Form::hidden('table', $table) !!}
		{!! Form::hidden("master[mtb_{$table}_id]", $id) !!}

		{{-- alert --}}
		@if($errors->any())
			<div class="alert alert-danger mb-3">
				<ul class="mb-0 ps-3">
					@foreach ($errors->all() as $error)
						<li>
							{!! implode('', [
								$error,
								__("lang.validation.required")
							]) !!}
						</li>
					@endforeach
				</ul>
			</div>
		@endif
		{{-- /.alert --}}

		<div class="card mb-3">
			<div class="card-body">

				<div class="mb-3">
					<label
						class=""
						for=""
					>
						<span class="badge rounded-pill text-bg-danger me-1">
							{!! __("lang.form.required") !!}
						</span>
						{!! __("lang.master.vaccine.title") !!}
					</label>
					{!! Form::text("master[{$table}_label]", (isset($master)) ? $master["{$table}_label"] : '', [
						'class' => 'form-control',
					]) !!}
				</div>
				<div class="mb-3">
					<label
						class=""
						for=""
					>
						<span class="badge rounded-pill text-bg-danger me-1">
							{!! __("lang.form.required") !!}
						</span>
						{!! __("lang.form.seq") !!}
					</label>
					{!! Form::number("master[seq]", (isset($master)) ? $master['seq'] : $seq, [
						'class' => 'form-control',
					]) !!}
				</div>
				<div class="mb-3">
					<label
						class=""
						for=""
					>
						{!! __("lang.form.remark") !!}
					</label>
					{!! Form::textarea("master[remark]", (isset($master)) ? $master['remark'] : '', [
						'class' => 'form-control',
						'rows' => '5',
					]) !!}
				</div>

				<div class="d-grid gap-2">
					<button
						class="btn btn-primary"
						type="submit"
						name="action"
						value="store"
					>
						{!! __("lang.button.submit") !!}
					</button>
					<a
						class="btn btn-light border border-secondary"
						href="{!! route('admin.covid.master.index', [
							$table
						]) !!}"
					>
						{!! __("lang.button.cancel") !!}
					</a>
				</div>

			</div>
		</div>

		{!! Form::close() !!}
	</aside>
	<!-- /.aside -->

	<!-- main -->
	<main class="col">

		<!-- toolbar -->
		<div class="d-flex justify-content-between align-items-center mb-3">
			<div class="">
				{!! __("lang.form.count") !!}：
				<span class="fw-bold">
					{!! number_format($master_list_count) !!}
				</span>
			</div>
			<div
				class="btn-group btn-group-sm"
				role="group"
			>
				<a
					class="btn btn-outline-secondary"
					href="{!! route('admin.home.index') !!}"
				>
					{!! __("lang.button.home") !!}
				</a>
				<a
					class="btn btn-outline-secondary"
					href="{!! route('admin.covid.master.index', [
						$table,
					]) !!}"
				>
					{!! __("lang.button.create") !!}
				</a>
			</div>
		</div>
		<!-- /.toolbar -->

		<table class="table">
			<colgroup>
				<col>
				<col width="30%">
				<col>
				<col width="70%">
			</colgroup>
			<thead>
			  <tr>
				<th scope="col" nowrap>
					&nbsp;
				</th>
				<th scope="col" nowrap>
					{!! __("lang.master.vaccine.title") !!}
				</th>
				<th scope="col" nowrap>
					{!! __("lang.form.seq") !!}
				</th>
				<th scope="col" nowrap>
					{!! __("lang.form.remark") !!}
				</th>
			  </tr>
			</thead>
			<tbody class="table-group-divider">
				@if($master_list_count > 0)
					@foreach($master_list as $key => $value)
						<tr class="{!! ($value["mtb_{$table}_id"] == $id) ? 'table-primary' : '' !!}">
							<th scope="row" nowrap>
								<div
									class="btn-group btn-group-sm"
									role="group"
								>
									<a
										class="btn btn-outline-secondary"
										href="{!! route('admin.covid.master.index', [
											$table,
											$value["mtb_{$table}_id"]
										]) !!}"
									>
										{!! __("lang.button.edit") !!}
									</a>
								</div>
							</th>
							<td nowrap>
								{!! $value["{$table}_label"] !!}
							</td>
							<td nowrap>
								<div class="text-center">
									<span class="fw-bold">
										{!! number_format($value['seq']) !!}
									</span>
								</div>
							</td>
							<td nowrap>
								{!! $value['remark'] !!}
							</td>
						</tr>
					@endforeach
				@else
					<tr>
						<th scope="row" nowrap>
							<div
								class="btn-group btn-group-sm"
								role="group"
							>
								<a
									class="btn btn-outline-secondary disabled"
									href=""
								>
									{!! __("lang.button.edit") !!}
								</a>
							</div>
						</th>
						<td colspan="3">
							{!! __("lang.error.empty") !!}
						</td>
					</tr>
				@endif
			</tbody>
		</table>

	</main>
	<!-- /.main -->

</div>


<!-- section -->
<section class="">

</section>
<!-- /.section -->
@endsection

{{-- css --}}
@section('css')
<style>

</style>
@stop

{{-- js --}}
@section('js')
<script>
$(function() {

	$('select').eq(0).focus();
});
</script>
@stop
