@extends('backend.layouts.main')

{{-- content --}}
@section('content')
<div class="row justify-content-md-center">

	<div class="col-lg-5">
		{!! Form::open($form) !!}
		{!! Form::hidden('publish[mtb_publish_id]', $publish['mtb_publish_id']) !!}

		{{-- alert --}}
		@if($publish['is_unpublish'])
			<div class="alert alert-danger text-center mb-3">
				<span class="fw-bold">
					予約受付停止中です
				</span>
			</div>
		@else
			<div class="alert alert-primary text-center mb-3">
				<span class="fw-bold">
					予約受付中です
				</span>
			</div>
		@endif
		{{-- /.alert --}}

		<div class="card mb-3">
			<div class="card-body">

				<div class="mb-3">
					<label
						class="fw-bold"
						for=""
					>
						受付停止
					</label>
					<div>
						@for($i = 1; $i >= 0; $i--)
							<div class="form-check-inline me-1">
								{!! Form::radio('publish[is_unpublish]', $i, ($i == $publish['is_unpublish']) ? true : false, [
									'class' => 'btn-check',
									'id' => "is_unpublish{$i}",
									'autocomplete' => 'off',
								]) !!}
								<label
									class="btn btn-outline-primary btn-sm mb-0 px-3"
									for="is_unpublish{!! $i !!}"
									style="width:100px;"
								>
									<span class="fw-bold">
										{!! __("lang.dictionary.is_yesno.{$i}") !!}
									</span>
								</label>
							</div>
						@endfor
					</div>
				</div>
				<div class="mb-3">
					<label
						class="fw-bold"
						for=""
					>
						受付停止日
					</label>
					{!! Form::date('publish[date_publish]', $publish['date_publish'], [
						'class' => 'form-control',
					]) !!}
				</div>
				<div class="mb-3">
					<label
						class="fw-bold"
						for=""
					>
						受付停止時メッセージ
					</label>
					{!! Form::textarea("publish[remark]", $publish['remark'], [
						'class' => 'form-control',
						'rows' => '5',
					]) !!}
				</div>

				<div class="d-grid gap-2">
					<button
						class="btn btn-primary"
						type="submit"
						name="action"
						value="store"
					>
						{!! __("lang.button.submit") !!}
					</button>
					<a
						class="btn btn-light border border-secondary"
						href="{!! route('admin.covid.master.publish.update') !!}"
					>
						{!! __("lang.button.cancel") !!}
					</a>
				</div>

			</div>
		</div>

		{!! Form::close() !!}
	</div>
	<!-- /.aside -->

</div>


<!-- section -->
<section class="">

</section>
<!-- /.section -->
@endsection

{{-- css --}}
@section('css')
<style>

</style>
@stop

{{-- js --}}
@section('js')
<script>
$(function() {

	$('select').eq(0).focus();
});
</script>
@stop
