@extends('backend.layouts.main')

{{-- content --}}
@section('content')
<div class="row g-4">

	<!-- aside -->
	<aside class="col-lg-3">
		{!! Form::open($form) !!}
		{!! Form::hidden("vaccine[mtb_vaccine_id]", $mtb_vaccine_id) !!}

		{{-- alert --}}
		@if($errors->any())
			<div class="alert alert-danger mb-3">
				<ul class="mb-0 ps-3">
					@foreach ($errors->all() as $error)
						<li>
							{!! implode('', [
								$error,
								__("lang.validation.required")
							]) !!}
						</li>
					@endforeach
				</ul>
			</div>
		@endif
		{{-- /.alert --}}

		<div class="card mb-3">
			<div class="card-body">

				<div class="mb-3">
					<label
						class="fw-bold"
						for=""
					>
						<span class="badge rounded-pill text-bg-danger me-1">
							{!! __("lang.form.required") !!}
						</span>
						{!! __("lang.master.vaccine.vaccine_label") !!}
					</label>
					{!! Form::text("vaccine[vaccine_label]", (isset($vaccine)) ? $vaccine["vaccine_label"] : '', [
						'class' => 'form-control',
					]) !!}
				</div>
				<div class="mb-3">
					<label
						class="fw-bold"
						for=""
					>
						<span class="badge rounded-pill text-bg-danger me-1">
							{!! __("lang.form.required") !!}
						</span>
						{!! __("lang.master.vaccine.is_show") !!}
					</label>
					<div>
						@for($i = 1; $i >= 0; $i--)
							<div class="form-check-inline me-1">
								{!! Form::radio('vaccine[is_show]', $i, (isset($vaccine)) ? (($i == $vaccine['is_show']) ? true : false) : (($i == 1) ? true : false), [
									'class' => 'btn-check',
									'id' => "is_show{$i}",
									'autocomplete' => 'off',
								]) !!}
								<label
									class="btn btn-outline-primary btn-sm mb-0 px-3"
									for="is_show{!! $i !!}"
									style="width:100px;"
								>
									<span class="small fw-bold">
										{!! __("lang.dictionary.is_yesno.{$i}") !!}
									</span>
								</label>
							</div>
						@endfor
					</div>
				</div>
				<div class="mb-3">
					<label
						class="fw-bold"
						for=""
					>
						<span class="badge rounded-pill text-bg-danger me-1">
							{!! __("lang.form.required") !!}
						</span>
						{!! __("lang.form.seq") !!}
					</label>
					{!! Form::number("vaccine[seq]", (isset($vaccine)) ? $vaccine['seq'] : $seq, [
						'class' => 'form-control',
					]) !!}
				</div>
				<div class="mb-3">
					<label
						class="fw-bold"
						for=""
					>
						{!! __("lang.form.remark") !!}
					</label>
					{!! Form::textarea("vaccine[remark]", (isset($vaccine)) ? $vaccine['remark'] : '', [
						'class' => 'form-control',
						'rows' => '5',
					]) !!}
				</div>

				<div class="d-grid gap-2">
					<button
						class="btn btn-primary"
						type="submit"
						name="action"
						value="store"
					>
						<span class="small fw-bold">
							{!! __("lang.button.submit") !!}
						</span>
					</button>
					<a
						class="btn btn-light border border-secondary"
						href="{!! route('admin.covid.master.vaccine.index') !!}"
					>
						<span class="small fw-bold">
							{!! __("lang.button.cancel") !!}
						</span>
					</a>
				</div>

			</div>
		</div>

		{!! Form::close() !!}
	</aside>
	<!-- /.aside -->

	<!-- main -->
	<main class="col">

		<!-- toolbar -->
		<div class="d-flex justify-content-between align-items-center mb-3">
			<div class="">
				{!! __("lang.form.count") !!}：
				<span class="fw-bold">
					{!! number_format($vaccine_list_count) !!}
				</span>
			</div>
			<div
				class="btn-group btn-group-sm"
				role="group"
			>
				<a
					class="btn btn-outline-secondary"
					href="{!! route('admin.home.index') !!}"
				>
					{!! __("lang.button.home") !!}
				</a>
				<a
					class="btn btn-outline-secondary"
					href="{!! route('admin.covid.master.vaccine.index') !!}"
				>
					{!! __("lang.button.create") !!}
				</a>
			</div>
		</div>
		<!-- /.toolbar -->

		<table class="table">
			<colgroup>
				<col>
				<col width="30%">
				<col>
				<col>
				<col width="70%">
			</colgroup>
			<thead>
			  <tr>
				<th scope="col" nowrap>
					&nbsp;
				</th>
				<th scope="col" nowrap>
					{!! __("lang.master.vaccine.vaccine_label") !!}
				</th>
				<th scope="col" nowrap>
					{!! __("lang.master.vaccine.is_show") !!}
				</th>
				<th scope="col" nowrap>
					{!! __("lang.form.seq") !!}
				</th>
				<th scope="col" nowrap>
					{!! __("lang.form.remark") !!}
				</th>
			  </tr>
			</thead>
			<tbody class="table-group-divider">
				@if($vaccine_list_count > 0)
					@foreach($vaccine_list as $key => $value)
						<tr class="{!! ($value["mtb_vaccine_id"] == $mtb_vaccine_id) ? 'table-primary' : '' !!}">
							<th scope="row" nowrap>
								<div
									class="btn-group btn-group-sm"
									role="group"
								>
									<a
										class="btn {!! ($value["mtb_vaccine_id"] == $mtb_vaccine_id) ? 'btn-outline-primary' : 'btn-outline-secondary' !!}"
										href="{!! route('admin.covid.master.vaccine.index', [
											$value["mtb_vaccine_id"]
										]) !!}"
									>
										<span class="small fw-bold">
											{!! __("lang.button.edit") !!}
										</span>
									</a>
								</div>
							</th>
							<td nowrap>
								{!! $value["vaccine_label"] !!}
							</td>
							<td nowrap>
								@if($value['is_show'])
									<div class="text-center">
										<i class="fa-solid fa-check fa-fw fa-lg"></i>
									</div>
								@endif
							</td>
							<td nowrap>
								<div class="text-center">
									<span class="fw-bold">
										{!! number_format($value['seq']) !!}
									</span>
								</div>
							</td>
							<td nowrap>
								{!! $value['remark'] !!}
							</td>
						</tr>
					@endforeach
				@else
					<tr>
						<th scope="row" nowrap>
							<div
								class="btn-group btn-group-sm"
								role="group"
							>
								<a
									class="btn btn-outline-secondary disabled"
									href=""
								>
									{!! __("lang.button.edit") !!}
								</a>
							</div>
						</th>
						<td colspan="3">
							{!! __("lang.error.empty") !!}
						</td>
					</tr>
				@endif
			</tbody>
		</table>

	</main>
	<!-- /.main -->

</div>


<!-- section -->
<section class="">

</section>
<!-- /.section -->
@endsection

{{-- css --}}
@section('css')
<style>

</style>
@stop

{{-- js --}}
@section('js')
<script>
$(function() {

	$('select').eq(0).focus();
});
</script>
@stop
