@extends('backend.layouts.main')

{{-- content --}}
@section('content')
<div class="row g-4">

	<!-- aside -->
	{{-- <aside class="col-lg-3">

		<div class="accordion" id="accordionExample">
			<div class="accordion-item">
				<h2
					class="accordion-header"
					id="headingOne"
				>
					<button
						class="accordion-button"
						type="button"
						data-bs-toggle="collapse"
						data-bs-target="#collapseOne"
						aria-expanded="true"
						aria-controls="collapseOne"
					>
						<span class="fw-bold">
							{!! __("lang.covid.title") !!}
						</span>
					</button>
				</h2>
				<div
					class="accordion-collapse collapse show"
					id="collapseOne"
					aria-labelledby="headingOne"
					data-bs-parent="#accordionExample"
				>
					<div class="accordion-body p-3">
						<p class="fw-bold text-muted text-center mb-2">
							進捗管理
						</p>
						<div class="d-grid gap-2 mb-0">
							<a
								class="btn btn-light border border-secondary"
								href="{!! route('admin.covid.calendar.index') !!}"
							>
								<span class="fw-bold small">
									{!! __("lang.calendar.title") !!}
								</span>
							</a>
							<a
								class="btn btn-light border border-secondary"
								href="{!! route('admin.covid.booking.index') !!}"
							>
								<span class="fw-bold small">
									{!! __("lang.calendar.today") !!}
								</span>
							</a>
							<a
								class="btn btn-light border border-secondary"
								href="{!! route('admin.covid.frontdesk.index') !!}"
							>
								<span class="fw-bold small">
									{!! __("lang.frontdesk.title") !!}
								</span>
							</a>
							<a
								class="btn btn-light border border-secondary"
								href="{!! route('admin.covid.search.index') !!}"
							>
								<span class="fw-bold small">
									{!! __("lang.search.title") !!}
								</span>
							</a>
						</div>

						@if(\Session::get('staff.is_admin'))
							<p class="fw-bold text-muted text-center my-4 mb-2">
								マスタ管理
							</p>
							<div class="d-grid gap-2">
								<a
									class="btn btn-light border border-secondary"
									href="{!! route('admin.covid.master.date.index') !!}"
								>
									<span class="fw-bold small">
										{!! __("lang.master.date.title") !!}
									</span>
								</a>
								<a
									class="btn btn-light border border-secondary"
									href="{!! route('admin.covid.master.acceptednumber.index') !!}"
								>
									<span class="fw-bold small">
										{!! __("lang.master.accepted_number.title") !!}
									</span>
								</a>
								<a
									class="btn btn-light border border-secondary"
									href="{!! route('admin.covid.master.index', [
										'vaccine'
									]) !!}"
								>
									<span class="fw-bold small">
										{!! __("lang.master.vaccine.title") !!}
									</span>
								</a>
							</div>
						@endif
					</div>
				</div>
			</div>
			<div class="accordion-item">
				<h2
					class="accordion-header"
					id="headingTwo"
				>
					<button
						class="accordion-button collapsed"
						type="button"
						data-bs-toggle="collapse"
						data-bs-target="#collapseTwo"
						aria-expanded="false"
						aria-controls="collapseTwo"
					>
						<span class="fw-bold">
							{!! __("lang.flu.title") !!}
						</span>
					</button>
				</h2>
				<div
					class="accordion-collapse collapse"
					id="collapseTwo"
					aria-labelledby="headingTwo"
					data-bs-parent="#accordionExample"
				>
					<div class="accordion-body p-3">
						<div class="d-grid gap-2">
							<a
								class="btn btn-light border border-secondary disabled"
								href=""
							>
								<span class="fw-bold small">
									{!! __("lang.calendar.title") !!}
								</span>
							</a>
							<a
								class="btn btn-light border border-secondary disabled"
								href=""
							>
								<span class="fw-bold small">
									{!! __("lang.calendar.today") !!}
								</span>
							</a>
						</div>
					</div>
				</div>
			</div>
		</div>

	</aside> --}}
	<!-- /.aside -->

	<!-- main -->
	<main class="col-12">

		<!-- section -->
		<section class="mb-5">

			<!-- toolbar -->
			<div class="d-flex justify-content-center align-items-center mb-4">
				<div>
					<a
						class=""
						href="{!! route('admin.home.index', [
							$date['prev']['yy'],
							$date['prev']['mm'],
							$date['prev']['dd'],
						]) !!}"
					>
						<i class="fa-solid fa-circle-chevron-left fa-fw fa-2x"></i>
					</a>
				</div>
				<div class="mx-3">
					<span class="fs-5 fw-bold">
						{!! \Carbon\Carbon::create($yy, $mm, $dd)->isoFormat('YYYY年M月D日（ddd）') !!}
						の申し込み一覧
					</span>
				</div>
				<div>
					<a
						class=""
						href="{!! route('admin.home.index', [
							$date['next']['yy'],
							$date['next']['mm'],
							$date['next']['dd'],
						]) !!}"
					>
						<i class="fa-solid fa-circle-chevron-right fa-fw fa-2x"></i>
					</a>
				</div>
			</div>
			<!-- /.toolbar -->

			<!-- toolbar -->
			<div class="d-flex justify-content-between align-items-center mb-3">
				<div>
					<ul class="list-inline mb-0">
						<li class="list-inline-item">
							件数：<span class="fw-bold">{!! $booking_list_count !!}</span>
						</li>
						<li class="list-inline-item">
							/
						</li>
						<li class="list-inline-item">
							WEB：<span class="fw-bold">{!! $count_list['web'] !!}</span>
						</li>
						<li class="list-inline-item">
							/
						</li>
						<li class="list-inline-item">
							電話：<span class="fw-bold">{!! $count_list['tel'] !!}</span>
						</li>
						<li class="list-inline-item">
							/
						</li>
						<li class="list-inline-item">
							不予約：<span class="fw-bold">{!! $count_list['leave'] !!}</span>
						</li>
					</ul>
				</div>
				<div></div>
			</div>
			<!-- /.toolbar -->

			<table class="table table-hover">
				<colgroup>
					<col>
					<col>
					<col>
					<col>
					<col>
					<col>
					<col>
					<col>
					<col width="100%">
					<col>
					<col>
				</colgroup>
				<thead class="table-group-divider">
					<tr>
						<th scope="col" nowrap>
							&nbsp;
						</th>
						<th scope="col" nowrap>
							#
						</th>
						<th scope="col" nowrap>
							受付時間
						</th>
						<th scope="col" nowrap>
							予約日
						</th>
						<th scope="col" nowrap>
							予約時間
						</th>
						<th scope="col" nowrap>
							受付方法
						</th>
						<th scope="col" nowrap>
							市町村区
						</th>
						{{--<th scope="col" nowrap>
							医従者
						</th>--}}
						<th scope="col" nowrap>
							基疾
						</th>
						<th scope="col" nowrap>
							{!! __("lang.booking.patient_kana") !!}
						</th>
						<th scope="col" nowrap>
							{!! __("lang.booking.birthday") !!}（{!! __("lang.booking.age") !!}）
						</th>
						<th scope="col" nowrap>
							応対者
						</th>
					</tr>
				</thead>
				<tbody class="table-group-divider">
					@if($booking_list_count > 0)
						@foreach($booking_list as $key => $value)
							<tr
								class="{!! ($value['is_booked']) ? '' : 'table-secondary' !!}"
								{{-- class="{!! ($value['is_booked']) ? 'clickable' : 'table-secondary' !!}"
								@if($value['is_booked'])
									data-href="{!! route('admin.covid.booking.status.show', [
										$value['yy'],
										$value['mm'],
										$value['dd'],
										$value['booking_code'],
									]) !!}"
									role="button"
								@endif --}}
							>
								<td nowrap>
									<div
										class="btn-group btn-group-sm"
										role="group"
									>
										@if ($value['is_booked'])
											<a
												class="btn btn-outline-{!! (App\Helper::getIsPDF($value)) ? 'primary' : 'secondary disabled' !!}"
												href="{!! route('admin.covid.booking.pdf.create', [
													$value['booking_code'],
												]) !!}"
												target="_blank"
												style="width:60px;"
											>
										@else
											<a
												class="btn btn-outline-secondary disabled"
												href="{!! route('admin.covid.booking.pdf.create', [
													$value['booking_code'],
												]) !!}"
												style="width:60px;"
											>
										@endif
											<span class="small fw-bold">
												問診票
											</span>
										</a>
										<a
											class="btn btn-outline-{!! ($value['is_booked']) ? 'primary' : 'secondary disabled' !!}"
											href="{!! route('admin.covid.booking.status.show', [
												$value['yy'],
												$value['mm'],
												$value['dd'],
												$value['booking_code'],
											]) !!}"
											style="width:60px;"
										>
											<span class="small fw-bold">
												詳細
											</span>
										</a>
									</div>
								</td>
								<th scope="col" nowrap>
									<div class="text-center">
										{!! $key + 1 !!}
									</div>
								</th>
								<td nowrap>
									<div class="text-center">
										{!! \Carbon\Carbon::parse($value['timestamp'])->format('H:i') !!}
									</div>
								</td>
								<td nowrap>
									{!! \Carbon\Carbon::create(
										$value['yy'],
										$value['mm'],
										$value['dd'],
										$value['hh'],
										$value['ii']
									)->isoFormat('YYYY年M月D日（ddd）') !!}
								</td>
								<td nowrap>
									<div class="text-center">
										{!! \Carbon\Carbon::create(
											$value['yy'],
											$value['mm'],
											$value['dd'],
											$value['hh'],
											$value['ii']
										)->isoFormat('HH:mm') !!}
									</div>
								</td>
								<td nowrap>
									<div class="text-center">
										<span class="fw-bold {!! ($value['is_web']) ? 'text-primary' : 'text-danger' !!}">
											{!! __("lang.dictionary.is_web.{$value['is_web']}") !!}
										</span>
									</div>
								</td>
								<td nowrap>
									<div class="text-start">
										{!! $value['address1'] !!}
									</div>
								</td>
								{{--<td nowrap>
									<div class="text-center text-dark">
										@if($value['is_staff'])
											<i class="fa-solid fa-check fa-fw fa-lg"></i>
										@endif
									</div>
								</td>--}}
								<td nowrap>
									<div class="text-center text-dark">
										@if($value['is_disease'])
											<i class="fa-solid fa-check fa-fw fa-lg"></i>
										@endif
									</div>
								</td>
								<td>
									{!! implode(' ', [
										$value['patient_skana'],
										$value['patient_gkana']
									]) !!}
								</td>
								<td nowrap>
									@if(($value['is_booked']))
										{!! \Carbon\Carbon::parse($value['birthday'])->format(__("lang.date.yymmdd")) !!}（{!! App\Helper::getAge(\Carbon\Carbon::parse($value['birthday'])->format('Y-m-d')) !!}）
									@endif
								</td>
								<td nowrap>
									@if(!$value['is_web'])
										@if(!is_null($value['staff_sname']))
											{!! implode(' ', [
												$value['staff_sname'],
												$value['staff_gname'],
											]) !!}
										@endif
									@endif
								</td>
							</tr>
						@endforeach
					@else
						<tr>
							<td nowrap>
								<div
									class="btn-group"
									role="group"
								>
									<a
										class="btn btn-outline-secondary btn-sm disabled"
										href=""
									>
										<small class="fw-bold">
											{!! __("lang.button.show") !!}
										</small>
									</a>
								</div>
							</td>
							<td colspan="10" nowrap>
								<div class="text-center">
									申し込みはありません
								</div>
							</td>
						</tr>
					@endif
				</tbody>
			</table>

		</section>
		<!-- /.section -->

		{{-- <button id="button" onclick="toggleStartStop()"></button>
			<div style="border:dotted;padding:10px">
			<span id="final_span"></span>
			<span id="interim_span" style="color:grey"></span>
		</div> --}}

		<!-- scroll-to-top -->
		<div
			class="scroll-to-top"
			style="z-index:999"
		>
			<a
				class="btn btn-primary"
				href="{!! route('admin.covid.booking.calendar.index') !!}"
				style="width:180px;"
			>
				<span class="fw-bold">
					{!! __("lang.calendar.title") !!}
				</span>
			</a>
			<a
				class="btn btn-dark"
				href="#page-top"
			>
				<span class="fw-bold">
					<i class="fas fa-angle-up"></i>
				</span>
			</a>
		</div>
		<!-- /.scroll-to-top -->

	</main>
	<!-- /.main -->

</div>
@endsection

{{-- css --}}
@section('css')
<style>

</style>
@stop

{{-- js --}}
@section('js')
<script>
$(function() {


});

// let recognizing;
// 	const recognition = new webkitSpeechRecognition();
// 	recognition.lang = "ja-JP";
// 	recognition.continuous = true;
// 	recognition.interimResults = true;
// 	reset();
// 	recognition.onend = reset;

// 	recognition.onresult = (event) => {
// 		let final = "";
// 		let interim = "";
// 		for (let i = 0; i < event.results.length; ++i) {
// 			if (event.results[i].isFinal) {
// 				final += event.results[i][0].transcript + "<br>";
// 			} else {
// 				interim += event.results[i][0].transcript;
// 			}
// 		}
// 		final_span.innerHTML = final;
// 		interim_span.innerHTML = interim;
// 	}

// function reset() {
// 	recognizing = false;
// 	button.innerHTML = "Click to Speak";
// }

// function toggleStartStop() {
// 	if (recognizing) {
// 		recognition.stop();
// 		reset();
// 	} else {
// 		recognition.start();
// 		recognizing = true;
// 		button.innerHTML = "Click to Stop";
// 		final_span.innerHTML = "";
// 		interim_span.innerHTML = "";
// 	}
// }
</script>
@stop
