@extends('backend.layouts.signin')

{{-- content --}}
@section('content')
{!! Form::open($form) !!}

<div class="row justify-content-center">
	<div class="col-lg-3">

		<!-- card -->
		<div class="card my-5">
			<div class="card-body">

				<img
					class="img-fluid mb-5"
					src="{!! implode('/', [
						asset('img'),
						'logo-md.png',
					]) !!}"
				>

				<div class="form-floating mb-3">
					{!! Form::password('password', [
						'class' => 'form-control',
						'placeholder' => 'パスワード',
						'id' => 'password',
					]) !!}
					<label
						class=""
						for="password"
					>
						{!! __("lang.form.password") !!}
					</label>
				</div>

				<div class="d-grid gap-2">
					<button
						class="btn btn-primary"
						type="submit"
						name="action"
						value="password"
					>
						<span class="small fw-bold">
							{!! __("lang.button.signin") !!}
						</span>
					</button>
				</div>
			</div>
		</div>
		<!-- /.card -->

	</div>
</div>
{!! Form::close() !!}
@endsection

{{-- css --}}
@section('css')
<style>

</style>
@stop

{{-- js --}}
@section('js')
<script>
$(function() {
	//
});
</script>
@stop
