@extends('backend.layouts.signin')

{{-- content --}}
@section('content')
{!! Form::open($form) !!}
{!! Form::hidden('action', '') !!}

<div class="row justify-content-center py-5">
	<div class="col-lg-12">

		<!-- alert -->
		<div class="alert alert-primary text-center mb-4">
			<h6 class="alert-heading">
				職員リストから自身を選択してください
			</h6>
		</div>
		<!-- /.alert -->

		<!-- nav -->
		<ul class="nav nav-tabs nav-fill mb-3">
			@foreach($division_list as $i => $content)
				<li class="nav-item">
					<button
						class="nav-link py-1 {!! ($i == 1) ? 'active' : '' !!}"
						data-bs-toggle="tab"
						data-bs-target="#tab{!! $i !!}"
						type="button"
						role="tab"
						aria-controls="tab{!! $i !!}"
						aria-selected="{!! ($i == 0) ? 'true' : 'false' !!}"
					>
						<span class="fw-bold">
							{!! $content !!}
						</span>
					</button>
				</li>
			@endforeach
		</ul>
		<!-- /.nav -->

		<!-- tab-content -->
		<div class="tab-content">
			@foreach($division_list as $i => $content)
				<div
					class="tab-pane fade {!! ($i == 1) ? 'show active' : '' !!}"
					id="tab{!! $i !!}"
					role="tabpanel"
					tabindex="0"
				>
					@if($staff_list_count > 0)
						<div class="row row-cols-2 row-cols-lg-4 g-3">
							@foreach($staff_list as $key => $value)
								@if($value['mtb_division_id'] == $i)
									<div class="col">
										<div class="d-grid">
											{!! Form::radio('staff_id', $value['dtb_staff_id'], false, [
												'class' => 'btn-check',
												'id' => "staff{$value['dtb_staff_id']}",
											]) !!}
											<label
												class="btn btn-outline-primary mb-0"
												for="staff{!! $value['dtb_staff_id'] !!}"
											>
												<span class="fw-bold">
													{!! implode(' ', [
														$value['staff_sname'],
														$value['staff_gname'],
													]) !!}
												</span>
											</label>
										</div>
									</div>
								@endif
							@endforeach
						</div>
					@else

					@endif
				</div>
			@endforeach
		</div>
		<!-- /.tab-content -->

	</div>
</div>

{!! Form::close() !!}
@endsection

{{-- css --}}
@section('css')
<style>

</style>
@stop

{{-- js --}}
@section('js')
<script>
$(function() {

	$('input[name="staff_id"]:radio').on('change', function() {

		//const id = $(this).val();

		$('input[name="action"]').val('staff');
		$('form').submit();
	});
});
</script>
@stop
