@extends('frontend.layouts.sticky')

{{-- content --}}
@section('content')
<!-- section -->
<section class="mb-4">
	<div class="container">

		<div
			class="alert alert-primary mb-0"
			role="alert"
		>
			<h3 class="alert-heading text-center">
				利用規約・個人情報保護方針
			</h3>
			<hr>
			<p class="fw-bold mb-0">
				利用規約・個人情報保護方針をご一読いただき、ご同意いただいた上で「同意する」ボタンをタップして次におすすみください。
			</p>
		</div>

	</div>
</section>
<!-- /.section -->

<!-- section -->
<section class="mb-5">
	<div class="container">

		<div class="d-grid gap-2">
			<button
				class="btn btn-outline-primary btn-lg border border-primary border-3 py-3"
				type="button"
				data-bs-toggle="modal"
				data-bs-target="#modal1"
			>
				<span class="fw-bold">
					利用規約
				</span>
			</button>
			{{-- <button
				class="btn btn-outline-primary btn-lg border border-primary border-3 py-3"
				type="button"
				data-bs-toggle="modal"
				data-bs-target="#modal2"
			>
				<span class="fw-bold">
					個人情報保護方針
				</span>
			</button> --}}
		</div>

	</div>
</section>
<!-- /.section -->

<!-- nav -->
<br><br>
<nav class="bar-bottom">
	<div class="d-grid gap-2 w-100">
		<div class="d-flex">
			<div class="flex-grow-1 me-2">
				<a
					class="btn btn-primary btn-lg border border-primary border-3 w-100"
					{{-- href="{!! route('frontend.covid.booking.consent.index') !!}" --}}
					href="{!! route('frontend.covid.booking.personal.index') !!}"
				>
					<span class="fw-bold">
						{!! __("lang.button.agree") !!}
					</span>
				</a>
			</div>
			<div>
				<a
					class="btn btn-outline-secondary btn-lg border border-secondary border-3"
					href="{!! route('frontend.covid.booking.home.index') !!}"
				>
					<span class="fw-bold">
						{!! __("lang.button.back") !!}
					</span>
				</a>
			</div>
		</div>
	</div>
</nav>
<!-- /.nav -->

<!-- modal1 -->
<div
	class="modal fade"
	id="modal1"
	data-bs-backdrop="static"
	data-bs-keyboard="false"
	tabindex="-1"
	aria-hidden="true"
>
	<div class="modal-dialog modal-dialog-scrollable">
		<div class="modal-content">
			<div class="modal-header">
				<h1 class="modal-title fs-5">
					利用規約
				</h1>
				<button
					type="button"
					class="btn-close"
					data-bs-dismiss="modal"
					aria-label="Close"
				></button>
			</div>
			<div class="modal-body">
				<p>
					この利用規約（「本規約」）は、創造会（「事業者」）が本アプリで提供するサービス（「本サービス」）の利用条件を定めるものです。利用者の皆さまには、本規約に従って本アプリ及び本サービスをご利用いただきます。
				</p>
				<h6 class="mb-3">
					第1条（用語の定義）
				</h6>
				<ol class="mb-5 ps-3">
					<li>
						コンテンツ」とは、文章、音声、音楽、画像、動画、ソフトウェア、プログラム、コード、その他の情報のことをいいます。
					</li>
					<li>
						「対象商品」とは、事業者が本アプリを通じて販売する物品又はサービスをいいます。
					</li>
					<li>
						「デバイス」とは、パーソナルコンピュータ、スマートフォン、タブレット等、利用者が本アプリ及び本サービスを利用するための機器のことをいいます。
					</li>
					<li>
						「本アプリ」とは、事業者が提供する下記アプリケーションソフトウェアをいいます。
					</li>
					<li>
						「本コンテンツ」とは、その作成者・投稿者・送信者・アップロードした者が誰であるかを問わず、本サービスを通じてアクセスできるあらゆるコンテンツのことをいいます。
					</li>
					<li>
						「投稿コンテンツ」とは、本サービスの利用者が本サービスに投稿・送信・アップロードしたコンテンツのことをいいます。
					</li>
					<li>
						「利用者」とは、本サービスを利用する（閲覧、登録、予約、データ送信、ログインを含む）全ての個人をいいます
					</li>
					<li>
						「クッキー」とは、ウェブサーバーから利用者のウェブブラウザに送信される小さなデータのことで、利用者のパソコンのハードディスクにファイルとして格納されるものもあります。クッキーには利用者のコンピュータに関する情報や最後にサイトを訪れた日時、訪問回数などを記憶しておくことができますが、特定の個人を識別することはできないよう匿名性が保たれています。
					</li>
					<li>
						「反社会的勢力等」とは、暴力団、暴力団員、右翼団体、その他これに準じる者をいいます。
					</li>
					<li>
						「登録事項」とは、本サービスの利用登録希望者が利用登録申請をするために事業者に提供する必要がある事項として、事業者が定める事項をいいます。
					</li>
				</ol>

				<h6 class="mb-3">
					第2条（本規約への同意）
				</h6>
				<ol class="mb-5 ps-3">
					<li>
						利用者は、本規約に同意した場合のみ、本アプリ及び本サービスを利用できるものとします。利用者は、同意ボタンを押す方法により本規約に同意するものとします。
					</li>
					<li>
						事業者は、本規約の他、本アプリ及び本サービス利用のルール・条件・ガイドライン等（「個別規定」）を定めることがあります。利用者は、本規約及び個別規定に従って本アプリ及び本サービスを利用しなければなりません。
					</li>
					<li>
						利用者が未成年者である場合は、下記のとおりとします。
						<ol class="mb-0 ps-3">
							<li>
								親権者等の法定代理人の同意を得た上で本アプリ及び本サービスを利用してください。　
							</li>
							<li>
								未成年者の利用者が、法定代理人の同意がないにもかかわらず同意があると偽り、又は年齢について成年と偽って本アプリ又は本サービスを利用した場合、その他能力者であると信じさせるために詐術を用いた場合は、本サービスに関する一切の法律行為を取り消すことはできません。
							</li>
							<li>
								本規約への同意時に未成年であった利用者が、成年に達した後に本アプリ又は本サービスを利用した場合は、当該利用者は本アプリ及び本サービスに関する一切の法律行為を追認したものとみなします。
							</li>
						</ol>
					</li>
				</ol>

				<h6 class="mb-3">
					第3条（利用登録）
				</h6>
				<ol class="mb-5 ps-3">
					<li>
						本サービスにおいては、利用登録希望者が本規約に同意の上、登録事項を事業者の定める方法によって事業者に提供して利用登録申請をし、事業者がこれを承認することによって、利用登録が完了するものとします。
					</li>
					<li>
						事業者は、利用登録の申請者に以下の各号のいずれかの事由があると事業者が判断した場合は、利用登録の申請を承認しないことがあり、その理由について一切の開示義務を負わないものとします。
						<ol class="mb-0 ps-3">
							<li>
								登録事項に虚偽、誤記、又は記載漏れがある場合
							</li>
							<li>
								申請者が未成年者、成年被後見人、被保佐人、又は被補助人であり、法定代理人、後見人、保佐人、又は補助人の同意等を得ていない場合
							</li>
							<li>
								申請者が反社会的勢力等である場合、又は資金提供その他を通じて反社会的勢力等の維持、運営、又は経営に協力又は関与する等、反社会的勢力等と何らかの交流又は関与を持っている場合
							</li>
							<li>
								本規約に違反したことがある者、又はその関係者からの申請である場合
							</li>
							<li>
								その他、事業者が利用登録を相当でないと判断した場合
							</li>
						</ol>
					</li>
					<li>
						利用者は、登録事項に変更が生じた場合は直ちに情報を更新することとし、常に真実、正確、完全、かつ最新の情報となるよう維持しなければなりません。
					</li>
					<li>
						利用者は、事業者が別途定める退会手続により、本サービスから退会できるものとします。
					</li>
				</ol>

				<h6 class="mb-3">
					第4条（利用者ID及びパスワードの管理）
				</h6>
				<ol class="mb-5 ps-3">
					<li>
						利用者は、自己の責任において、本サービスに関する利用者ID及びパスワードを適切に管理及び保管しなければなりません。利用者ID及びパスワードは利用者に一身専属的に帰属するものとし、これを第三者に利用させ、又は第三者と共有し、又は貸与・譲渡・名義変更・売買等をしてはならず、相続することもできません。
					</li>
					<li>
						事業者は、利用者ID及びパスワードが入力されて本サービスの利用が行われた場合は、当該利用者IDの登録利用者本人が本サービスを利用したものと扱うことができるものとします。
					</li>
					<li>
						ユーザーID又はパスワードの管理不十分、使用上の過誤、第三者の使用等によって生じた損害については、利用者が負担するものとします。
					</li>
				</ol>

				<h6 class="mb-3">
					第5条（予約・変更・キャンセル）
				</h6>
				<ol class="mb-5 ps-3">
					<li>
						利用者は、氏名（カナ）、生年月日、電話番号、 及び 接種券番号 等 事業所が定めた必要情報 を登録しなければなりません。
					</li>
					<li>
						利用者はワクチン接種の予約に当たり、接種会場、ワクチンの種類、及び予約希望日時を 選択し、「予約を確定する」ボタンを押す ことで、予約 申込みができます。
					</li>
					<li>
						利用予約は予約完了ページが表示された時点もって、事業者は当該予約を承諾したものとみなし、利用者と事業者との間で予約 が成立します。
					</li>
					<li>
						事業者は利用者の責めに帰すべき事由（予約時の 電話番号等の連絡先の入力ミス 、及び 当市区町村からの連絡等を受領しないこと等 を含みます。）により、利用者に発生する一切の損害等について、いかなる責任も負いません。
					</li>
					<li>
						利用者は予約日の 前々日 まで、本サービス上で予約のキャンセルおよび予約日時の変更ができます。
					</li>
				</ol>

				<h6 class="mb-3">
					第6条（禁止事項）
				</h6>
				<ol class="mb-5 ps-3">
					<li>
						利用者は、本アプリ又は本サービスの利用に当たり、利用者の故意又は過失を問わず以下の各号のいずれかの行為およびそれらを試みる行為を禁止します。予約者が禁止行為をした場合は、事業者は事前の告知なく本サービスの利用停止、予約者としての資格の剥奪、その他事業者が必要と判断した措置を事前の通知なく実施するものとします 。
						<ol class="mb-0 ps-3">
							<li>
								法令に違反する行為
							</li>
							<li>
								犯罪に関連する行為
							</li>
							<li>
								公序良俗に反する行為
							</li>
							<li>
								本サービスの他の利用者又はその他の第三者の知的財産権、肖像権、プライバシー、名誉、その他の権利又は利益を侵害する行為
							</li>
							<li>
								本サービスの内容等、本サービスに含まれる著作権、商標 権、その他の知的財産権を侵害する行為
							</li>
							<li>
								本サービスによって得られた情報を本サービスの目的以外で利用する行為
							</li>
							<li>
								事業者が許諾しない本サービス上での宣伝、広告、勧誘、又は営業行為
							</li>
							<li>
								本サービスを構成するサーバを含むハードウェア又はネットワークへの不正アクセス行為、クラッキング行為、有害なプログラム情報を送信する行為その他設備等機能に支障を与える行為
							</li>
							<li>
								本サービスの運営を妨害する行為
							</li>
							<li>
								不正な目的を持って本サービスを利用する行為
							</li>
							<li>
								他の利用者又は第三者になりすます行為
							</li>
							<li>
								他の利用者の接種券番号を利用する行為
							</li>
							<li>
								他の利用者の情報の収集およびこれを利用する行為
							</li>
							<li>
								他の利用者に関する個人情報等を収集又は蓄積する行為
							</li>
							<li>
								その他、事業者が不適切とする判断が不適切とする判断
							</li>
						</ol>
					</li>
					<li>
						利用者は、本規約の違反行為に起因して事業者に生じた損害（弁護士費用を含む）を賠償するものとします。
					</li>
				</ol>

				<h6 class="mb-3">
					第7条（本アプリ及び本サービスの提供の停止等）
				</h6>
				<ol class="mb-5 ps-3">
					<li>
						事業者は、以下のいずれかの事由があると判断した場合、利用者に事前に通知することなく本アプリ及び本サービスの全部又は一部の提供を停止又は中断することができるものとします。
						<ol class="mb-0 ps-3">
							<li>
								本アプリ又は本サービスにかかるコンピュータシステムの保守点検又は更新を行う場合
							</li>
							<li>
								地震、落雷、火災、又は停電などの不可抗力により、本アプリ又は本サービスの提供が困難となった場合
							</li>
							<li>
								コンピュータ又は通信回線等が事故により停止した場合
							</li>
							<li>
								その他、事業者が本アプリ又は本サービスの提供が困難と判断した場合
							</li>
						</ol>
					</li>
					<li>
						事業者は、事業者の都合により、いつでも本アプリ及び本サービスの提供を終了することができます。
					</li>
					<li>
						事業者は、本アプリ又は本サービスの提供の停止又は中断により、利用者又は第三者が被ったいかなる不利益又は損害についても、一切の責任を負わないものとします。
					</li>
				</ol>

				<h6 class="mb-3">
					第８条（利用制限及び登録抹消）
				</h6>
				<ol class="mb-5 ps-3">
					<li>
						事業者は、利用者が以下のいずれかに該当すると事業者が判断した場合は、事前の通知をせずに、利用者に対して、当該利用者に関する表示を削除又は非表示にし、本アプリ及び本サービスの全部もしくは一部の利用を制限又は一時停止し、又は利用者としての登録を抹消することができるものとします。
						<ol class="mb-0 ps-3">
							<li>
								本規約のいずれかの条項に違反した場合
							</li>
							<li>
								登録事項に虚偽の事実があることが判明した場合
							</li>
							<li>
								事業者、他の利用者、又は第三者に損害を生じさせるおそれのある目的又は方法で本アプリ又は本サービスを利用した、又は利用しようとした場合
							</li>
							<li>
								本アプリ又は本サービスの運営を妨害した、又は妨害しようとした場合
							</li>
							<li>
								死亡した場合、又は後見開始、保佐開始、若しくは補助開始の審判を受けた場合
							</li>
							<li>
								事業者からの連絡に対し、60日を超えて返答がない場合
							</li>
							<li>
								本サービスについて、最終の利用から1年間を超えて利用がない場合
							</li>
							<li>
								上記の他、事業者が本アプリ及び本サービスの利用又は利用者としての登録の継続を適当でないと判断した場合
							</li>
						</ol>
					</li>
					<li>
						利用者は、本条による利用制限および登録抹消の後も、本規約上の一切の義務および債務を免れるものではありません。
					</li>
					<li>
						事業者は、本条に基づき事業者が行った措置により利用者に生じた損害について、一切の責任を負いません。
					</li>
				</ol>

				<h6 class="mb-3">
					第9条（利用環境の整備）
				</h6>
				<ol class="mb-5 ps-3">
					<li>
						利用者は、本アプリ及び本サービスの利用に必要となるデバイス、ソフトウェア、通信回線、その他の環境を、利用者の責任と負担において準備するものとします。
					</li>
					<li>
						本アプリ及び本サービスの利用に伴い発生する通信料は、利用者の負担とします。
					</li>
					<li>
						利用者は、本アプリをインストールしたデバイスを処分する場合、又は本アプリの使用を終了する場合、本アプリを必ず削除するものとします。
					</li>
				</ol>

				<h6 class="mb-3">
					第10条（保証の否認）
				</h6>
				<p class="mb-5">
					事業者は、本アプリ又は本サービス並びに対象商品が利用者の特定の目的に適合すること、利用者が期待する機能・商品的価値・正確性・有用性・信頼性・完全性・安全性を有していること、利用者に対して適用のある法令又は業界団体内部規則等に適合すること、継続的な利用ができること、欠陥・エラー・バグがないこと、利用者又は第三者の権利侵害が生じないこと、及び不具合が生じないことにつき、明示又は黙示を問わず、何ら保証するものではありません。
				</p>

				<h6 class="mb-3">
					第11条（免責）
				</h6>
				<ol class="mb-5 ps-3">
					<li>
						事業者は、本サービス又は本アプリの利用、又は本サービス又は本アプリの内容の変更、サービス提供の中断、停止、又は終了、サービス利用の不能、利用者が発信するメッセージ又は情報が削除され、又は消失したこと、利用者に対する利用制限措置又は登録抹消措置、本サービス又は本アプリのデータ消失又はデバイスの故障・損傷、本サービス又は本アプリがデバイスに与える影響、利用者が本サービス又は本アプリを正常に利用することができないことにより被る不利益、データ消失の不利益、その他本アプリ又は本サービスに起因し、又は関連して利用者が受けたあらゆる損害について、一切の責任を負いません。
					</li>
					<li>
						前項の規定は、事業者に故意又は重過失がある場合は適用しません。
					</li>
					<li>
						本規約が消費者契約法に定める消費者契約となる場合、本条第1項の規定は適用しません。ただし、この場合であっても、事業者は、事業者の過失（重過失を除く）による行為によって利用者が受けた損害のうち、付随的な損害、間接的な損害、特別損害、将来発生する損害、及び逸失利益にかかる損害については、一切賠償する責任を負わないものとします。
					</li>
					<li>
						事業者は、本アプリ及び本サービスに関して、利用者同士、又は利用者と利用者以外の第三者との間で生じた取引、連絡、紛争等について一切の責任を負いません。
					</li>
				</ol>

				<h6 class="mb-3">
					第12条（本コンテンツ及び本アプリの権利）
				</h6>
				<p class="mb-5">
					本アプリ及び本サービスに関する知的財産権は全て事業者又は事業者にライセンスを許諾している者に帰属しており、本規約に基づき本アプリ及び本サービスの利用を許諾されることは、本サービスに関する事業者又は事業者にライセンスを許諾している者の知的財産権の使用許諾を意味するものではありません。利用者は、いかなる理由によっても事業者又は事業者にライセンスを許諾している者の知的財産権を侵害するおそれのある行為（逆アセンブル、逆コンパイル、リバースエンジニアリング等を含む）をしてはいけません。
				</p>

				<h6 class="mb-3">
					第13条（本規約の変更）
				</h6>
				<ol class="mb-5 ps-3">
					<li>
						事業者は、必要と判断した場合にはいつでも本規約を変更することができるものとします。
					</li>
					<li>
						事業者は、本規約を変更したときは、事業者のウェブサイトにアップロードする方法により利用者に通知するものとし、同通知には変更後の規約の効力発生日を明記するものとします。
					</li>
					<li>
						本規約の変更が利用者の一般の利益に適合するとともに本規約の目的に反せず、かつ、変更の必要性、変更後の内容の相当性、その他の変更に係る事情に照らして合理的なものであるときは、本規約の変更は、利用者の合意がなくても通知に記載された効力発生日から生じるものとします。
					</li>
					<li>
						本規約の変更が前項の要件を満たさない場合は、本規約の変更は利用者の同意を得たときから効力を生じるものとします。
					</li>
				</ol>

				<h6 class="mb-3">
					第14条（個人情報の取扱い）
				</h6>
				<ol class="mb-5 ps-3">
					<li>
						事業者は個人情報保護関連法令・例規に基づいて個人情報（本サービスを通じて収集した氏名、住所、電話番号など特定の個人が識別できる情報をいいます。）を厳重に管理し、漏洩、不正利用、改ざんの防止に適切な措置を行います 。
					</li>
					<li>
						事業者は個人情報保護関連法令・例規に定める場合を除き、個人情報及び個人データ（次項に定めます。）の目的外利用を行うこと及び第三者に個人情報を提供することはありません。
					</li>
					<li>
						利用者は、本サービスの利用に当たり、事業者の本サービス管理者が、利用者の氏名・生年月日・電話番号・予約状況・ワクチン接種状況 を閲覧できることに同意するものとします。
					</li>
					<li>
						利用者が登録した個人情報については、 コロナワクチン接種の履行、 コロナワクチン接種に関する国や市町村等への情報提供、利用者への通知・連絡、次項に定める統計的情報の作成およびその他サービスの提供を円滑に行う目的で利用します。
					</li>
					<li>
						本サービスに蓄積される情報は、以下の各号の目的に限り、個人を特定できない形の統計的な情報として、共同利用および第三者への提供ができるものとします。
						<ol class="mb-0 ps-3">
							<li>
								接種の安全性向上
							</li>
							<li>
								ワクチン等製品の品質向上、製品改良
							</li>
							<li>
								医療機関、教育機関、研究機関における調査・研究
							</li>
							<li>
								ワクチン等の安定供給
							</li>
							<li>
								接種に対する一般理解の向上
							</li>
							<li>
								臨床現場に向けてのフィードバック
							</li>
						</ol>
					</li>
					<li>
						本サービス上の個人データが毀損・滅失した場合、事業者はサービス提供事業者に個人データの復元を委託する場合があります。サービス提供事業者において、バックアップデータ内の個人データにアクセスできるのは担当者に限定されており、アクセス制限の措置が取られております。また、この場合も、サービス提供事業者は個人デーは個人データを利用しないものとします。を利用しないものとします。
					</li>
				</ol>

				<h6 class="mb-3">
					第15条（通知又は連絡）
				</h6>
				<ol class="mb-5 ps-3">
					<li>
						本アプリ又は本サービスに関する事業者から利用者への通知・連絡は、事業者のウェブサイトへの掲示、又は事業者が定めるその他の適切な方法により行うものとします。なお、事業者がその時点で登録されている利用者の連絡先へ連絡をした場合は、その連絡は利用者に到達したものとみなします。
					</li>
					<li>
						本アプリ又は本サービスに関する利用者から事業者への連絡は、事業者のウェブサイト内お問い合わせフォームの送信、又は事業者が定めるその他の方法により行うものとします。
					</li>
				</ol>

				<h6 class="mb-3">
					第16条（権利義務の譲渡）
				</h6>
				<ol class="mb-5 ps-3">
					<li>
						利用者は、事業者の書面による事前の承諾なく、利用契約上の地位又は本規約に基づく権利もしくは義務を第三者に譲渡し、又は担保に供することはできません。
					</li>
					<li>
						事業者は、利用者にあらかじめ通知することなく、本アプリ及び本サービスにかかる事業を他者に譲渡（事業譲渡、会社分割、会社合併などその態様を問いません）することができ、利用者は本項においてこれに予め同意したものとします。事業者が事業譲渡を行った場合、利用契約上の地位、本規約に基づく権利及び義務、利用者の登録事項、その他の顧客情報を譲受人に譲渡することができます。
					</li>
				</ol>

				<h6 class="mb-3">
					第17条（完全合意）
				</h6>
				<p class="mb-5">
					本規約は、本規約に含まれる事項に関する事業者と利用者との完全な合意を構成し、口頭又は書面を問わず、本規約に含まれる事項に関する事業者と利用者の事前の合意、表明、及び了解に優先します。
				</p>

				<h6 class="mb-3">
					第18条（分離可能性）
				</h6>
				<p class="mb-5">
					本規約のいずれかの条項又はその一部が、消費者契約法その他の法令等により無効又は執行不能と判断された場合であっても、本規約のその他の規定、及び一部が無効又は執行不能と判断された規定の残りの部分は継続して完全に効力を有するものとする。また、事業者及び利用者は、当該無効若しくは執行不能とされた条項又は部分が適法かつ執行力を有するために必要な範囲で修正し、当該無効若しくは執行不能な条項又は部分の趣旨並びに法律的及び経済的に同等の効果を確保できるよう努めるものとします。
				</p>

				<h6 class="mb-3">
					第19条（準拠法）
				</h6>
				<p class="mb-5">
					本規約の有効性、解釈、及び履行については日本法に準拠し、日本法に従って解釈されるものとします。
				</p>

				<h6 class="mb-3">
					第20 条（合意管轄）
				</h6>
				<p class="mb-5">
					本規約、本アプリ、又は本サービスに関する一切の紛争については東京地方裁判所を第一審の専属的管轄裁判所とします。
				</p>

				<p class="">
					制定日：2023年06月05日
				</p>
			</div>
			<div class="modal-footer">
				<button
					class="btn btn-secondary"
					type="button"
					data-bs-dismiss="modal"
				>
					<span class="fw-bold">
						{!! __("lang.button.close") !!}
					</span>
				</button>
			</div>
		</div>
	</div>
</div>
<!-- /.modal1 -->

<!-- modal2 -->
<div
	class="modal fade"
	id="modal2"
	data-bs-backdrop="static"
	data-bs-keyboard="false"
	tabindex="-1"
	aria-hidden="true"
>
	<div class="modal-dialog modal-dialog-scrollable">
		<div class="modal-content">
			<div class="modal-header">
				<h1 class="modal-title fs-5">
					個人情報保護方針
				</h1>
				<button
					type="button"
					class="btn-close"
					data-bs-dismiss="modal"
					aria-label="Close"
				></button>
			</div>
			<div class="modal-body">
				This is some placeholder content to show the scrolling behavior for modals. We use repeated line breaks to demonstrate how content can exceed minimum inner height, thereby showing inner scrolling. When content becomes longer than the predefined max-height of modal, content will be cropped and scrollable within the modal.<br>
				This is some placeholder content to show the scrolling behavior for modals. We use repeated line breaks to demonstrate how content can exceed minimum inner height, thereby showing inner scrolling. When content becomes longer than the predefined max-height of modal, content will be cropped and scrollable within the modal.<br>
				This is some placeholder content to show the scrolling behavior for modals. We use repeated line breaks to demonstrate how content can exceed minimum inner height, thereby showing inner scrolling. When content becomes longer than the predefined max-height of modal, content will be cropped and scrollable within the modal.<br>
				This is some placeholder content to show the scrolling behavior for modals. We use repeated line breaks to demonstrate how content can exceed minimum inner height, thereby showing inner scrolling. When content becomes longer than the predefined max-height of modal, content will be cropped and scrollable within the modal.<br>
				This is some placeholder content to show the scrolling behavior for modals. We use repeated line breaks to demonstrate how content can exceed minimum inner height, thereby showing inner scrolling. When content becomes longer than the predefined max-height of modal, content will be cropped and scrollable within the modal.<br>
				This is some placeholder content to show the scrolling behavior for modals. We use repeated line breaks to demonstrate how content can exceed minimum inner height, thereby showing inner scrolling. When content becomes longer than the predefined max-height of modal, content will be cropped and scrollable within the modal.<br>
				This is some placeholder content to show the scrolling behavior for modals. We use repeated line breaks to demonstrate how content can exceed minimum inner height, thereby showing inner scrolling. When content becomes longer than the predefined max-height of modal, content will be cropped and scrollable within the modal.<br>
				This is some placeholder content to show the scrolling behavior for modals. We use repeated line breaks to demonstrate how content can exceed minimum inner height, thereby showing inner scrolling. When content becomes longer than the predefined max-height of modal, content will be cropped and scrollable within the modal.<br>
				This is some placeholder content to show the scrolling behavior for modals. We use repeated line breaks to demonstrate how content can exceed minimum inner height, thereby showing inner scrolling. When content becomes longer than the predefined max-height of modal, content will be cropped and scrollable within the modal.<br>
				This is some placeholder content to show the scrolling behavior for modals. We use repeated line breaks to demonstrate how content can exceed minimum inner height, thereby showing inner scrolling. When content becomes longer than the predefined max-height of modal, content will be cropped and scrollable within the modal.<br>
				This is some placeholder content to show the scrolling behavior for modals. We use repeated line breaks to demonstrate how content can exceed minimum inner height, thereby showing inner scrolling. When content becomes longer than the predefined max-height of modal, content will be cropped and scrollable within the modal.<br>
				This is some placeholder content to show the scrolling behavior for modals. We use repeated line breaks to demonstrate how content can exceed minimum inner height, thereby showing inner scrolling. When content becomes longer than the predefined max-height of modal, content will be cropped and scrollable within the modal.<br>
				This is some placeholder content to show the scrolling behavior for modals. We use repeated line breaks to demonstrate how content can exceed minimum inner height, thereby showing inner scrolling. When content becomes longer than the predefined max-height of modal, content will be cropped and scrollable within the modal.<br>
				This is some placeholder content to show the scrolling behavior for modals. We use repeated line breaks to demonstrate how content can exceed minimum inner height, thereby showing inner scrolling. When content becomes longer than the predefined max-height of modal, content will be cropped and scrollable within the modal.<br>
			</div>
			<div class="modal-footer">
				<button
					class="btn btn-secondary"
					type="button"
					data-bs-dismiss="modal"
				>
					<span class="fw-bold">
						{!! __("lang.button.close") !!}
					</span>
				</button>
			</div>
		</div>
	</div>
</div>
<!-- /.modal2 -->

@endsection

{{-- css --}}
@section('css')
<style>

</style>
@stop

{{-- js --}}
@section('js')
<script>
$(function() {
	//
});
</script>
@stop
