@extends('frontend.layouts.sticky')

{{-- content --}}
@section('content')
{!! Form::open($form) !!}
{!! Form::hidden('booking[booking_code]', \Session::get('booking.booking_code')) !!}
{!! Form::hidden('booking[is_booked]', 1) !!}
{!! Form::hidden('booking[is_web]', 1) !!}

<!-- section -->
<section class="mb-3">
	<div class="container">

		@include('frontend.layouts.components.progress')

		<div
			class="alert alert-primary mb-0"
			role=""
		>
			<h3 class="alert-heading text-center mb-3">
				入力内容の確認
			</h3>
			<hr>
			<p class="fw-bold mb-0">
				入力内容をご確認ください。<br>
				この内容でよろしければ、「予約を確定する」ボタンをタップしてください。
			</p>
		</div>
	</div>
</section>
<!-- /.section -->

<!-- section -->
<section class="mb-3">
	<div class="container">

		<div
			class="alert alert-success text-center mb-3 p-3"
			role="alert"
		>
			<ul class="list-unstyled fs-4 fw-bold mb-0">
				<li class="d-flex justify-content-start align-items-center">
					<span class="">
						種別：
					</span>
					<span class="">
						{!! $vaccine_label !!}
					</span>
				</li>
				<li class="d-flex justify-content-start align-items-center my-2">
					<span class="">
						{!! __("lang.date.title") !!}：
					</span>
					<span class="">
						{!! \Carbon\Carbon::create(
							\Session::get('booking.yy'),
							\Session::get('booking.mm'),
							\Session::get('booking.dd')
						)->isoFormat('YYYY年M月D日（ddd）') !!}
					</span>
				</li>
				<li class="d-flex justify-content-start align-items-center">
					<span class="">
						{!! __("lang.date.time") !!}：
					</span>
					<span class="">
						{!! \Carbon\Carbon::create(
							\Session::get('booking.yy'),
							\Session::get('booking.mm'),
							\Session::get('booking.dd'),
							\Session::get('booking.hh'),
							\Session::get('booking.ii')
						)->format(__("lang.date.hhii")) !!}
					</span>
				</li>
			</ul>
		</div>

		<ul class="list-group list-group-flush">
			<li class="list-group-item d-flex justify-content-between align-items-center py-3">
				<div class="">
					<span class="fw-bold">
						接種会場
					</span>
				</div>
				<div class="ms-auto">
					平和台病院
				</div>
			</li>
			<li class="list-group-item d-flex justify-content-between align-items-center py-3">
				<div class="">
					<span class="fw-bold">
						ワクチンの種類
					</span>
				</div>
				<div class="ms-auto">
                    {!! $vaccine_label !!}
				</div>
			</li>
			<li class="list-group-item d-flex justify-content-between align-items-center py-3">
				<div class="">
					<span class="fw-bold">
						前回接種日
					</span>
				</div>
				<div class="ms-auto">
					{!! \Carbon\Carbon::create(
						\Session::get('date_last.yy'),
						\Session::get('date_last.mm'),
						\Session::get('date_last.dd')
					)->isoFormat('YYYY年M月D日（ddd）') !!}
				</div>
			</li>
			<li class="list-group-item d-flex justify-content-between align-items-center py-3">
				<div class="">
					<span class="fw-bold">
						今回接種回数
					</span>
				</div>
				<div class="ms-auto">
					{!! \Session::get('booking.shots_number') !!}回目
				</div>
			</li>
			<li class="list-group-item d-flex justify-content-between align-items-center py-3">
				<div class="">
					<span class="fw-bold">
						接種券番号
					</span>
				</div>
				<div class="ms-auto">
					{!! \Session::get('booking.voucher_number') !!}
				</div>
			</li>
			<li class="list-group-item d-flex justify-content-between align-items-center py-3">
				<div class="">
					<span class="fw-bold">
						氏名カナ
					</span>
				</div>
				<div class="ms-auto">
					{!! implode(' ', [
						\Session::get('booking.patient_skana'),
						\Session::get('booking.patient_gkana'),
					]) !!}
				</div>
			</li>
			<li class="list-group-item d-flex justify-content-between align-items-center py-3">
				<div class="">
					<span class="fw-bold">
						携帯電話番号
					</span>
				</div>
				<div class="ms-auto">
					{!! \Session::get('booking.mobile') !!}
				</div>
			</li>
			<li class="list-group-item d-flex justify-content-between align-items-center py-3">
				<div class="">
					<span class="fw-bold">
						生年月日（西暦）
					</span>
				</div>
				<div class="ms-auto">
					{!! \Carbon\Carbon::create(
						\Session::get('birthday.yy'),
						\Session::get('birthday.mm'),
						\Session::get('birthday.dd')
					)->isoFormat('YYYY年M月D日') !!}
				</div>
			</li>
		</ul>
	</div>
</section>
<!-- /.section -->

<!-- nav -->
<br><br><br><br>
<nav class="bar-bottom">
	<div class="d-grid gap-2 w-100">
		<button
			class="btn btn-success btn-lg w-100"
			type="submit"
			name="action"
			value="store"
		>
			<span class="fw-bold">
				予約を確定する
			</span>
		</button>
		<div class="d-flex">
			<div class="flex-grow-1 me-2">
				<a
					class="btn btn-outline-danger btn-lg border border-danger border-3 w-100"
					data-bs-toggle="modal"
					data-bs-target="#modal-cancel"
				>
					<span class="fw-bold">
						予約をやめる
					</span>
				</a>
			</div>
			<div>
				<a
					class="btn btn-outline-secondary btn-lg border border-secondary border-3"
					href="{!! route('frontend.covid.booking.guest.index') !!}"
				>
					<span class="fw-bold">
						{!! __("lang.button.back") !!}
					</span>
				</a>
			</div>
		</div>
	</div>
</nav>
<!-- /.nav -->

<!-- modal -->
<div
	class="modal fade"
	id="modal-cancel"
	data-bs-backdrop="static"
	data-bs-keyboard="false"
	tabindex="-1"
	aria-hidden="true"
>
	<div class="modal-dialog modal-dialog-centered">
		<div class="modal-content">
			<div class="modal-header">
				<h1 class="modal-title fs-5">
					予約をやめますか？
				</h1>
				<button
					type="button"
					class="btn-close"
					data-bs-dismiss="modal"
					aria-label="Close"
				></button>
			</div>
			<div class="modal-body">
				<p class="fs-5">「はい」を選択すると、予約を中止しHOME画面に戻ります。</p>
				<p class="fs-5">再度予約する場合はHOME画面の「予約にすすむ」ボタンより、手続きをしていただく必要があります。</p>
				<p class="fs-5">本当に中止してよろしいですか？</p>
			</div>
			<div class="modal-footer">
				<a
					class="btn btn-danger"
					{{-- href="{!! route('frontend.covid.booking.mypage.edit.destroy') !!}" --}}
					href="{!! route('frontend.covid.booking.home.index') !!}"
				>
					<span class="fw-bold">
						{!! __("lang.dictionary.is_yesno.1") !!}
					</span>
				</a>

				<button
					class="btn btn-secondary"
					type="button"
					data-bs-dismiss="modal"
				>
					<span class="fw-bold">
						{!! __("lang.dictionary.is_yesno.0") !!}
					</span>
				</button>
			</div>
		</div>
	</div>
</div>
<!-- /.moda -->
{!! Form::close() !!}
@endsection

{{-- css --}}
@section('css')
<style>

</style>
@stop

{{-- js --}}
@section('js')
<script>
$(function() {
	//
});
</script>
@stop
