@extends('frontend.layouts.sticky')

{{-- content --}}
@section('content')
{!! Form::open($form) !!}

<!-- section -->
<section class="mb-3">
	<div class="container">

		<div
			class="alert alert-primary mb-0"
			role="alert"
		>
			<h3 class="alert-heading text-center mb-3">
				接種会場のご案内
			</h3>
			<hr>
			<p class="lh-base mb-0">
				接種会場をご確認いただき、ご承諾いただいた上で「承諾する」ボタンをタップして次におすすみください。<br><br>
				<span class="fw-bold" style="font-size:110%;">
					なお、接種会場を変更することはできません。
				</span>
			</p>
		</div>

	</div>
</section>
<!-- /.section -->

<!-- section -->
<section class="mb-5">
	<div class="container">

		<div class="card border border-dark border-1 mb-3">
			<div class="card-body text-center">
				<dl class="mb-0">
					<dt class="fw-normal lead mb-2">
						接種会場
					</dt>
					<dd class="h2 fw-bold mb-0">
						平和台病院
					</dd>
				</dl>
			</div>
		</div>

	</div>
</section>
<!-- /.section -->

<!-- nav -->
<br><br>
<nav class="bar-bottom">
	<div class="d-grid gap-2 w-100">
		<div class="d-flex">
			<div class="flex-grow-1 me-2">
				<button
					class="btn btn-primary btn-lg border border-primary border-3 w-100"
					type="submit"
					name="action"
					value="store"
				>
					<span class="fw-bold">
						{!! __("lang.button.consent") !!}
					</span>
				</button>
			</div>
			<div>
				<a
					class="btn btn-outline-secondary btn-lg border border-secondary border-3"
					href="{!! route('frontend.covid.booking.agreement.index') !!}"
				>
					<span class="fw-bold">
						{!! __("lang.button.back") !!}
					</span>
				</a>
			</div>
		</div>
	</div>
</nav>
<!-- /.nav -->

{!! Form::close() !!}
@endsection

{{-- css --}}
@section('css')
<style>

</style>
@stop

{{-- js --}}
@section('js')
<script>
$(function() {
	//
});
</script>
@stop
