@extends('frontend.layouts.sticky')

{{-- content --}}
@section('content')
<!-- section -->
<section class="mb-3">
	<div class="container">

		<div
			class="alert alert-danger p-3"
			role="alert"
		>
			<h5 class="alert-heading text-center">
				<span class="me-0">
					<i class="fa-solid fa-triangle-exclamation fa-fw fa-lg"></i>
				</span>
				{!! __("lang.error.title") !!}
			</h5>
			<hr>

			{{-- alert --}}
			@if($errors->any())
				@foreach ($errors->all() as $error)
					<p class="fw-bold fs-6 mb-0">
						{!! $error !!}
					</p>
				@endforeach
			@endif
			{{-- /.alert --}}

		</div>
	</div>
</section>
<!-- /.section -->

<!-- nav -->
<br><br>
<nav class="bar-bottom">
	<div class="d-grid gap-2 w-100">
		<a
			class="btn btn-danger btn-lg"
			href="{!! route('frontend.covid.booking.personal.index') !!}"
		>
			<span class="fw-bold">
				{!! __("lang.button.back") !!}
			</span>
		</a>
	</div>
</nav>
<!-- /.nav -->
@endsection

{{-- css --}}
@section('css')
<style>

</style>
@stop

{{-- js --}}
@section('js')
<script>
$(function() {

	//
});
</script>
@stop
