@extends('frontend.layouts.sticky')

{{-- content --}}
@section('content')
{!! Form::open($form) !!}
{!! Form::hidden('booking[yy]', $yy) !!}
{!! Form::hidden('booking[mm]', $mm) !!}
{!! Form::hidden('booking[dd]', $dd) !!}
{!! Form::hidden('booking[hh]', $hh) !!}
{!! Form::hidden('booking[ii]', $ii) !!}
{!! Form::hidden('booking[mtb_vaccine_id]', $vaccine['mtb_vaccine_id']) !!}

<!-- section -->
<section class="mb-4">
	<div class="container">

		@include('frontend.layouts.components.progress')

		<div
			class="alert alert-primary mb-0 p-3"
			role="alert"
		>
			<h3 class="alert-heading text-center mb-3">
				接種希望日時
			</h3>
			<hr>
			<p class="fw-bold mb-0">
				前回接種日から３か月後の同日以降接種可能です。<br>
				例）前回接種日：2023年4月1日<br>
				　　接種希望日：2023年7月1日　接種可能
			</p>
		</div>
	</div>
</section>
<!-- /.section -->

<!-- section -->
<section class="mb-4">
	<div class="container">

		{{-- alert --}}
		@if($errors->any())
			<div class="alert alert-danger mb-3">
				<h5 class="alert-heading text-center">
					<span class="me-0">
						<i class="fa-solid fa-triangle-exclamation fa-fw fa-lg"></i>
					</span>
					{!! __("lang.error.title") !!}
				</h5>
				<hr>
				<ul class="mb-0 ps-3">
					@foreach ($errors->all() as $error)
						<li>
							{!! $error !!}
						</li>
					@endforeach
				</ul>
			</div>
		@endif
		{{-- /.alert --}}

		<!-- toolbar -->
		<div class="d-flex justify-content-center align-items-center mb-3">
			<span class="">
				@if($is_past)
					<span
						class=""
					>
						<i class="fa-solid fa-circle-chevron-left fa-fw fa-2x text-secondary"></i>
					</span>
				@else
					<a
						class=""
						href="{!! route('frontend.covid.booking.datetime.index', [
							$date['prev']['yy'],
							$date['prev']['mm'],
						]) !!}">
						<i class="fa-solid fa-circle-chevron-left fa-fw fa-2x"></i>
					</a>
				@endif
			</span>
			<h2 class="mx-2">
				{!! \Carbon\Carbon::create($yy, $mm, 1)->format(__("lang.date.yymm")) !!}
			</h2>
			<span class="">
				<a class="" href="{!! route('frontend.covid.booking.datetime.index', [$date['next']['yy'], $date['next']['mm']]) !!}">
					<i class="fa-solid fa-circle-chevron-right fa-fw fa-2x"></i>
				</a>
			</span>
		</div>

		<!-- toolbar -->
		<div class="mb-0">
			<div class="row g-2">

				@foreach($booking_list as $i => $value)
					@if($value['remain_numbers'] > 0)
						<div class="col-4">
							<a
								id="set-focus-{!! $i !!}"
								class="btn btn-outline-primary w-100 px-0 {!! ($i == $dd) ? 'active' : '' !!}"
								href="{!! route('frontend.covid.booking.datetime.index', [
									$yy,
									$mm,
									$i,
								]) !!}"
							>
								<span class="fw-bold fs-6">
									{!! \Carbon\Carbon::create(
										$yy,
										$mm,
										$i,
									)->isoFormat('D日（ddd）') !!}
								</span>
							</a>
						</div>
					@endif
				@endforeach
			</div>
		</div>
		<!-- /.toolbar -->

	</div>
</section>
<!-- /.section -->

<!-- section -->
<section class="mb-0">
	<div class="container">

		<div class="d-flex justify-content-center align-items-center mb-3">
			<h2>
				希望時間
			</h2>
		</div>

		{{--@if(!is_null($vaccine['vaccine_label']))
			<div class="alert alert-success text-center mb-3 py-2">
				<span class="fs-5 mb-0">
					ワクチン
					：
				</span>
				<span class="fw-bold fs-5 mb-0">
					{!! $vaccine['vaccine_label'] !!}
				</span>
			</div>
		@endif--}}

		@if($booking_list && $time_list)
			<div class="row g-2">
				@foreach($time_list as $key => $value)
					<div class="col-4">
						{!! Form::radio('time', '', '', [
							'class' => 'btn-check',
							'id' => "time{$i}-{$key}",
							'autocomplete' => 'off',
							'onclick' => "setTime({$value['hh']}, {$value['ii']})",
						]) !!}
						<label
							{{-- @if($value['remain_number'] == 0) --}}
							@if ($value['remain_number'] == 0 || $value['remain_number'] < 0 || \Carbon\Carbon::create($yy, $mm, $dd, $value['hh'], $value['ii'])->lte(\Carbon\Carbon::now()))
								class="btn btn-outline-secondary w-100 disabled"
							@else
								class="btn btn-outline-{!! ($value['remain_number'] > 5) ? 'primary border border-primary' : 'warning border border-warning' !!} border-2 w-100"
							@endif
							for="time{!! $i !!}-{!! $key !!}"
						>
							<span class="fs-5 fw-bold me-2">
								{!! \Carbon\Carbon::create(
									$yy,
									$mm,
									$dd,
									$value['hh'],
									$value['ii']
								)->format('H:i') !!}
							</span>
							<br>
							<span class="fw-bold fs-4">
								@if($value['remain_number'] == 0 || $value['remain_number'] < 0)
									×
								@elseif($value['remain_number'] > 5)
									○
								@else
									△
								@endif
							</span>
						</label>
					</div>
				@endforeach
			</div>
		@else
			<div
				class="alert alert-secondary text-center"
				role=""
			>
				<span class="fw-bold lead">
					予約できる時間帯はありません
				</span>
			</div>
		@endif

	</div>
</section>
<!-- /.section -->

<!-- nav -->
<br><br>
<nav class="bar-bottom">
	<div class="d-grid gap-2 w-100">
		<div class="d-flex">
			<div class="flex-grow-1 me-2">
				<button
					class="btn btn-primary btn-lg border border-primary border-3 w-100"
					type="submit"
					name="action"
					value="store"
				>
					<span class="fw-bold">
						{!! __("lang.button.next") !!}
					</span>
				</button>
			</div>
			<div>
				<a
					class="btn btn-outline-secondary btn-lg border border-secondary border-3"
					href="{!! route('frontend.covid.booking.vaccine.index') !!}"
				>
					<span class="fw-bold">
						{!! __("lang.button.back") !!}
					</span>
				</a>
			</div>
		</div>
	</div>
</nav>
<!-- /.nav -->

{!! Form::close() !!}
@endsection

{{-- css --}}
@section('css')
<style>

</style>
@stop

{{-- js --}}
@section('js')
<script>
$(function() {
	//
});

let setTime = (hh, ii) => {

	$('input:hidden[name="booking[hh]"]').val(hh);
	$('input:hidden[name="booking[ii]"]').val(ii);
};

// set focus
$(function() {
	const day = {!!$dd!!}
	day && $(`#set-focus-${day}`).focus();
});

</script>
@stop
