@extends('frontend.layouts.sticky')

{{-- content --}}
@section('content')
{!! Form::open($form) !!}

<!-- section -->
<section class="mb-4">
	<div class="container">

		@include('frontend.layouts.components.progress')

		<div
			class="alert alert-primary mb-0 p-3"
			role="alert"
		>
			<h3 class="alert-heading text-center">
				個人情報
			</h3>
			<hr>
			<p class="fw-bold mb-0">
				氏名（カタカナ）と携帯電話番号をご入力ください。<br>
				携帯電話番号宛てにご来院案内に関するショートメールが送信されますので、正確にご入力ください。
			</p>
		</div>
	</div>
</section>
<!-- /.section -->

<!-- section -->
<section class="mb-5">
	<div class="container">

		{{-- alert --}}
		@if($errors->any())
			<div class="alert alert-danger mb-3">
				<ul class="mb-0 ps-3">
					@foreach ($errors->all() as $error)
						<li>
							{!! $error !!}
						</li>
					@endforeach
				</ul>
			</div>
		@endif
		{{-- /.alert --}}

		<div class="section-title d-flex justify-content-center align-items-center mb-3">
			<h3>
				氏名（カタカナで入力）
			</h3>
			<span class="badge rounded-pill text-bg-danger ms-1">
				{!! __("lang.form.required") !!}
			</span>
		</div>
		<div class="mb-4">
			{{-- <label
				class="form-label"
				for=""
			>
				<span class="badge rounded-pill text-bg-danger me-2">
					{!! __("lang.form.required") !!}
				</span>
				<span class="fw-bold">
					氏名（カタカナで入力）
				</span>
			</label> --}}
			<div class="input-group input-group-lg">
				{!! Form::text('booking[patient_skana]', (\Session::get('booking.patient_skana') === null) ? '' : \Session::get('booking.patient_skana'), [
					'class' => 'form-control',
					'placeholder' => '例）ソウゾウ',
				]) !!}
				{!! Form::text('booking[patient_gkana]', (\Session::get('booking.patient_gkana') === null) ? '' : \Session::get('booking.patient_gkana'), [
					'class' => 'form-control',
					'placeholder' => '例）イチロウ',
				]) !!}
			</div>
		</div>

		<div class="section-title d-flex justify-content-center align-items-center mb-3">
			<h3>
				携帯電話番号（ハイフンなし）
			</h3>
			<span class="badge rounded-pill text-bg-danger ms-1">
				{!! __("lang.form.required") !!}
			</span>
		</div>
		<div class="mb-4">
			{{-- <label
				class="form-label"
				for=""
			>
				<span class="badge rounded-pill text-bg-danger me-2">
					{!! __("lang.form.required") !!}
				</span>
				<span class="fw-bold">
					携帯電話番号（ハイフンなし）
				</span>
			</label> --}}
			{!! Form::tel('booking[mobile]', (\Session::get('booking.mobile') === null) ? '' : \Session::get('booking.mobile'), [
				'class' => 'form-control form-control-lg fs-3',
				'placeholder' => '例）09012345678',
				'style' => 'letter-spacing: .3em;',
			]) !!}
		</div>
	</div>
</section>
<!-- /.section -->

<!-- nav -->
<br><br>
<nav class="bar-bottom">
	<div class="d-grid gap-2 w-100">
		<div class="d-flex">
			<div class="flex-grow-1 me-2">
				<button
					class="btn btn-primary btn-lg border border-primary border-3 w-100"
					type="submit"
					name="action"
					value="store"
				>
					<span class="fw-bold">
						{!! __("lang.button.confirm") !!}
					</span>
				</button>
			</div>
			<div>
				<a
					class="btn btn-outline-secondary btn-lg border border-secondary border-3"
					href="{!! route('frontend.covid.booking.qr.index') !!}"
				>
					<span class="fw-bold">
						{!! __("lang.button.back") !!}
					</span>
				</a>
			</div>
		</div>

		{{-- <div
			class="btn-group"
			role="group"
		>
			<a
				class="btn btn-outline-primary btn-lg border border-primary border-3 w-50"
				href="{!! route('frontend.covid.booking.qr.index') !!}"
			>
				<span class="fw-bold">
					{!! __("lang.button.back") !!}
				</span>
			</a>
			<button
				class="btn btn-primary btn-lg w-50"
				type="submit"
				name="action"
				value="store"
			>
				<span class="fw-bold">
					{!! __("lang.button.confirm") !!}
				</span>
			</button>
		</div> --}}
	</div>
</nav>
<!-- /.nav -->

{!! Form::close() !!}
@endsection

{{-- css --}}
@section('css')
<style>

</style>
@stop

{{-- js --}}
@section('js')
<script>
$(function() {
	//
});
</script>
@stop
