@extends('frontend.layouts.main')

{{-- content --}}
@section('content')
{!! Form::open($form) !!}
{!! Form::hidden('booking[booking_code]', $booking['booking_code']) !!}
{!! Form::hidden('booking[is_booked]', 1) !!}
{!! Form::hidden('booking[is_web]', 1) !!}
{!! Form::hidden('edited_booking[yy]', $edited_booking['yy']) !!}
{!! Form::hidden('edited_booking[mm]', $edited_booking['mm']) !!}
{!! Form::hidden('edited_booking[dd]', $edited_booking['dd']) !!}
{!! Form::hidden('edited_booking[hh]', $edited_booking['hh']) !!}
{!! Form::hidden('edited_booking[ii]', $edited_booking['ii']) !!}
{!! Form::hidden('edited_booking[mtb_vaccine_id]', $edited_booking['mtb_vaccine_id']) !!}

@include('frontend.layouts.components.guest')

<!-- section -->
<section class="mb-5">
    <div class="container">

        <article class="text-center mt-2">
            <svg width="116px" height="116px" viewBox="0 0 116 116" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
                <g id="Page-1" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                    <g transform="translate(-122.000000, -113.000000)">
                        <g id="check" transform="translate(122.000000, 113.000000)">
                            <circle fill="#CEFFCF" cx="58" cy="58" r="58"></circle>
                            <circle fill="#00D803" cx="58" cy="58" r="44"></circle>
                            <g transform="translate(45.000000, 47.000000)" fill="#FFFFFF">
                                <path d="M8.625,17.325 L2.9375,11.6375 C2.30375,11.00375 1.29625,11.00375 0.6625,11.6375 C0.02875,12.27125 0.02875,13.27875 0.6625,13.9125 L7.47125,20.72125 C8.105,21.355 9.12875,21.355 9.7625,20.72125 L26.9875,3.5125 C27.62125,2.87875 27.62125,1.87125 26.9875,1.2375 C26.35375,0.60375 25.34625,0.60375 24.7125,1.2375 L8.625,17.325 Z"></path>
                            </g>
                        </g>
                    </g>
                </g>
            </svg>
            <br><br>
            <h2 class="text-success mb-4">
                日時変更は可能です
            </h2>
			<div
				class="alert alert-success text-center p-3"
				role="alert"
			>
				<p class="fs-5 my-0">
                        変更後
				</p>
                @if(!is_null($vaccine['vaccine_label']))
                    <p class="fw-bold fs-2 mb-0">
                        {!! $vaccine['vaccine_label'] !!}
                    </p>
                @endif
				<p class="fw-bold fs-2 mb-0">
                    {!! \Carbon\Carbon::create(
                        $edited_booking['yy'],
                        $edited_booking['mm'],
                        $edited_booking['dd'])
                        ->isoFormat('YYYY年MM月DD日（ddd）') !!}
                    {!! \Carbon\Carbon::create(
                        $edited_booking['yy'],
                        $edited_booking['mm'],
                        $edited_booking['dd'],
                        $edited_booking['hh'],
                        $edited_booking['ii'],
                    )->format(__('lang.date.hhii')) !!}
				</p>
			</div>
        </article>

    </div>
</section>
<!-- /.section -->

<!-- nav -->
<br><br>
<nav class="bar-bottom">
    <div class="d-grid gap-2 w-100">
        <div class="d-flex">
            <div class="flex-grow-1 me-2">
                <button
                    class="btn btn-success btn-lg border border-success border-3 w-100"
                    type="submit"
                    name="action"
                    value="store"
                >
                    <span class="fw-bold">
                        この日時で変更
                    </span>
                </button>
            </div>
            <div>
                <a
                    class="btn btn-outline-secondary btn-lg border border-secondary border-3"
                    href="{!! route('frontend.covid.booking.mypage.edit.update', [
                        $edited_booking['yy'],
                        $edited_booking['mm'],
                        $edited_booking['dd'],
                        $edited_booking['hh'],
                        $edited_booking['ii'],
                    ]) !!}">
                    <span class="fw-bold">
                        {!! __("lang.button.back") !!}
                    </span>
                </a>
            </div>
        </div>
    </div>
</nav>
<!-- /.nav -->

{!! Form::close() !!}
@endsection

{{-- css --}}
@section('css')
<style>

</style>
@stop

{{-- js --}}
@section('js')
<script>
    $(function() {
        //
    });
</script>
@stop
