@extends('frontend.layouts.main')

{{-- content --}}
@section('content')
{!! Form::open($form) !!}
{!! Form::hidden('booking[booking_code]', $booking['booking_code']) !!}
{!! Form::hidden('booking[yy]', $booking['yy']) !!}
{!! Form::hidden('booking[mm]', $booking['mm']) !!}
{!! Form::hidden('booking[dd]', $booking['dd']) !!}
{!! Form::hidden('booking[hh]', $booking['hh']) !!}
{!! Form::hidden('booking[ii]', $booking['ii']) !!}
{!! Form::hidden('booking[mtb_vaccine_id]', $booking['mtb_vaccine_id']) !!}

@include('frontend.layouts.components.guest')

<!-- section -->
<section class="mb-4">
	<div class="container">

		<!-- alert -->
		<div class="alert alert-danger text-center" role="alert">
			<span class="fw-bold fs-5">
				予約を取り消します。<br>
				本当によろしいですか？
			</span>
		</div>
		<!-- /.alert -->

		<div class="btn-group btn-group-lg w-100" role="group">
			<button
				class="btn btn-danger"
				type="submit"
				name="action"
				value="destroy"
			>
				<span class="fw-bold">
					{!! __("lang.dictionary.is_yesno.1") !!}
				</span>
			</button>
			<a
				class="btn btn-outline-danger"
				href="{!! route('frontend.covid.booking.mypage.guest.show') !!}"
            >
				<span class="fw-bold">
					{!! __("lang.dictionary.is_yesno.0") !!}
				</span>
			</a>
		</div>

	</div>
</section>
<!-- /.section -->

<!-- section -->
<section class="mb-4">
	<div class="container">
		<ul class="list-group list-group-flush">
			<li class="list-group-item d-flex justify-content-between align-items-center py-3">
				<div class="">
					<span class="fw-bold">
						接種券番号
					</span>
				</div>
				<div class="ms-auto">
					{!! $booking['voucher_number'] !!}
				</div>
			</li>
			<li class="list-group-item d-flex justify-content-between align-items-center py-3">
				<div class="">
					<span class="fw-bold">
						氏名カナ
					</span>
				</div>
				<div class="ms-auto">
					{!! implode(' ', [
						$booking['patient_skana'],
						$booking['patient_gkana'],
					]) !!}
				</div>
			</li>
			<li class="list-group-item d-flex justify-content-between align-items-center py-3">
				<div class="">
					<span class="fw-bold">
						携帯電話番号
					</span>
				</div>
				<div class="ms-auto">
					{!! $booking['mobile'] !!}
				</div>
			</li>
			<li class="list-group-item d-flex justify-content-between align-items-center py-3">
				<div class="">
					<span class="fw-bold">
						生年月日
					</span>
				</div>
				<div class="ms-auto">
					{!! \Carbon\Carbon::create($booking['birthday'])->isoFormat('YYYY年M月D日') !!}
				</div>
			</li>
			<li class="list-group-item d-flex justify-content-between align-items-center py-3">
				<div class="">
					<span class="fw-bold">
						前回接種日
					</span>
				</div>
				<div class="ms-auto">
					{!! \Carbon\Carbon::create($booking['date_last'])->isoFormat('YYYY年M月D日') !!}
				</div>
			</li>
			<li class="list-group-item d-flex justify-content-between align-items-center py-3">
				<div class="">
					<span class="fw-bold">
						今回接種回数
					</span>
				</div>
				<div class="ms-auto">
					{!! $booking['shots_number'] !!}回目
				</div>
			</li>
		</ul>
	</div>
</section>
<!-- /.section -->

{!! Form::close() !!}
@endsection

{{-- css --}}
@section('css')
<style>

</style>
@stop

{{-- js --}}
@section('js')
<script>
	$(function() {
		//
	});
</script>
@stop
