@extends('frontend.layouts.main')

{{-- content --}}
@section('content')
{!! Form::open($form) !!}
{!! Form::hidden('booking[yy]', $yy) !!}
{!! Form::hidden('booking[mm]', $mm) !!}
{!! Form::hidden('booking[dd]', $dd) !!}
{!! Form::hidden('booking[hh]', $hh) !!}
{!! Form::hidden('booking[ii]', $ii) !!}
{!! Form::hidden('booking[mtb_vaccine_id]', $vaccine['mtb_vaccine_id']) !!}

@include('frontend.layouts.components.guest')

<!-- section -->
<section class="mb-2">
	<div class="container">

		<!-- alert -->
		<div
			class="alert alert-primary mb-0 p-3"
			role="alert"
		>
			<h3 class="alert-heading text-center mb-3">
				接種希望日時
			</h3>
			<hr>
			<p class="fw-bold mb-0">
				前回接種日から３か月後の同日以降接種可能です。<br>
				例）前回接種日：2023年4月1日<br>
				　　接種希望日：2023年7月1日　接種可能
			</p>
		</div>
		<!-- /.alert -->

	</div>
</section>
<!-- /.section -->

<!-- section -->
<section class="mb-3">
	<div class="container">

		{{-- alert --}}
		@if($errors->any())
			<div class="alert alert-danger mb-0">
				<h5 class="alert-heading text-center">
					<span class="me-0">
						<i class="fa-solid fa-triangle-exclamation fa-fw fa-lg"></i>
					</span>
					{!! __("lang.error.title") !!}
				</h5>
				<hr>
				<ul class="mb-0 ps-3">
					@foreach ($errors->all() as $error)
						<li>
							{!! $error !!}
						</li>
					@endforeach
				</ul>
			</div>
		@endif
		{{-- /.alert --}}

	</div>
</section>
<!-- /.section -->

<!-- section -->
<section class="mb-5">
	<div class="container">

		<!-- toolbar -->
		<div class="d-flex justify-content-center align-items-center mb-4">
			<span class="">
				@if($is_past)
					<span
						class=""
					>
						<i class="fa-solid fa-circle-chevron-left fa-fw fa-2x text-secondary"></i>
					</span>
				@else
					<a
						class=""
						href="{!! route('frontend.covid.booking.mypage.booking.update', [
							$date['prev']['yy'],
							$date['prev']['mm'],
						]) !!}"
					>
						<i class="fa-solid fa-circle-chevron-left fa-fw fa-2x"></i>
					</a>
				@endif
			</span>
			<h2 class="mx-2">
				{!! \Carbon\Carbon::create($yy, $mm, 1)->format(__("lang.date.yymm")) !!}
			</h2>
			<span class="">
				<a
					class=""
					href="{!! route('frontend.covid.booking.mypage.booking.update', [
						$date['next']['yy'],
						$date['next']['mm'],
					]) !!}"
				>
					<i class="fa-solid fa-circle-chevron-right fa-fw fa-2x"></i>
				</a>
			</span>
		</div>
		<!-- /.toolbar -->

		<!-- toolbar -->
		<div class="mb-3">
			<div class="row g-2">

				@foreach($booking_list as $i => $value)
					@if($value['remain_numbers'] > 0)
						<div class="col-4">
							<a
								id="set-focus-{!! $i !!}"
								class="btn btn-outline-primary w-100 px-0 {!! ($i == $dd) ? 'active' : '' !!}"
								href="{!! route('frontend.covid.booking.mypage.booking.update', [
									$yy,
									$mm,
									$i,
								]) !!}"
							>
								<span class="fw-bold fs-6">
									{!! \Carbon\Carbon::create(
										$yy,
										$mm,
										$i,
									)->isoFormat('D日（ddd）') !!}
								</span>
							</a>
						</div>
					@endif
				@endforeach
			</div>
		</div>
		<!-- /.toolbar -->

		@if($booking_list && $time_list)
			<div class="row g-2">
				@foreach($time_list as $key => $value)
					<div class="col-4">
						{!! Form::radio('time', '', '', [
							'class' => 'btn-check',
							'id' => "time{$i}-{$key}",
							'autocomplete' => 'off',
							'onclick' => "setTime({$value['hh']}, {$value['ii']})",
						]) !!}
						<label
							{{-- @if($value['remain_number'] == 0) --}}
							@if ($value['remain_number'] == 0 || $value['remain_number'] < 0 || \Carbon\Carbon::create($yy, $mm, $dd, $value['hh'], $value['ii'])->lte(\Carbon\Carbon::now()))
								class="btn btn-outline-secondary w-100 disabled"
							@else
								class="btn btn-outline-{!! ($value['remain_number'] > 5) ? 'primary border border-primary' : 'warning border border-warning' !!} border-2 w-100 px-0"
							@endif
							for="time{!! $i !!}-{!! $key !!}"
						>
							<span class="fw-bold fs-6 me-2">
								@if($value['remain_number'] == 0 || $value['remain_number'] < 0)
									×
								@elseif($value['remain_number'] > 5)
									○
								@else
									△
								@endif
							</span>
							<span class="fs-6 fw-bold">
								{!! \Carbon\Carbon::create(
									$yy,
									$mm,
									$dd,
									$value['hh'],
									$value['ii']
								)->format('H:i') !!}
							</span>
						</label>
					</div>
				@endforeach
			</div>
		@else
			<div
				class="alert alert-secondary text-center"
				role=""
			>
				<span class="fw-bold lead">
					予約できる時間帯はありません
				</span>
			</div>
		@endif

	</div>
</section>
<!-- /.section -->

<!-- nav -->
<br><br>
<nav class="bar-bottom">
	<div class="d-grid gap-2 w-100">
		<div class="d-flex">
			<div class="flex-grow-1 me-2">
				<button
					class="btn btn-primary btn-lg border border-primary border-3 w-100"
					id="btn-update"
					type="submit"
					name="action"
					value="store"
				>
					<span class="fw-bold">
						この日程で確定する
					</span>
				</button>
			</div>
			<div>
				<a class="btn btn-outline-secondary btn-lg border border-secondary border-3"
					href="{!! route('frontend.covid.booking.mypage.vaccine.index') !!}">
					<span class="fw-bold">
						{!! __("lang.button.back") !!}
					</span>
				</a>
			</div>
		</div>
	</div>
</nav>
<!-- /.nav -->
{!! Form::close() !!}
@endsection

{{-- css --}}
@section('css')
<style>

</style>
@stop

{{-- js --}}
@section('js')
<script>
$(function() {

	$('#btn-update').click(function() {
		//alert('here');return false;

		if(confirm("予約日をご指定日時で変更します。\nよろしいですか？")) {
			return true;
		}

		return false;
	});
});

let setTime = (hh, ii) => {
	$('input:hidden[name="booking[hh]"]').val(hh);
	$('input:hidden[name="booking[ii]"]').val(ii);
};

// set focus
$(function() {
	const day = {!!$dd!!}
	day && $(`#set-focus-${day}`).focus();
});
</script>
@stop
