@extends('frontend.layouts.main')

{{-- content --}}
@section('content')
@include('frontend.layouts.components.guest')

<!-- section -->
<section class="mb-4">
	<div class="container">

		<ul class="row g-2">
			<li class="col">
				<a
					class="item-category-grid"
					href="{!! route('frontend.covid.booking.mypage.qr.index', [
						$booking['yy'],
						$booking['mm'],
						$booking['dd'],
						$booking['signin_code'],
						]) !!}"
				>
					<div class="icon-wrap mb-2">
						<i class="fa-solid fa-qrcode fa-fw fa-2x"></i>
					</div>
					<div class="fw-bold text text-primary">
						QRコード
					</div>
				</a>
			</li>
			<li class="col">
				<a
					class="item-category-grid"
					href="{!! route('frontend.covid.booking.mypage.vaccine.index') !!}"
				>
					<div class="icon-wrap mb-2">
						<i class="fa-solid fa-pen-to-square fa-fw fa-2x"></i>
					</div>
					<div class="fw-bold text text-primary">
						予約変更
					</div>
				</a>
			</li>
			<li class="col">
				<a
					class="item-category-grid"
					href="{!! route('frontend.covid.booking.mypage.booking.destroy') !!}"
				>
					<div class="icon-wrap mb-2">
						<i class="fa-solid fa-ban fa-fw fa-2x"></i>
					</div>
					<div class="fw-bold text text-primary">
						キャンセル
					</div>
				</a>
			</li>
		</ul>
	</div>
</section>
<!-- /.section -->

<!-- section -->
<section class="mb-4">
	<div class="container">
		<ul class="list-group list-group-flush">
			<li class="list-group-item d-flex justify-content-between align-items-center py-3">
				<div class="">
					<span class="fw-bold">
						接種券番号
					</span>
				</div>
				<div class="ms-auto">
					{!! $booking['voucher_number'] !!}
				</div>
			</li>
			<li class="list-group-item d-flex justify-content-between align-items-center py-3">
				<div class="">
					<span class="fw-bold">
						氏名カナ
					</span>
				</div>
				<div class="ms-auto">
					{!! implode(' ', [
                        $booking['patient_skana'],
                        $booking['patient_gkana'],
                    ]) !!}
				</div>
			</li>
			<li class="list-group-item d-flex justify-content-between align-items-center py-3">
				<div class="">
					<span class="fw-bold">
						携帯電話番号
					</span>
				</div>
				<div class="ms-auto">
					{!! $booking['mobile'] !!}
				</div>
			</li>
			<li class="list-group-item d-flex justify-content-between align-items-center py-3">
				<div class="">
					<span class="fw-bold">
						生年月日
					</span>
				</div>
				<div class="ms-auto">
					{!! \Carbon\Carbon::create($booking['birthday'])->isoFormat('YYYY年M月D日') !!}
				</div>
			</li>
			<li class="list-group-item d-flex justify-content-between align-items-center py-3">
				<div class="">
					<span class="fw-bold">
						前回接種日
					</span>
				</div>
				<div class="ms-auto">
					{!! \Carbon\Carbon::create($booking['date_last'])->isoFormat('YYYY年M月D日') !!}
				</div>
			</li>
			<li class="list-group-item d-flex justify-content-between align-items-center py-3">
				<div class="">
					<span class="fw-bold">
						今回接種回数
					</span>
				</div>
				<div class="ms-auto">
					{!! $booking['shots_number'] !!}回目
				</div>
			</li>
		</ul>
	</div>
</section>
<!-- /.section -->

<!-- nav -->
{{--<br><br>
<nav class="bar-bottom">
	<div class="d-grid gap-2 w-100">
		<a
			class="btn btn-outline-secondary btn-lg border border-secondary border-3"
			href="{!! route('frontend.covid.booking.mypage.signin.destroy') !!}"
		>
			<span class="fw-bold">
				{!! __("lang.button.signout") !!}
			</span>
		</a>
	</div>
</nav>--}}
<!-- /.nav -->
@endsection

{{-- css --}}
@section('css')
<style>

</style>
@stop

{{-- js --}}
@section('js')
<script>
	$(function() {
		//
	});
</script>
@stop
