@extends('frontend.layouts.sticky')

{{-- content --}}
@section('content')

<!-- section -->
<section class="mb-4">
	<div class="container">

		<div
			class="alert alert-primary"
			role="alert"
		>
			<h4 class="alert-heading text-center">
				受付QRコード
			</h4>
			<hr>
			<p class="fw-bold text-center mb-0">
				来院時、受付に設置してある<br>
				QRコードリーダーにかざしてください
			</p>
		</div>

	</div>
</section>
<!-- /.section -->

<!-- section -->
<section class="mb-5">
	<div class="container">

		<div class="text-center">
			@isset($booking['voucher_number'])
				{!! QrCode::size(260)->generate($booking['voucher_number']) !!}
				{{-- {!! QrCode::format('png')->size(600)->generate($booking['voucher_number']) !!} --}}
			@else
			<div class="alert alert-danger text-center">
				<p class="fw-bold lead mb-0">
					<span class="">
						<i class="fa-solid fa-circle-exclamation fa-fw fa-lg"></i>
					</span>
					予約情報が存在しません
				</p>
			</div>
		</div>
		@endisset

	</div>
</section>
<!-- /.section -->

@endsection

{{-- css --}}
@section('css')
<style>

</style>
@stop

{{-- js --}}
@section('js')
<script>
$(function() {
	//
});
</script>
@stop
