@extends('frontend.layouts.main')

{{-- content --}}
@section('content')
<!-- section -->
<section class="mb-4">
	<div class="container">
		<div
			class="progress mb-3"
			role="progressbar"
			aria-label="Default striped example"
			aria-valuenow="60"
			aria-valuemin="0"
			aria-valuemax="100"
		>
			<div class="progress-bar progress-bar-striped" style="width: 60%"></div>
		</div>
		<div
			class="alert alert-primary p-3"
			role="alert"
		>
			<h3 class="alert-heading text-center mb-3">
				接種券番号
			</h3>
			<p class="mb-0">
				まず、お手持ちの接種券にQRコードが掲載されていることをご確認ください。<br>
				次に、下記の「QRコードを読み取る」ボタンをクリックしてカメラアプリを起動し、QRコードを読み取ってください。<br>
			</p>
		</div>
	</div>
</section>
<!-- /.section -->

<!-- section -->
<section class="mb-5">
	<div class="container">

		<div class="mb-4">
			<div>
				<label
					class="btn btn-primary btn-lg w-100 py-2"
					for="camera"
				>
					<span class="me-1">
						<i class="fa-solid fa-camera fa-fw fa-lg"></i>
					</span>
					<span class="fw-bold">
						QRコードを読み取る
					</span>
				</label>
				{!! Form::file('camera', [
					'class' => 'd-none',
					'id' => 'camera',
					'accept' => 'image/*',
					'capture' => 'camera',
				]) !!}
			</div>
		</div>
		<div class="mb-3">
			<label
				class="form-label"
				for=""
			>
				<span class="badge rounded-pill text-bg-danger me-2">
					{!! __("lang.form.required") !!}
				</span>
				<span class="fw-bold">
					接種券番号
				</span>
			</label>
			{!! Form::number('', '', [
				'class' => 'form-control form-control-lg',
			]) !!}
		</div>

		<!-- alert -->
		<div
			class="alert alert-danger"
			role="alert"
		>
			<h3 class="alert-heading text-center mb-3">
				<span class="me-1">
					<i class="fa-solid fa-triangle-exclamation fa-fw fa-lg"></i>
				</span>
				QRコードが読み取れない場合
			</h3>
			<p class="mb-0">
				カメラアプリでQRコードが読み取れない場合は、お手数ですが接種券番号を直接ご入力ください。<br>
                接種券番号をお間違いのない様にお願いします。
			</p>
		</div>
		<!-- /.alert -->

		{{-- <div class="alert alert-warning">
			<h4 class="alert-heading text-center mb-3">
				<span class="me-1">
					<i class="fa-brands fa-android fa-fw fa-lg"></i>
				</span>
				Androidユーザの方へ
			</h4>
			<p class="mb-0">
				Androidスマホの機種によっては「カメラアプリを起動する」ボタンをタップしてもカメラアプリが起動しないことがあります。<br>
				その場合は下記方法にてご対応をお願いします。
			</p>
			<ol class="mt-2 mb-0 ps-3">
				<li>
					HOME画面からカメラアプリを起動し、接種券を撮影します<br>
					<span class="fw-bold">※必ず接種券番号が記載されている箇所を撮影してください</span>
				</li>
				<li>
					「カメラアプリを起動する」ボタンをタップします
				</li>
				<li>
					撮影写真一覧が表示されますので、対象写真を指定します
				</li>
			</ol>
		</div> --}}

	</div>
</section>
<!-- /.section -->

<!-- nav -->
<br><br>
<nav class="bar-bottom">
	<div class="d-grid gap-2 w-100">
		<button
			class="btn btn-primary btn-lg w-100"
			type="submit"
			name="action"
			value="store"
		>
			<span class="fw-bold">
				{!! __("lang.button.next") !!}
			</span>
		</button>
	</div>
</nav>
<!-- /.nav -->
@endsection

{{-- css --}}
@section('css')

@stop

{{-- js --}}
@section('js')
<!-- jquery -->
<script
    src="{!! implode('/', [
        asset('vendors'),
        'jsQR',
        'jsQR.js',
    ]) !!}"
></script>
$(function(){


});
</script>
@stop
