@extends('frontend.layouts.sticky')

{{-- content --}}
@section('content')
{!! Form::open($form) !!}

<!-- section -->
<section class="mb-0">
	<div class="container">

		@include('frontend.layouts.components.progress')

		<div
			class="alert alert-primary p-3"
			role="alert"
		>
			{{-- <h3 class="alert-heading text-center">
				接種券番号
			</h3>
			<hr> --}}
			<p class="fw-bold mb-0">
				カメラアクセスを許可して、QRコードを読み取ってください。
				読み取れない場合はお手数ですが、接種券番号を直接ご入力ください。
			</p>
		</div>
	</div>
</section>
<!-- /.section -->

<!-- section -->
<section class="mb-5">
	<div class="container">

		{{-- alert --}}
		@if($errors->any())
			<div class="alert alert-danger mb-3">
				<h5 class="alert-heading text-center">
					<span class="me-0">
						<i class="fa-solid fa-triangle-exclamation fa-fw fa-lg"></i>
					</span>
					{!! __("lang.error.title") !!}
				</h5>
				<hr>
				<ul class="fw-bold mb-0 ps-3">
					@foreach ($errors->all() as $error)
						<li>
							{!! $error !!}
						</li>
					@endforeach
				</ul>
			</div>
		@endif
		{{-- /.alert --}}

		<div class="text-center bg-black mb-3 pt-3 pb-2">
			<canvas id="preview"></canvas>
		</div>

		<div class="input-group mb-3">
			<span class="input-group-text fw-bold">
				接種券番号
			</span>
			{!! Form::text('booking[voucher_number]', '', [
				'class' => 'form-control form-control-lg fw-bold',
				'id' => 'voucher',
				'maxlength' => 10,
				'minlength' => 10,
				'style' => 'font-size:1.4rem;',
			]) !!}
			{!! Form::hidden('booking[qr_number]', '', [
				'id' => 'qr',
			]) !!}
		</div>

		<div class="d-grid gap-2 mb-3">
			<button
				class="btn btn-light border border-secondary border-2 py-2"
				type="button"
				data-bs-toggle="modal"
				data-bs-target="#modal1"
			>
				<span class="fw-bold text-dark">
					カメラアクセス許可方法はこちら
				</span>
			</button>
		</div>

		<div
			class="alert alert-danger text-center mb-0 px-1 invisible"
			id="alert"
			role="alert"
		>
			<div class="mb-3">
				<i class="fa-solid fa-circle-exclamation fa-fw fa-3x"></i>
			</div>
			<p
				class="fw-bold mb-0"
				style="font-size:1.1rem;"
			>
				読み取った接種券番号をご確認ください<br>
				お間違いなければ次へおすすみください
			</p>
		</div>
	</div>
</section>
<!-- /.section -->

<!-- nav -->
<br><br>
<nav class="bar-bottom">
	<div class="d-grid gap-2 w-100">
		<div class="d-flex">
			<div class="flex-grow-1 me-2">
				<button
					class="btn btn-primary btn-lg border border-primary border-3 w-100"
					type="submit"
					name="action"
					value="store"
				>
					<span class="fw-bold">
						{!! __("lang.button.next") !!}
					</span>
				</button>
			</div>
			<div>
				<a
					class="btn btn-outline-secondary btn-lg border border-secondary border-3"
					href="{!! route('frontend.covid.booking.qr.index') !!}"
				>
					<span class="fw-bold">
						取り直す
					</span>
				</a>
			</div>
		</div>
	</div>
</nav>
<!-- /.nav -->

<!-- modal1 -->
<div
	class="modal fade"
	id="modal1"
	data-bs-backdrop="static"
	data-bs-keyboard="false"
	tabindex="-1"
	aria-hidden="true"
>
	<div class="modal-dialog modal-dialog-scrollable">
		<div class="modal-content">
			<div class="modal-header">
				<h1 class="modal-title fs-5">
					許可方法
				</h1>
				<button
					type="button"
					class="btn-close"
					data-bs-dismiss="modal"
					aria-label="Close"
				></button>
			</div>
			<div class="modal-body">
				<dl class="mb-5">
					<dt class="fw-bold fs-5 mb-2">
						iPhone・iPadをご利用の場合
					</dt>
					<dd>
						<ol class="fs-6 ps-3">
							<li>
								『設定』をタップします
							</li>
							<li>
								下へスクロールし、『Safari』をタップします
							</li>
							<li>
								一番下へスクロールし、『カメラ』をタップします
							</li>
							<li>
								『確認』をタップ、またはすでにチェックされている事を確認します
							</li>
						</ol>
					</dd>
				</dl>

				<dl class="">
					<dt class="fw-bold fs-5 mb-2">
						Androidをご利用の場合
					</dt>
					<dd>

					</dd>
				</dl>
			</div>
			<div class="modal-footer">
				<button
					class="btn btn-secondary"
					type="button"
					data-bs-dismiss="modal"
				>
					<span class="fw-bold">
						{!! __("lang.button.close") !!}
					</span>
				</button>
			</div>
		</div>
	</div>
</div>
<!-- /.modal1 -->

{!! Form::close() !!}
@endsection

{{-- css --}}
@section('css')
<style>

</style>
@stop

{{-- js --}}
@section('js')
<!-- jsQR -->
<script
	src="{!! implode('/', [
		asset('vendors'),
		'jsQR',
		'jsQR.js',
	]) !!}"
></script>

<script
	src="{!! implode('/', [
		asset('templates'),
		'mobile',
		'js',
		"qr.js",
	]) !!}?timestamp={!! date('YmdHis') !!}"
></script>

<script>
$(function() {
	//
});

let Scan = () => {

	//選択された幅高さ
	w = video.videoWidth;
	h = video.videoHeight;

	//画面上の表示サイズ
	prev.style.width = (w/2) + "px";
	prev.style.height = (h/2) + "px";

	//内部のサイズ
	prev.setAttribute("width", w);
	prev.setAttribute("height", h);
	if(w > h){ m = h * 0.6; } else { m = w * 0.6; }

	x1 = (w - m) / 2;
	y1 = (h - m) / 2;
	prev_ctx.drawImage(video, 0, 0, w, h);
	prev_ctx.beginPath();
	prev_ctx.strokeStyle = "rgb(255, 255, 0)";
	prev_ctx.lineWidth = 6;
	prev_ctx.rect(x1, y1, m, m);
	prev_ctx.stroke();

	canvas.setAttribute("width", m);
	canvas.setAttribute("height", m);
	canvas_ctx.drawImage(prev, x1, y1, m, m, 0, 0, m, m);

	let imageData = canvas_ctx.getImageData(0, 0, m, m);
	let scanResult = jsQR(imageData.data, m, m);

	if(scanResult) {

		let string = scanResult.data;

		voucher.value = string.substring(string.length - 10);
		qr.value = string;

		const position = $('#voucher').offset().top;
		$("html,body").animate({scrollTop:position}, 400);

		$('#alert').removeClass('invisible');
		$('#alert').addClass('visible');

		return false;
	}

	setTimeout(Scan, 200);
};

let substrRight = (string, n) => {
	return string.substr(string.length - n - 1, 1);
};
</script>
@stop
