@extends('frontend.layouts.sticky')

{{-- content --}}
@section('content')
{!! Form::open($form) !!}

<!-- section -->
<section class="mb-4">
	<div class="container">

		@include('frontend.layouts.components.progress')

		<div
			class="alert alert-primary mb-0 p-3"
			role="alert"
		>
			<h3 class="alert-heading text-center">
				前回接種日・今回接種回数
			</h3>
			<hr>
			<p class="fw-bold mb-0">
				前回接種日と今回接種回数を入力してください。<br>
				前回接種日は接種券に記載されています。
			</p>
		</div>
	</div>
</section>
<!-- /.section -->

<!-- section -->
<section class="mb-4">
	<div class="container">

		{{-- alert --}}
		@if($errors->any())
			<div class="alert alert-danger mb-3">
				<h5 class="alert-heading text-center">
					<span class="me-0">
						<i class="fa-solid fa-triangle-exclamation fa-fw fa-lg"></i>
					</span>
					{!! __("lang.error.title") !!}
				</h5>
				<hr>
				<ul class="mb-0 ps-3">
					@foreach ($errors->all() as $error)
						<li>
							{!! $error !!}
						</li>
					@endforeach
				</ul>
			</div>
		@endif
		{{-- /.alert --}}

		<div class="section-title text-center mb-3">
			<h3>
				前回接種日
			</h3>
		</div>
		<div class="mb-0">
			<div class="input-group input-group-lg">
				{!! Form::select('date_last[yy]', $date_list['year_list'], (\Session::get('date_last') === null) ? '' : \Session::get('date_last.yy'), [
					'class' => 'form-select',
					'style' => 'width:30%;',
				]) !!}
				{!! Form::select('date_last[mm]', $date_list['month_list'], (\Session::get('date_last') === null) ? '' : \Session::get('date_last.mm'), [
					'class' => 'form-select',
				]) !!}
				{!! Form::select('date_last[dd]', $date_list['day_list'], (\Session::get('date_last') === null) ? '' : \Session::get('date_last.dd'), [
					'class' => 'form-select',
				]) !!}
			</div>
			<div class="input-group input-group-lg mb-2">

			</div>
			<div class="input-group input-group-lg">

			</div>
		</div>

	</div>
</section>
<!-- /.section -->

<!-- section -->
<section class="mb-3">
	<div class="container">

		<div class="section-title text-center mb-3">
			<h3>
				今回接種回数
			</h3>
		</div>

		@for($i = $numbers['from']; $i <= $numbers['to']; $i++)
			<div class="mb-2">
				{!! Form::radio('booking[shots_number]', $i, ((\Session::get('booking.shots_number') === null)) ? (($i == 3) ? true : false) : (($i == \Session::get('booking.shots_number')) ? true : false), [
					'class' => 'btn-check',
					'id' => "shots_number{$i}",
					'autocomplete' => 'off',
				]) !!}
				<label
					class="btn btn-outline-primary w-100"
					for="shots_number{!! $i !!}"
				>
					<span class="fs-4 fw-bold">
						{!! $i !!}回目
					</span>
				</label>
			</div>
		@endfor

	</div>
</section>
<!-- /.section -->

<!-- nav -->
<br><br>
<nav class="bar-bottom">
	<div class="d-grid gap-2 w-100">
		<div class="d-flex">
			<div class="flex-grow-1 me-2">
				<button
					class="btn btn-primary btn-lg border border-primary border-3 w-100"
					type="submit"
					name="action"
					value="store"
				>
					<span class="fw-bold">
						{!! __("lang.button.next") !!}
					</span>
				</button>
			</div>
			<div>
				<a
					class="btn btn-outline-secondary btn-lg border border-secondary border-3"
					{{-- href="{!! route('frontend.covid.booking.consent.index') !!}" --}}
					href="{!! route('frontend.covid.booking.personal.index') !!}"
				>
					<span class="fw-bold">
						{!! __("lang.button.back") !!}
					</span>
				</a>
			</div>
		</div>
	</div>
</nav>
<!-- /.nav -->

{!! Form::close() !!}
@endsection

{{-- css --}}
@section('css')
<style>

</style>
@stop

{{-- js --}}
@section('js')
<script>
$(function() {

	//
});
</script>
@stop
