@extends('frontend.layouts.sticky')

{{-- content --}}
@section('content')
{!! Form::open($form) !!}
{!! Form::hidden('booking[booking_code]', session()->get('booking.booking_code')) !!}
{!! Form::hidden('booking[is_booked]', 1) !!}
{!! Form::hidden('booking[is_web]', 1) !!}

<!-- section -->
<section class="mb-3">
	<div class="container">

		@include('frontend.layouts.components.progress')

		<div
			class="alert alert-primary mb-0"
			role=""
		>
			<h3 class="alert-heading text-center mb-3">
				入力内容の確認
			</h3>
			<hr>
			<p class="fw-bold mb-0">
				入力内容をご確認ください。<br>
				この内容でよろしければ、「予約を確定する」ボタンをタップしてください。
			</p>
		</div>
	</div>
</section>
<!-- /.section -->

<!-- section -->
<section class="mb-3">
	<div class="container">

		<div
			class="alert alert-success text-center mb-5 p-3"
			role="alert"
		>
			<ul class="list-unstyled fs-5 fw-bold mb-0">
				<li class="d-flex justify-content-start align-items-center">
					<span class="">
						種別：
					</span>
					<span class="">
						{!! $vaccine_label !!}
					</span>
				</li>
				<li class="d-flex justify-content-start align-items-center my-2">
					<span class="">
						{!! __("lang.date.title") !!}：
					</span>
					<span class="">
						{!! \Carbon\Carbon::create(
							session()->get('booking.yy'),
							session()->get('booking.mm'),
							session()->get('booking.dd')
						)->isoFormat('YYYY年M月D日（ddd）') !!}
					</span>
				</li>
				<li class="d-flex justify-content-start align-items-center">
					<span class="">
						{!! __("lang.date.time") !!}：
					</span>
					<span class="">
						{!! \Carbon\Carbon::create(
							session()->get('booking.yy'),
							session()->get('booking.mm'),
							session()->get('booking.dd'),
							session()->get('booking.hh'),
							session()->get('booking.ii')
						)->format(__("lang.date.hhii")) !!}
					</span>
				</li>
				<li class="d-flex justify-content-start align-items-center mt-2">
					<span class="">
						会場：
					</span>
					<span class="">
						平和台病院
					</span>
				</li>
			</ul>
		</div>

		<div class="mb-3">
			<h6 class="text-center">
				個人情報
			</h6>
		</div>
		<ul class="list-group list-group-flush border-top border-bottom mb-5">
			<li class="list-group-item d-flex justify-content-between align-items-center py-3">
				<div class="">
					<span class="fw-bold">
						氏名
					</span>
				</div>
				<div class="ms-auto">
					{!! implode(' ', [
						session()->get('booking.patient_sname'),
						session()->get('booking.patient_gname'),
					]) !!}
				</div>
			</li>
			<li class="list-group-item d-flex justify-content-between align-items-center py-3">
				<div class="">
					<span class="fw-bold">
						氏名（かな）
					</span>
				</div>
				<div class="ms-auto">
					{!! implode(' ', [
						session()->get('booking.patient_skana'),
						session()->get('booking.patient_gkana'),
					]) !!}
				</div>
			</li>
			<li class="list-group-item d-flex justify-content-between align-items-center py-3">
				<div class="">
					<span class="fw-bold">
						生年月日
					</span>
				</div>
				<div class="ms-auto">
					{!! \Carbon\Carbon::create(
						session()->get('birthday.yy'),
						session()->get('birthday.mm'),
						session()->get('birthday.dd')
					)->isoFormat('YYYY年M月D日') !!}
				</div>
			</li>
			<li class="list-group-item d-flex justify-content-between align-items-center py-3">
				<div class="">
					<span class="fw-bold">
						年齢
					</span>
				</div>
				<div class="ms-auto">
					{!! session()->get('booking.age') !!}歳
				</div>
			</li>
			<li class="list-group-item d-flex justify-content-between align-items-center py-3">
				<div class="">
					<span class="fw-bold">
						性別
					</span>
				</div>
				<div class="ms-auto">
					{!! (session()->get('booking.gender')) ? '男性' : '女性' !!}
				</div>
			</li>
			<li class="list-group-item d-flex justify-content-between align-items-center py-3">
				<div class="">
					<span class="fw-bold">
						基礎疾患あり
					</span>
				</div>
				<div class="ms-auto">
					{!! (session()->get('booking.is_disease')) ? 'はい' : 'いいえ' !!}
				</div>
			</li>
			<li class="list-group-item d-flex justify-content-between align-items-center py-3">
				<div class="">
					<span class="fw-bold">
						携帯電話番号
					</span>
				</div>
				<div class="ms-auto">
					{!! session()->get('booking.mobile') !!}
				</div>
			</li>
			<li class="list-group-item d-flex justify-content-between align-items-center py-3">
				<div class="">
					<span class="fw-bold">
						郵便番号
					</span>
				</div>
				<div class="ms-auto">
					{!! session()->get('booking.zip') !!}
				</div>
			</li>
			<li class="list-group-item d-flex justify-content-between align-items-center py-3">
				<div class="">
					<span class="fw-bold">
						都道府県
					</span>
				</div>
				<div class="ms-auto">
					{!! $pref_label !!}
				</div>
			</li>
			<li class="list-group-item d-flex justify-content-between align-items-center py-3">
				<div class="">
					<span class="fw-bold">
						市町村区
					</span>
				</div>
				<div class="ms-auto">
					{!! session()->get('booking.address1') !!}
				</div>
			</li>
			<li class="list-group-item d-flex justify-content-between align-items-center py-3">
				<div class="">
					<span class="fw-bold">
						町域
					</span>
				</div>
				<div class="ms-auto">
					{!! session()->get('booking.address2') !!}
				</div>
			</li>
			<li class="list-group-item d-flex justify-content-between align-items-center py-3">
				<div class="">
					<span class="fw-bold">
						番地・建物名
					</span>
				</div>
				<div class="ms-auto">
					{!! session()->get('booking.address3') !!}
				</div>
			</li>
		</ul>

		@if (session()->get('booking.is_form'))
			<div class="mb-3">
				<h6 class="text-center">
					予診票
				</h6>
			</div>
			<ul class="list-group list-group-flush border-top border-bottom mb-0">
				@foreach ($form_list as $key => $value)
					@if (!$value['is_disabled'])
						@if($key != 5)
							<li class="list-group-item py-3">
								<dl class="mb-0">
									<dt class="mb-2">
										{!! nl2br($value['form_label']) !!}
									</dt>
									<dd class="mb-0">
										<ul class="list-unstyled mb-0">
											<li>
												回答 ：
												<span class="fw-bold">
													{!! __('lang.dictionary.is_yesno.' . session()->get("form.{$value['mtb_form_id']}.value")) !!}
												</span>
											</li>
											@if (session()->get("form.{$value['mtb_form_id']}.value"))
												@if (session()->get("form.{$value['mtb_form_id']}.subform1") !== null)
													<li>
														@if ($value['is_input_group1'])
															{!! session()->get("form.{$value['mtb_form_id']}.subform1") !!}{!! nl2br($value['subform1_label']) !!}
														@else
															{!! nl2br($value['subform1_label']) !!} ：
															<span>
																@if ($value['mtb_form_id'] == 12)
																	{!! \Carbon\Carbon::parse(session()->get("form.{$value['mtb_form_id']}.subform1"))->format('Y年n月j日') !!}
																@else
																	{!! session()->get("form.{$value['mtb_form_id']}.subform1") !!}
																@endif
															</span>
														@endif
													</li>
												@endif

												@if (session()->get("form.{$value['mtb_form_id']}.subform2") !== null)
													<li>
														{!! nl2br($value['subform2_label']) !!} ：
														<span>
															{!! session()->get("form.{$value['mtb_form_id']}.subform2") !!}
														</span>
													</li>
												@endif

												@if (session()->get("form.{$value['mtb_form_id']}.subform3") !== null)
													<li>
														{!! nl2br($value['subform3_label']) !!} ：
														<span>
															{!! session()->get("form.{$value['mtb_form_id']}.subform3") !!}
														</span>
													</li>
												@endif
											@endif
										</ul>
									</dd>
								</dl>
							</li>
						@else
							@if (session()->get('form.5.value'))
								<li class="list-group-item py-3">
									<dl class="mb-0">
										<dt class="mb-2">
											{!! nl2br($value['form_label']) !!}
										</dt>
										<dd class="mb-0">
											<ul class="list-unstyled mb-0">
												<li>
													回答 ：
													<span class="fw-bold">
														{!! __('lang.dictionary.is_yesno.' . session()->get("form.{$value['mtb_form_id']}.value")) !!}
													</span>
												</li>
												@if (session()->get("form.{$value['mtb_form_id']}.value"))
													@if (session()->get("form.{$value['mtb_form_id']}.subform1") !== null)
														<li>
															@if ($value['is_input_group1'])
																{!! session()->get("form.{$value['mtb_form_id']}.subform1") !!}{!! nl2br($value['subform1_label']) !!}
															@else
																{!! nl2br($value['subform1_label']) !!} ：
																<span>
																	@if ($value['mtb_form_id'] == 12)
																		{!! \Carbon\Carbon::parse(session()->get("form.{$value['mtb_form_id']}.subform1"))->format('Y年n月j日') !!}
																	@else
																		{!! session()->get("form.{$value['mtb_form_id']}.subform1") !!}
																	@endif
																</span>
															@endif
														</li>
													@endif

													@if (session()->get("form.{$value['mtb_form_id']}.subform2") !== null)
														<li>
															{!! nl2br($value['subform2_label']) !!} ：
															<span>
																{!! session()->get("form.{$value['mtb_form_id']}.subform2") !!}
															</span>
														</li>
													@endif

													@if (session()->get("form.{$value['mtb_form_id']}.subform3") !== null)
														<li>
															{!! nl2br($value['subform3_label']) !!} ：
															<span>
																{!! session()->get("form.{$value['mtb_form_id']}.subform3") !!}
															</span>
														</li>
													@endif
												@endif
											</ul>
										</dd>
									</dl>
								</li>
							@endif
						@endif
					@endif
				@endforeach
			</ul>
		@endif

	</div>
</section>
<!-- /.section -->

<!-- nav -->
<br><br><br><br>
<nav class="bar-bottom">
	<div class="d-grid gap-2 w-100">
		<button
			class="btn btn-success btn-lg w-100"
			type="submit"
			name="action"
			value="store"
		>
			<span class="fw-bold">
				予約を確定する
			</span>
		</button>
		<div class="d-flex">
			<div class="flex-grow-1 me-2">
				<a
					class="btn btn-outline-danger btn-lg border border-danger border-3 w-100"
					data-bs-toggle="modal"
					data-bs-target="#modal-cancel"
				>
					<span class="fw-bold">
						予約をやめる
					</span>
				</a>
			</div>
			<div>
				<a
					class="btn btn-outline-secondary btn-lg border border-secondary border-3"
					href="{!! route('frontend.covid.booking2.form.index') !!}"
				>
					<span class="fw-bold">
						{!! __("lang.button.back") !!}
					</span>
				</a>
			</div>
		</div>
	</div>
</nav>
<!-- /.nav -->

<!-- modal -->
<div
	class="modal fade"
	id="modal-cancel"
	data-bs-backdrop="static"
	data-bs-keyboard="false"
	tabindex="-1"
	aria-hidden="true"
>
	<div class="modal-dialog modal-dialog-centered">
		<div class="modal-content">
			<div class="modal-header">
				<h1 class="modal-title fs-5">
					予約をやめますか？
				</h1>
				<button
					type="button"
					class="btn-close"
					data-bs-dismiss="modal"
					aria-label="Close"
				></button>
			</div>
			<div class="modal-body">
				<p class="fs-5">「はい」を選択すると、予約を中止しHOME画面に戻ります。</p>
				<p class="fs-5">再度予約する場合はHOME画面の「予約にすすむ」ボタンより、手続きをしていただく必要があります。</p>
				<p class="fs-5">本当に中止してよろしいですか？</p>
			</div>
			<div class="modal-footer">
				<a
					class="btn btn-danger"
					{{-- href="{!! route('frontend.covid.booking.mypage.edit.destroy') !!}" --}}
					href="{!! route('frontend.covid.booking2.home.index') !!}"
				>
					<span class="fw-bold">
						{!! __("lang.dictionary.is_yesno.1") !!}
					</span>
				</a>

				<button
					class="btn btn-secondary"
					type="button"
					data-bs-dismiss="modal"
				>
					<span class="fw-bold">
						{!! __("lang.dictionary.is_yesno.0") !!}
					</span>
				</button>
			</div>
		</div>
	</div>
</div>
<!-- /.moda -->
{!! Form::close() !!}
@endsection

{{-- css --}}
@section('css')
<style>

</style>
@stop

{{-- js --}}
@section('js')
<script>
$(function() {
	//
});
</script>
@stop
