@extends('frontend.layouts.sticky')

{{-- content --}}
@section('content')
{!! Form::open($form) !!}

@if (session()->get('booking.is_form'))

	<!-- section -->
	<section class="mb-3">
		<div class="container">

			@include('frontend.layouts.components.progress')

			<div
				class="alert alert-primary mb-0 p-4"
				role="alert"
			>
				<h4 class="alert-heading text-center">
					予診票
				</h4>
				<hr>
				<p class="fw-bold mb-0">
					下記質問に全てご回答ください。
				</p>
			</div>
		</div>
	</section>
	<!-- /.section -->

	<!-- section -->
	<section class="mb-5">
		<div class="container">

			{{-- alert --}}
			@if($errors->any())
				<div class="alert alert-danger mb-4">
					<ul class="mb-0 ps-3">
						@foreach ($errors->all() as $error)
							<li>
								{!! $error !!}
							</li>
						@endforeach
					</ul>
				</div>
			@endif
			{{-- /.alert --}}

			@foreach($form_list as $key => $value)
				@if ($value['is_disabled'])
					<div class="">
						{!! Form::hidden("form[{$value['mtb_form_id']}][value]", 0) !!}
						{!! Form::hidden("form[{$value['mtb_form_id']}][subform1]", null) !!}
					</div>
				@else
					<div class="">
						<label
							class="form-label"
							for=""
						>
							<div class="mb-1">
								{{-- @if ($value['is_required'])
									<span class="badge rounded-pill text-bg-danger me-1">
										{!! __("lang.form.required") !!}
									</span>
								@endif --}}
								{{-- （質問{!! $key + 1 !!}） --}}
							</div>
							<div class="">
								{!! nl2br($value['form_label']) !!}
							</div>
						</label>
						<div>
							<div
								class="btn-group"
								role="group"
							>
								{!! Form::radio("form[{$value['mtb_form_id']}][value]", 1, (session()->get('form') === null) ? false : (session()->get("form.{$value['mtb_form_id']}.value") ? true : false), [
									'class' => 'btn-check',
									'id' => "form-{$value['mtb_form_id']}-1",
									'autocomplete' => 'off',
								]) !!}
								<label
									class="btn btn-outline-primary"
									for="form-{!! $value['mtb_form_id'] !!}-1"
									style="width:6rem"
								>
									<span class="fw-bold">
										はい
									</span>
								</label>
								{!! Form::radio("form[{$value['mtb_form_id']}][value]", 0, (session()->get('form') === null) ? false : (session()->get("form.{$value['mtb_form_id']}.value") ? false : true), [
									'class' => 'btn-check',
									'id' => "form-{$value['mtb_form_id']}-0",
									'autocomplete' => 'off',
								]) !!}
								<label
									class="btn btn-outline-primary"
									for="form-{!! $value['mtb_form_id'] !!}-0"
									style="width:6rem"
								>
									<span class="fw-bold">
										いいえ
									</span>
								</label>
							</div>
							
							@if ($value['is_subform1'])
								@if ($value['is_input_group1'])
									<div class="input-group input-group-lg mt-3">
										{!! Form::tel("form[{$value['mtb_form_id']}][subform1]", (session()->get('form') === null) ? '' : session()->get("form.{$value['mtb_form_id']}.subform1"), [
											'class' => 'form-control form-control-lg',
											'placeholder' => '',
										]) !!}
										<div class="input-group-text">
											<span class="small">
												{!! $value['subform1_label'] !!}
											</span>
										</div>
									</div>
								@else
									<div class="mt-3">
										<label
											class="form-label"
											for=""
										>
											<span class="">
												{!! $value['subform1_label'] !!}
											</span>
										</label>
										@if ($value['mtb_form_id'] == 12)
											{!! Form::date("form[{$value['mtb_form_id']}][subform1]", (session()->get('form') === null) ? '' : session()->get("form.{$value['mtb_form_id']}.subform1"), [
												'class' => 'form-control form-control-lg',
												'placeholder' => '',
											]) !!}
										@else
											{!! Form::text("form[{$value['mtb_form_id']}][subform1]", (session()->get('form') === null) ? '' : session()->get("form.{$value['mtb_form_id']}.subform1"), [
												'class' => 'form-control form-control-lg',
												'placeholder' => "{$value['maxlen_subform1']}文字以内でご入力ください",
												'maxlength' => $value['maxlen_subform1'],
											]) !!}
										@endif
									</div>
								@endif
							@endif

							@if ($value['is_subform2'])
								<div class="mt-3">
									<label
										class="form-label"
										for=""
									>
										<span class="">
											{!! $value['subform2_label'] !!}
										</span>
									</label>
									{!! Form::text("form[{$value['mtb_form_id']}][subform2]", (session()->get('form') === null) ? '' : session()->get("form.{$value['mtb_form_id']}.subform2"), [
										'class' => 'form-control form-control-lg',
										'placeholder' => "{$value['maxlen_subform2']}文字以内でご入力ください",
										'maxlength' => $value['maxlen_subform2'],
									]) !!}
								</div>
							@endif

							@if ($value['is_subform3'])
								<div class="mt-3">
									<label
										class="form-label"
										for=""
									>
										<span class="">
											{!! $value['subform3_label'] !!}
										</span>
									</label>
									{!! Form::text("form[{$value['mtb_form_id']}][subform3]", (session()->get('form') === null) ? '' : session()->get("form.{$value['mtb_form_id']}.subform3"), [
										'class' => 'form-control form-control-lg',
										'placeholder' => "{$value['maxlen_subform3']}文字以内でご入力ください",
										'maxlength' => $value['maxlen_subform3'],
									]) !!}
								</div>
							@endif

						</div>
					</div>
					<hr>
				@endif
			@endforeach
			
		</div>
	</section>
	<!-- /.section -->

@else

	<!-- section -->
	<section class="mb-3">
		<div class="container">

			{{-- alert --}}
			<div
				class="alert alert-warning"
				role="alert"
			>
				<h4 class="text-center mb-3">
					<i class="fa-solid fa-circle-info fa-fw fa-2x"></i>
				</h4>
				<p class="mb-0">
					我孫子市以外に住民票があり自治体の助成の対象となる方は、自治体発行の予診票にご記入のうえご持参ください。
				</p>
			</div>
			{{-- /.alert --}}
			
		</div>
	</section>
	<!-- /.section -->

@endif

<!-- nav -->
<br><br>
<nav class="bar-bottom">
	<div class="d-grid gap-2 w-100">
		@if (session()->get('booking.is_form'))
			<button
				class="btn btn-primary btn-lg"
				type="submit"
				name="action"
				value="store"
			>
				<span class="fw-bold">
					予約確認する
				</span>
			</button>
		@else
			<a
				class="btn btn-primary btn-lg"
				href="{!! route('frontend.covid.booking2.confirm.index') !!}"
			>
				<span class="fw-bold">
					予約確認する
				</span>
			</a>
		@endif
		<a
			class="btn btn-outline-secondary btn-lg border border-secondary border-2"
			href="{!! route('frontend.covid.booking2.guest.index') !!}"
		>
			<span class="fw-bold">
				{!! __("lang.button.back") !!}
			</span>
		</a>

		{{-- <div
			class="btn-group"
			role="group"
		>
			<a
				class="btn btn-outline-primary btn-lg border border-primary border-3 w-50"
				href="{!! route('frontend.covid.booking.qr.index') !!}"
			>
				<span class="fw-bold">
					{!! __("lang.button.back") !!}
				</span>
			</a>
			<button
				class="btn btn-primary btn-lg w-50"
				type="submit"
				name="action"
				value="store"
			>
				<span class="fw-bold">
					{!! __("lang.button.confirm") !!}
				</span>
			</button>
		</div> --}}
	</div>
</nav>
<!-- /.nav -->

{!! Form::close() !!}
@endsection

{{-- css --}}
@section('css')
<style>

</style>
@stop

{{-- js --}}
@section('js')
<script>
$(function() {
	
	
});
</script>
@stop
