@extends('frontend.layouts.cover')

{{-- content --}}
@section('content')

<!-- section -->
<section class="mb-4">

	<div class="text-center mb-3">
		<img
			class="img-fluid"
			src="{!! implode('/', [
				asset('img'),
				'cover.png',
			]) !!}"
		>
	</div>

	<div class="container">

		<div class="text-center mb-3">
			<h2 class="lh-base mb-0" style="color:#084298;">
				医療法人社団創造会 平和台病院<br>
				コロナワクチン接種予約アプリ
			</h2>
		</div>

	</div>
</section>
<!-- /.section -->

<!-- section -->
<section class="mb-5">
	<div class="container">

		@if ($timestamp_now > $timestamp_publish)

			{{-- alert --}}
			{{-- <div class="alert alert-danger mb-4">
				<h5 class="alert-heading text-center">
					印西市在住の方へ
				</h5>
				<hr>
				<p class="fw-bold mb-0">
					印西市の費用助成は2025年1月31日で終了となります。
				</p>
			</div> --}}
			{{-- /.alert --}}
			
			{{-- alert --}}
			<div class="alert alert-primary mb-4">
				<h5 class="alert-heading text-center">
					ご予約に関するご案内
				</h5>
				<hr>

				<ul class="mb-0 ps-3">
					<li class="mb-2">
						この接種は義務ではありません。接種は1回のみです。
					</li>
					<li class="mb-2">
						他の予防接種（インフルエンザなど）と同日の接種はできません。
					</li>
					<li class="mb-2">
						<dl class="mb-0">
							<dt>
								対象者
							</dt>
							<dd>
								12歳以上の方（ただし、16歳未満の方は保護者の同伴が必要です）
							</dd>
						</dl>
					</li>
					<li class="mb-2">
						<dl class="mb-0">
							<dt>
								接種料金（税込）
							</dt>
							<dd>
								<ol class="mb-2 ps-3">
									<li class="mb-2">
										12歳以上で各自治体の助成を受けない方<br>
										→　15,000円
									</li>
									<li class="mb-2">
										我孫子市民で接種を希望する日において満65歳以上の方、または60歳以上65歳未満で、心臓、腎臓もしくは呼吸器の機能またはヒト免疫不全ウイルスにより免疫の機能に障害を有する方<br>
										→　5,500円
									</li>
									<li class="mb-2">
										我孫子市民で生活保護を受けている方<br>
										→　無料
									</li>
									<li class="mb-2">
										満65歳以上の方は、各住所地の自治体による助成金を除いた金額（我孫子市民の方は5,500円）をお支払いいただきます。詳しくは各自治体へお問い合わせください。
									</li>
								</ol>
								※ 我孫子市民以外で各自治体の助成を受ける方は、各自治体へお問い合わせのうえ自治体発行の予診票をお持ちください。
							</dd>
						</dl>
					</li>
					<li class="mb-2">
						<dl class="mb-0">
							<dt>
								実施期間
							</dt>
							<dd>
								令和6年10月1日〜
							</dd>
						</dl>
					</li>
					<li class="mb-2">
						ご予約の変更、確認はマイページから可能です。
					</li>
					<li class="mb-2">
						お電話にてご予約いただくことも可能です。予約の変更やキャンセルもお電話で承ります。
						<p class="mt-2 mb-0">
							平和台病院 新型コロナワクチン接種コールセンター<br>
							電話：04−7189−7721
						</p>
					</li>
				</ul>
			</div>
			{{-- /.alert --}}

			{{-- card --}}
			<div class="card border-dark">
				<div class="card-body pb-2">
					<h5 class="card-title text-center">
						ご予約前に必ずお読みください
					</h5>
					<hr>

					<dl class="mb-0">
						<dt class="mb-2">
							予防接種の効果は?
						</dt>
						<dd>
							<span>
								新型コロナワクチンについては、国内外で実施された研究などにより、新型コロナウイルス感染症にかかった場合の入院や死亡等の重症化等を予防する重症化予防効果が認められたと報告されています。
							</span>
						</dd>
					</dl>
					<hr>

					<dl class="mb-0">
						<dt class="mb-2">
							予防接種の副反応は?
						</dt>
						<dd>
							<span>
								新型コロナワクチンの主な副反応として、接種後に注射した部分の痛み、疲労、頭 痛、筋肉や関節の痛み、寒気、下痢、発熱等がみられることがあります。こうした症状 の大部分は、接種後数日以内に回復しています。<br>
								稀な頻度でアナフィラキシー（急性のアレルギー反応）が発生したことが報告されています。もし、アナフィラキシーが起きたときには、医療機関ですぐに治療を行うことになります。
							</span>
						</dd>
					</dl>
					<hr>

					<dl class="mb-0">
						<dt class="mb-2">
							予防接種を受けることが適当ではない方
						</dt>
						<dd>
							<ul class="mb-2 ps-3">
								<li class="mb-2">
									明らかに発熱している方(通常は37.5°Cをこえる場合)
								</li>
								<li class="mb-2">
									重い急性疾患にかかっている方
								</li>
								<li class="mb-2">
									新型コロナウイルスワクチンの成分に対し、アナフィラキシーなどの重度の過敏性<br>
									（※1）の既往歴のある方
								</li>
								<li class="mb-2">
									その他、かかりつけ医に予防接種は受けない方がいいといわれた方、基礎疾患のある方は、接種にあたり、かかりつけ医とよく相談してください。
								</li>
							</ul>
							（※1）アナフィラキシーや、全身性の皮膚・粘膜症状・呼吸困難・頻脈・血圧低下等、アナフィラキシーを 疑わせる複数の症状
						</dd>
					</dl>
				</div>
			</div>
			{{-- /.card --}}

		@else

			{{-- alert --}}
			<div
				class="alert alert-danger mb-3"
				role="alert"
			>
				<h4 class="alert-heading text-center">
					予約受付のご案内
				</h4>
				<hr>
				<p class="fs-6 fw-bold mb-3">
					コロナワクチン接種のご予約は2024年9月25日（水）正午より受付を開始いたします。<br>
					ご理解のほどよろしくお願いいたします。
				</p>
				<p class="fs-6 fw-bold text-end mb-0">
					平和台病院
				</p>
			</div>
			{{-- /.alert --}}

		@endif

	</div>
</section>
<!-- /.section -->

@if ($timestamp_now > $timestamp_publish)
	<!-- nav -->
	<br><br>
	<nav class="bar-bottom">
		<div class="d-grid gap-2 w-100">
			<a
				class="btn btn-primary btn-lg"
				href="{!! route('frontend.covid.booking2.agreement.index') !!}"
			>
				<span class="fw-bold">
					上記を承諾して予約にすすむ
				</span>
			</a>
			<a
				class="btn btn-outline-primary btn-lg border border-primary border-2"
				href="{!! route('frontend.covid.booking2.mypage.signin.index') !!}"
			>
				<span class="fw-bold">
					予約変更・キャンセル
				</span>
			</a>
		</div>
	</nav>
	<!-- /.nav -->
@endif
@endsection

{{-- css --}}
@section('css')
<style>

</style>
@stop

{{-- js --}}
@section('js')
<script>
$(function() {
	//
});
</script>
@stop
