@extends('frontend.layouts.main')

{{-- content --}}
@section('content')
{!! Form::open($form) !!}
{!! Form::hidden('booking[yy]', $yy) !!}
{!! Form::hidden('booking[mm]', $mm) !!}
{!! Form::hidden('booking[dd]', $dd) !!}
{!! Form::hidden('booking[hh]', $hh) !!}
{!! Form::hidden('booking[ii]', $ii) !!}


@include('frontend.layouts.components.guest')

<!-- section -->
<section class="mb-2">
    <div class="container">

		<div
			class="alert alert-primary p-3"
			role="alert"
		>
            <p class="mb-0">
                <span class="fw-bold">変更希望日時を選択して、「確認する」をタップしてください。</span><br>
                <span class="fw-bold">前回接種日から３か月後の同日以降接種可能です。</span><br>
                    例）前回接種日：2023年4月1日<br>
                    　　接種希望日：2023年7月1日　接種可能
            </p>
        </div>

    </div>
</section>
<!-- /.section -->

<!-- section -->
<section class="mb-3">
    <div class="container">

        {{-- alert --}}
        @if ($errors->any())
            <div class="alert alert-danger mb-3">
                <ul class="mb-0 ps-3">
                    @foreach ($errors->all() as $error)
                        <li>
                            {!! $error !!}
                        </li>
                    @endforeach
                </ul>
            </div>
        @endif
        {{-- /.alert --}}


        <!-- toolbar -->
        <div class="d-flex justify-content-center align-items-center mb-3">
            <span class="">
                @if ($is_past)
                    <a class="" href="javascript:void(0)">
                        <i class="fa-solid fa-circle-chevron-left fa-fw fa-2x" style="color:gray;"></i>
                    </a>
                @else
                    <a class="" href="{!! route('frontend.covid.booking.mypage.edit.update', [$date['prev']['yy'], $date['prev']['mm']]) !!}">
                        <i class="fa-solid fa-circle-chevron-left fa-fw fa-2x"></i>
                    </a>
                @endif
            </span>
            <h2 class="mx-2">
                {!! \Carbon\Carbon::create($yy, $mm, 1)->format(__('lang.date.yymm')) !!}
            </h2>
            <span class="">
                <a class="" href="{!! route('frontend.covid.booking.mypage.edit.update', [$date['next']['yy'], $date['next']['mm']]) !!}">
                    <i class="fa-solid fa-circle-chevron-right fa-fw fa-2x"></i>
                </a>
            </span>
        </div>
        <!-- /.toolbar -->

        <div class="mb-3 overflow-auto">
            <div class="btn-group btn-group-lg" role="group">
                @for ($i = 1; $i <= $date['day']; $i++)
                    @if (isset($booking_list[$i]) && \Carbon\Carbon::create($yy, $mm, $i)->gte($enabled_date))
                        <a id="set-focus-{!! $i !!}"
                            class="btn btn btn-outline-primary text-nowrap px-1 {!! $i == $dd ? 'active' : '' !!}"
                            href="{!! route('frontend.covid.booking.mypage.edit.update', [$yy, $mm, $i]) !!}">
                    @else
                        <a class="btn btn btn-outline-secondary text-nowrap px-1 disabled" href="">
                    @endif
                    <ul class="list-unstyled fw-bold lead mb-0">
                        <li class="">
                            {!! $i !!}日
                        </li>
                        <li class="small">
                            （{!! \Carbon\Carbon::create($yy, $mm, $i)->isoFormat('ddd') !!}）
                        </li>
                    </ul>
                    </a>
                @endfor
            </div>
        </div>
    </div>
</section>
<!-- /.section -->

<!-- section -->
<section class="mb-5">
    <div class="container">
		@if(!is_null($vaccine['vaccine_label']))
			<div class="alert alert-primary text-center mb-3 py-2">
				<span class="fw-bold fs-2 mb-0">
					{!! $vaccine['vaccine_label'] !!}
				</span>
			</div>
		@endif

        @if ($booking_list && $time_list)
            <ul class="nav nav-tabs nav-justified mb-4">
                @foreach ($time_list as $i => $content)
                    <li class="nav-item">
                        <button class="nav-link {!! $i == $is_pm ? 'active' : '' !!}" id="tab{!! $i !!}"
                            data-bs-toggle="tab" data-bs-target="#tab{!! $i !!}-pane" type="button"
                            role="tab" aria-controls="tab{!! $i !!}-pane"
                            aria-selected="{!! $i == 0 ? 'true' : 'false' !!}">
                            <span class="lead fw-bold">
                                {!! __("lang.dictionary.is_ampm.{$i}") !!}
                            </span>
                        </button>
                    </li>
                @endforeach
            </ul>
            <div class="tab-content">
                @foreach ($time_list as $i => $content)
                    <div class="tab-pane fade {!! $i == $is_pm ? 'show active' : '' !!}" id="tab{!! $i !!}-pane"
                        role="tabpanel" aria-labelledby="tab{!! $i !!}" tabindex="0">
                        @foreach ($content as $key => $value)
                            <div class="mb-1">
                                {!! Form::radio(
                                    'time',
                                    '',
                                    isset($hh) && isset($ii) ? ($value['hh'] == $hh && $value['ii'] == $ii ? true : false) : false,
                                    [
                                        'class' => 'btn-check',
                                        'id' => "time{$i}-{$key}",
                                        'autocomplete' => 'off',
                                        'onclick' => "setTime({$value['hh']}, {$value['ii']})",
                                    ],
                                ) !!}
                                <label
                                    {{-- @if ($value['remain_number'] == 0) --}}
                                    @if ($value['remain_number'] == 0 || \Carbon\Carbon::create($yy, $mm, $dd, $value['hh'], $value['ii'])->lte(\Carbon\Carbon::now()))
                                        class="btn btn-outline-secondary w-100 disabled"
                                    @else
                                        class="btn btn-outline-{!! $value['remain_number'] > 5 ? 'primary border border-primary' : 'warning border border-warning' !!} border-2 w-100"
                                    @endif
                                    for="time{!! $i !!}-{!! $key !!}"
                                >
                                    <span class="fs-4 fw-bold me-2">
                                        {!! \Carbon\Carbon::create($yy, $mm, $dd, $value['hh'], $value['ii'])->format('H:i') !!}
                                    </span>
                                    <span class="fw-bold fs-4">
                                        @if ($value['remain_number'] == 0)
                                            ×
                                        @elseif($value['remain_number'] > 5)
                                            ○
                                        @else
                                            △
                                        @endif
                                    </span>
                                </label>
                            </div>
                        @endforeach
                    </div>
                @endforeach
            </div>
        @else
            <div class="alert alert-secondary text-center" role="">
                <span class="fw-bold lead">
                    予約できる時間帯はありません
                </span>
            </div>
        @endif

    </div>
</section>
<!-- /.section -->

<!-- nav -->
<br><br>
<nav class="bar-bottom">
    <div class="d-grid gap-2 w-100">
        <div class="d-flex">
            <div class="flex-grow-1 me-2">
                <button class="btn btn-primary btn-lg border border-primary border-3 w-100" type="submit"
                    name="action" value="store">
                    <span class="fw-bold">
                        {!! __("lang.button.confirm") !!}
                    </span>
                </button>
            </div>
            <div>
                <a class="btn btn-outline-secondary btn-lg border border-secondary border-3"
                    href="{!! route('frontend.covid.booking.mypage.vaccine.index') !!}">
                    <span class="fw-bold">
                        {!! __("lang.button.back") !!}
                    </span>
                </a>
            </div>
        </div>
    </div>
</nav>
<!-- /.nav -->
{!! Form::close() !!}
@endsection

{{-- css --}}
@section('css')
<style>

</style>
@stop

{{-- js --}}
@section('js')
<script>
    $(function() {
        //
    });

    let setTime = (hh, ii) => {
        $('input:hidden[name="booking[hh]"]').val(hh);
        $('input:hidden[name="booking[ii]"]').val(ii);
    };

    // set focus
    $(function() {
        const day = {!! $dd !!}
        day && $(`#set-focus-${day}`).focus();
    });
</script>
@stop
