@extends('frontend.layouts.main')

{{-- content --}}
@section('content')
{!! Form::open($form) !!}
{!! Form::hidden('booking[booking_code]', $booking['booking_code']) !!}
{!! Form::hidden('booking[yy]', $booking['yy']) !!}
{!! Form::hidden('booking[mm]', $booking['mm']) !!}
{!! Form::hidden('booking[dd]', $booking['dd']) !!}
{!! Form::hidden('booking[hh]', $booking['hh']) !!}
{!! Form::hidden('booking[ii]', $booking['ii']) !!}

@include('frontend.layouts.components.booking2.guest')

<!-- section -->
<section class="mb-4">
	<div class="container">

		<!-- alert -->
		<div class="alert alert-danger text-center" role="alert">
			<span class="fw-bold fs-5">
				予約を取り消します。<br>
				本当によろしいですか？
			</span>
		</div>
		<!-- /.alert -->

		<div class="btn-group btn-group-lg w-100" role="group">
			<button
				class="btn btn-danger"
				type="submit"
				name="action"
				value="destroy"
			>
				<span class="fw-bold">
					{!! __("lang.dictionary.is_yesno.1") !!}
				</span>
			</button>
			<a
				class="btn btn-outline-danger"
				href="{!! route('frontend.covid.booking2.mypage.guest.show') !!}"
			>
				<span class="fw-bold">
					{!! __("lang.dictionary.is_yesno.0") !!}
				</span>
			</a>
		</div>

	</div>
</section>
<!-- /.section -->

<!-- section -->
<section class="mb-4">
	<div class="container">
		
		<ul class="list-group list-group-flush">
			<li class="list-group-item d-flex justify-content-between align-items-center py-3">
				<div class="">
					<span class="fw-bold">
						氏名
					</span>
				</div>
				<div class="ms-auto">
					{!! implode(' ', [
						$booking['patient_sname'],
						$booking['patient_gname'],
					]) !!}
				</div>
			</li>
			<li class="list-group-item d-flex justify-content-between align-items-center py-3">
				<div class="">
					<span class="fw-bold">
						氏名（かな）
					</span>
				</div>
				<div class="ms-auto">
					{!! implode(' ', [
						$booking['patient_skana'],
						$booking['patient_gkana'],
					]) !!}
				</div>
			</li>
			<li class="list-group-item d-flex justify-content-between align-items-center py-3">
				<div class="">
					<span class="fw-bold">
						生年月日
					</span>
				</div>
				<div class="ms-auto">
					{!! \Carbon\Carbon::create($booking['birthday'])->isoFormat('YYYY年M月D日') !!}
				</div>
			</li>
			<li class="list-group-item d-flex justify-content-between align-items-center py-3">
				<div class="">
					<span class="fw-bold">
						性別
					</span>
				</div>
				<div class="ms-auto">
					{!! __("lang.dictionary.gender.{$booking['gender']}") !!}
				</div>
			</li>
			<li class="list-group-item d-flex justify-content-between align-items-center py-3">
				<div class="">
					<span class="fw-bold">
						基礎疾患あり
					</span>
				</div>
				<div class="ms-auto">
					{!! $booking['is_disease'] ? 'はい' : 'いいえ' !!}
				</div>
			</li>
			<li class="list-group-item d-flex justify-content-between align-items-center py-3">
				<div class="">
					<span class="fw-bold">
						携帯電話番号
					</span>
				</div>
				<div class="ms-auto">
					{!! $booking['mobile'] !!}
				</div>
			</li>
			<li class="list-group-item d-flex justify-content-between align-items-center py-3">
				<div class="">
					<span class="fw-bold">
						郵便番号
					</span>
				</div>
				<div class="ms-auto">
					{!! $booking['zip'] !!}
				</div>
			</li>
			<li class="list-group-item d-flex justify-content-between align-items-center py-3">
				<div class="">
					<span class="fw-bold">
						都道府県
					</span>
				</div>
				<div class="ms-auto">
					{!! $booking['pref_label'] !!}
				</div>
			</li>
			<li class="list-group-item d-flex justify-content-between align-items-center py-3">
				<div class="">
					<span class="fw-bold">
						市町村区
					</span>
				</div>
				<div class="ms-auto">
					{!! $booking['address1'] !!}
				</div>
			</li>
			<li class="list-group-item d-flex justify-content-between align-items-center py-3">
				<div class="">
					<span class="fw-bold">
						以降の住所
					</span>
				</div>
				<div class="ms-auto">
					{!! $booking['address2'] !!}
				</div>
			</li>
		</ul>

	</div>
</section>
<!-- /.section -->

{!! Form::close() !!}
@endsection

{{-- css --}}
@section('css')
<style>

</style>
@stop

{{-- js --}}
@section('js')
<script>
	$(function() {
		//
	});
</script>
@stop
