@extends('frontend.layouts.sticky')

{{-- content --}}
@section('content')
@include('frontend.layouts.components.booking2.guest')

<!-- section -->
<section class="mb-2">
	<div class="container">

		<article class="text-center">
			<svg width="116px" height="116px" viewBox="0 0 116 116" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
				<g id="Page-1" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
					<g transform="translate(-122.000000, -113.000000)">
						<g id="check" transform="translate(122.000000, 113.000000)">
							<circle  fill="#CEFFCF" cx="58" cy="58" r="58"></circle>
							<circle  fill="#00D803" cx="58" cy="58" r="44"></circle>
							<g transform="translate(45.000000, 47.000000)" fill="#FFFFFF">
								<path d="M8.625,17.325 L2.9375,11.6375 C2.30375,11.00375 1.29625,11.00375 0.6625,11.6375 C0.02875,12.27125 0.02875,13.27875 0.6625,13.9125 L7.47125,20.72125 C8.105,21.355 9.12875,21.355 9.7625,20.72125 L26.9875,3.5125 C27.62125,2.87875 27.62125,1.87125 26.9875,1.2375 C26.35375,0.60375 25.34625,0.60375 24.7125,1.2375 L8.625,17.325 Z"></path>
							</g>
						</g>
					</g>
				</g>
			</svg>
			<br><br>
			<h2 class="text-success mb-3">
				変更を承りました
			</h2>
			<div
				class="alert alert-success text-center p-3"
				role="alert"
			>
				<ul class="list-unstyled fs-4 fw-bold mb-0">
					<li class="d-flex justify-content-start align-items-center">
						<span class="">
							種別：
						</span>
						<span class="">
							{!! session()->get('booking.vaccine_label') !!}
						</span>
					</li>
					<li class="d-flex justify-content-start align-items-center my-0">
						<span class="">
							{!! __("lang.date.title") !!}：
						</span>
						<span class="">
							{!! \Carbon\Carbon::create(
								session()->get('booking.yy'),
								session()->get('booking.mm'),
								session()->get('booking.dd')
							)->isoFormat('YYYY年M月D日（ddd）') !!}
						</span>
					</li>
					<li class="d-flex justify-content-start align-items-center">
						<span class="">
							{!! __("lang.date.time") !!}：
						</span>
						<span class="">
							{!! \Carbon\Carbon::create(
								session()->get('booking.yy'),
								session()->get('booking.mm'),
								session()->get('booking.dd'),
								session()->get('booking.hh'),
								session()->get('booking.ii'),
							)->format(__("lang.date.hhii")) !!}
						</span>
					</li>
				</ul>
			</div>
		</article>

	</div>
</section>
<!-- /.section -->

<!-- nav -->
<br><br><br><br>
<nav class="bar-bottom">
	<div class="d-grid gap-2 w-100">
		<a class="btn btn-outline-secondary btn-lg border border-secondary border-3"
			href="{!! route('frontend.covid.booking2.mypage.guest.show') !!}">
			<span class="fw-bold">
				HOME
			</span>
		</a>
	</div>
</nav>
<!-- /.nav -->
{!! Form::close() !!}
@endsection

{{-- css --}}
@section('css')
<style>

</style>
@stop

{{-- js --}}
@section('js')
<script>
	
	$(function() {
		// 
	});
</script>
@stop
